package hek.de.hinni.hek.asteroids;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

//import org.apache.log4j.Logger;
/*
 * 
 * Initialisiert Spielwelt
 * 
 * main loop
 * 
 * deligiert Arbeit an andere Klassen
 */
public class World extends Frame {
	public static int letzterSchussWinkel = -1; 
//	public static final Logger logger = Logger.getLogger(World.class);
	public static int MAXFRAMES = 18000;
	public static boolean SHOWGRAPHICS = false;
	
	public static GameStatus gameStatus;
	private static FramePacket frame;
	public static KeysPacket keys;
	private static ServerConnection serverConnection;
	private static WorldObjects worldObjects;
	
	private static int ticks;
	private static byte prevFrameNo;
	private static StatusFlags statusFlags;
	private static TastenTyp letzteTaste; //es dauert einen Frame bis Auswirkung des Tastendrucks angezeigt wird
	private static TastenTyp vorLetzteTaste; //es dauert einen Frame bis Auswirkung des Tastendrucks angezeigt wird
	private Strategie myStrategie;

	private Graphics2D offscreenGraphics;
	private Image offscreenImage;
	private VolatileImage v;
	private long startTime = System.currentTimeMillis();
	
	private boolean winkelMessung=false;
	
	private static List<ScreenChangedListener> screenChangedListener =  new LinkedList<ScreenChangedListener>();
	
	/*
	 * reset Daten
	 */
	private static void clear(ServerConnection server) {
		gameStatus = new GameStatus();
		frame = new FramePacket();
		keys = new KeysPacket();
		worldObjects = new WorldObjects();
		statusFlags = StatusFlags.NOTHING;
		serverConnection = server;
		ticks = 0;
		prevFrameNo = 0;
		letzteTaste = TastenTyp.NICHTS;
		vorLetzteTaste = TastenTyp.NICHTS;
		
	}
	
	private static void sendeDaten() throws IOException {
		String s = keys.toString();
//		if (s.length()>0) logger.info(keys);
		serverConnection.send(keys);
	}
	/*
	 * überprüft ob Saucer, Ships, asteroids existieren und setzt die flags
	 */
	private static void setzeStatus() {
		statusFlags.clear();

		if(gameStatus.getShip() != null)
			statusFlags.add(StatusFlags.SHIP_EXISTS);
		if(gameStatus.getSaucer() != null)
			statusFlags.add(StatusFlags.SAUCER_EXISTS);
		if (gameStatus.getAsteroids().size() > 0)
			statusFlags.add(StatusFlags.ASTEROIDS_EXIST);
		//TODO: erkennt nur alle schuesse bisher
		if (gameStatus.getShots().size() > 0)
			statusFlags.add(StatusFlags.ENEMY_SHOTS_EXIST);

	}
	private static void empfangeDaten() throws IOException{
		serverConnection.receive(frame);
	}
	public static int  getTick() {
		return ticks;
	}


	private static void incTick(int d) {
		ticks+=d;
	}

	/*private void setTick(int newTick) {
		ticks = newTick;
	}*/
	public World(ServerConnection server) {
		
		
		clear(server);
		worldObjects = new WorldObjects();
		keys.restart(true);
		
		
		System.out.println("MaxFrames:"+MAXFRAMES);
		System.out.println("ShowGrafics:"+SHOWGRAPHICS);
		
		//frame
		if (SHOWGRAPHICS)
		{
		this.setTitle( "Asteroid-OutputScreen" );
	    this.setSize( Position.screenSizeX/Position.FAKTOR,Position.screenSizeY/Position.FAKTOR);
	    this.setVisible(true);
	    
	    
	    offscreenImage = createImage( Position.screenSizeX/Position.FAKTOR, Position.screenSizeY/Position.FAKTOR);
	    offscreenGraphics = (Graphics2D)offscreenImage.getGraphics();
	    v = createVolatileImage(Position.screenSizeX/Position.FAKTOR, Position.screenSizeY/Position.FAKTOR);
	    offscreenGraphics = (Graphics2D)v.getGraphics();
	    
	    addWindowListener(
	    	      new WindowAdapter() {
	    	        public void windowClosing( WindowEvent ev ) {
	    	          dispose();
	    	          System.exit( 0 ); } } );
		}
	}
	
	public static int latenz() {
		return keys.getPing() - frame.getPing();
	}

	private static void interpretierBild() {
		gameStatus.interpretScreen(frame, ticks);
	}
	public static void tastenDruck(TastenTyp typ) {
		
		if (!World.statusFlags.ueberpruefe(StatusFlags.SHIP_EXISTS))
		{
			keys.restart(true);
			return;
		}
		
		if (worldObjects.getMyShip()==null) return;
		
		if (typ.tasteGedrueckt(TastenTyp.LINKS))
			worldObjects.getMyShip().drehLinks(keys, statusFlags);
		if (typ.tasteGedrueckt(TastenTyp.RECHTS))
			worldObjects.getMyShip().drehRechts(keys, statusFlags);


		if (typ.tasteGedrueckt(TastenTyp.BESCHLEUNIGE))
			worldObjects.getMyShip().beschleunige(keys, statusFlags);
		if (typ.tasteGedrueckt(TastenTyp.HYPERSPACE))
			worldObjects.getMyShip().hyperSpace(keys, statusFlags);
		if (typ.tasteGedrueckt(TastenTyp.FEUER))
			worldObjects.getMyShip().schiess(keys, statusFlags);
		if (typ.tasteGedrueckt(TastenTyp.NICHTS))
			worldObjects.getMyShip().nichts(keys, statusFlags);
		if (typ.tasteGedrueckt(TastenTyp.NEUSTART))
			worldObjects.getMyShip().neustart(keys, statusFlags);
		
		vorLetzteTaste = letzteTaste;
		letzteTaste = typ;
	
		
		
	}
	/*
	 * Ueberprüft ob die lokale Version synchron zur Serverversion läuft
	 * TODO:Noch nicht vollständig
	 */
	
	public void ueberpruefeSynchronisierung() {

		
		
		//if (true) return; 
		//�berpr�fe erfolg des tastendrucks beim schiff
		if (!statusFlags.ueberpruefe(StatusFlags.SHIP_EXISTS)) 
			return;
		
		MyShip s = worldObjects.getMyShip();
		Ship t = gameStatus.ship; //eins vorher;
		if (s==null || t==null) return;
		
		Vector ps = s.getOrientation();
		Vector pt = t.getOrientation();
		if (ps==null || pt==null) return;
		
//		if (ps.getX()!=pt.getX() || ps.getY()!=pt.getY()){
//			logger.warn("Sync-Error: Unexpected orientation after key("+letzteTaste+")! Expected: "
//					+ps+" - got from mame:"+pt+" (ship angleIndexByte="+s.angleIndexByte+")");
//		}
		
		
	}
	/*
	 * Das Spiel ist so konzipiert, dass der Server seine Daten raussendet sobald er einen Tastendruck empfaengt
	 * da ist die Auswirkung der Taste noch nicht mit einberechnet. deswegen muss man die Auswirkung hier "simulieren"
	 */
	public void berechneAuswirkung(TastenTyp letzteTaste,int framesSkipped) {
		if (letzteTaste == TastenTyp.LINKS || letzteTaste == TastenTyp.RECHTS)
			//behandelt das weiterdrehen w�hrend des lags
			for(int i=framesSkipped;i>0;i--)
				worldObjects.getMyShip().execute(letzteTaste, statusFlags);
	}
	
	/**
	 * Implements the main game loop.
	 *
	 * @throws IOException
	 * @throws InterruptedException
	 */
	public void run() throws IOException, InterruptedException {
		String[] tmp = new String[4000];
		for (int i=0; i < 4000; i++) {
			tmp[i] = "case " + (i -2000)+":";
		}

		
	
//		myStrategie = new WinkelMessung(); winkelMessung=true;
//		myStrategie = new TonyStrategieSimple();
		myStrategie = new TonyStrategieSimpleAiming();
//		myStrategie = new TonyStrategieBaumSuche();
//		myStrategie = new HinniStrategieKomplex();
//		myStrategie = new StrategieHinniStatistik();
		
		while(true) {
			
				
			// in order to determine latency each sent packet increments the ping value
			keys.setPing((byte) (keys.getPing() + 1));

			
			sendeDaten();
			empfangeDaten();
			
			//aktualisiere formal framenummer
			int d = frame.getFrameNo()-prevFrameNo;
			if (d == 0)continue;
			if (d <  0) d+=256;
//			if (d != 1) logger.warn("Sync-Error! Lost "+(d-1)+" Frames. (last FrameNo="+prevFrameNo+" current="+frame.getFrameNo());
			incTick(d);
			prevFrameNo = frame.getFrameNo();
			
			if (getTick()>MAXFRAMES)
			{
				long endTime = System.currentTimeMillis();
				
				System.out.println(""+MAXFRAMES+"18000 Frames completed (in "+
						(((float)(endTime-startTime))/60000)+" min). Exiting!");
				System.exit(0);
			}
			
			interpretierBild();
			setzeStatus();
			
			if (!winkelMessung)
			{
				worldObjects.updateStatus(gameStatus, statusFlags, ticks,vorLetzteTaste,d);
//				worldObjects.updateStatus(gameStatus, statusFlags, ticks);
				ueberpruefeSynchronisierung();
				berechneAuswirkung(letzteTaste,d);
			}

			keys.clear(); //loesche alte tasten
			//berechne naechste taste
			TastenTyp eingabe = myStrategie.getEingabe(worldObjects, statusFlags, ticks);
			tastenDruck(eingabe);
			if (eingabe.tasteGedrueckt(TastenTyp.FEUER))
				letzterSchussWinkel = worldObjects.getMyShip().angleIndexByte;
			
			//ausgabe
			this.repaint();
			
		}
	
	}
	
	@Override
	public void paint(Graphics gg )
	{
		if(!SHOWGRAPHICS) return;
		Graphics2D g = (Graphics2D)gg;
		
		if (offscreenGraphics==null) return;
		offscreenGraphics.clearRect(0,0,this.getWidth(), this.getHeight());
		
		if (myStrategie != null)
		myStrategie.draw(offscreenGraphics);
		
		if (worldObjects.getMyShip()!=null)
			worldObjects.getMyShip().draw(offscreenGraphics);

		if (worldObjects.getMySaucer()!=null)
			worldObjects.getMySaucer().draw(offscreenGraphics);
		
		for (MyAsteroid a: worldObjects.getMyAsteroids())
			if (a!=null) a.draw(offscreenGraphics);

		for (MyShot a: worldObjects.getMyShots())
			if(a!=null) a.draw(offscreenGraphics);
		
//		g.drawImage( offscreenImage, 0, 0, this );
		g.drawImage( v, 0, 0, this );
		

	}
	
	@Override
	public void update( Graphics g )
	{
	  paint( g );
	}
	
	public static void addScreenChangedListener(ScreenChangedListener l)
	{
		screenChangedListener.add(l);
	}
	public static void removeScreenChangedListener(ScreenChangedListener l)
	{
		screenChangedListener.remove(l);
	}
	
	public static void notifyScreenChangedListener()
	{
		for(ScreenChangedListener s:screenChangedListener)
			s.screenChanged();
	}


	
}
