package hek.de.hinni.hek.asteroids;

import java.util.ArrayList;
import java.util.List;

//import org.apache.log4j.Level;
//import org.apache.log4j.Logger;

/*
 * 
 * hier sind alle Objekte zu finden, die ausgelesen werden aus dem Screen
 * die Objekte, die aus dem Screen ausgelesen haben, haben keine Idendität
 * hier wir den Objekten ihre Identität zugewiesen
 */
public class WorldObjects {
	
//	public static final Logger logger = //logger.getLogger(WorldObjects.class);
	private MyShip myShip;
	private MySaucer mySaucer;
	private List<MyAsteroid> myAsteroids = new ArrayList<MyAsteroid>();
	private List<MyShot> myShots = new ArrayList<MyShot>();
	public static int numShots;
	
	public WorldObjects() {
		//myShip = new MyShip(new Ship(0,0,0,0,0),0);
		//mySaucer= new MySaucer(new Saucer(0,0, Saucer.Size.SMALL,0),0);
		myShip = null;
		mySaucer =  null;
	}
	/*
	 * ordnet die Asteroiden auf dem Screen ihren Identitäten zu
	 * @return: Liste der Asteroiden die nicht gefunden wurden
	 */
	public List<MyAsteroid> findeAsteroiden(List<Asteroid> asteroids) {
		
		//convertiere coordinaten
		for (Asteroid a: asteroids)	a.toInternPosition();
		
		//convertiere in neuen listentyp (Position)
		ArrayList<Position> p = new ArrayList<Position>();
		for (Asteroid a: asteroids)	p.add(a);
		
		
		List<MyAsteroid> toBeDeleted = new ArrayList<MyAsteroid>();
		//ueberpruefe erstmal Asteroiden, bei denen die Bewegung schon bekannt ist
		for (MyAsteroid a: myAsteroids) {
			////logger.debug("Ich ueberpruefe Bewegungsbekannte Asteroiden");
			if (a.bewegungIstGenau()) {
				if (!a.findeMyObject(p)) //finde den Asteroiden
					toBeDeleted.add(a); //wurde nicht mehr gefunden, also vermutlich zerstört, lösch ihn aus Liste
			}
			
		}
		////logger.debug(toBeDeleted.size() + "\n");
		//jetzt ueberpruefe alle Asteroiden, wo man bisher noch keine Geschwindigkeit feststellen konnte
		for (MyAsteroid a: myAsteroids) {
			////logger.debug("Ich ueberpruefe Asteroiden ohne bekannte Bewegung");
			if (!a.bewegungIstGenau()) {
				if (!a.findeMyObject(p)) //finde den Asteroiden
					toBeDeleted.add(a);

			}
		}
		
		int count=0;
		MyAsteroid b;
		//und jetzt ueberpruefe alle neuen Asteroiden
		for (Asteroid a: asteroids) {
			if (!a.getMarkierung()) { //Asteroid wurde bisher noch nicht zugeordnet also ist neu
				b = new MyAsteroid(a);
				myAsteroids.add(b);
				count++;
				////logger.debug("Neuer Asteroid gefunden:"+b);
			}
			else
				a.markiere(false);
		}
		if (count!=0)
		{
			//logger.debug("AST(tot="+asteroids.size()+"): add "+count+" new, rem "+toBeDeleted.size()+" old");
			//logger.debug("note from add ast"+count);
			//logger.debug("ScreenChanged");
			World.notifyScreenChangedListener();
			
		}

	//	if (count!=0 && count==toBeDeleted.size())
			//logger.warn("ASTERR(tot="+asteroids.size()+"): add "+count+" new, rem "+toBeDeleted.size()+" old");
		
		return toBeDeleted;
	}
	/*
	 * ordnet die Shots auf dem Screen ihren Identitäten zu
	 * @return: Liste der Shots die nicht gefunden wurden
	 */
	public List<MyShot> findeShots(List<Shot> shots) {
		
		numShots=shots.size();
		
		
		for (Shot s: shots)	s.toInternPosition();
		
		ArrayList<Position> p = new ArrayList<Position>();
		for (Shot a: shots)	p.add(a);
		
		List<MyShot> toBeDeleted = new ArrayList<MyShot>();
		//ueberpruefe erstmal Asteroiden, bei denen die Bewegung schon bekannt ist
		for (MyShot a: myShots) {
			if (a.bewegungIstGenau()) {
				if (!a.findeMyObject(p)) //finde den Asteroiden
					toBeDeleted.add(a); //wurde nicht mehr gefunden, also vermutlich zerstört, lösch ihn aus Liste
			}
			
		}
		////logger.debug(toBeDeleted.size() + "\n");
		//jetzt ueberpruefe alle Asteroiden, wo man bisher noch keine Geschwindigkeit feststellen konnte
		for (MyShot a: myShots) {
			////logger.debug("Ich ueberpruefe Asteroiden ohne bekannte Bewegung");
			if (!a.bewegungIstGenau()) {
				if (!a.findeMyObject(p)) //finde den Asteroiden
					toBeDeleted.add(a);

			}
		}
	
		int count=0;
		//TODO: hier wird der id-counter staendig erhoeht
		MyShot s;
		int lsw = World.letzterSchussWinkel;
		//und jetzt ueberpruefe alle neuen Schuesse
		for (Shot a: shots) {
			if (!a.getMarkierung()) 
			{ //Asteroid wurde bisher noch nicht zugeordnet also ist neu
				if (lsw != -1) 
				{
					if (Position.distance(a, myShip.getPosition()) < 250) {
						
						Position startPoint = new Shot(
								myShip.getPosition().getX()+MyShip.shots[lsw][MyShip.PX],
								myShip.getPosition().getY()+MyShip.shots[lsw][MyShip.PY],
								a.getZeitpunkt());
						
						
						Vector dir = new Vector(
								MyShip.shots[lsw][MyShip.DX],
								MyShip.shots[lsw][MyShip.DY],0f,Integer.MAX_VALUE,1f);
						
						s = new MyShot(startPoint,dir);
						//myShots.add(s);
						
						lsw = -1;
					}
					else 
						s = new MyShot(a);
				}
				else 
					s = new MyShot(a);
				////logger.debug("Neuer Shot gefunden:"+a);
				myShots.add(s);
				count++;
				
			}
			else
				a.markiere(false);
		}
		if (count!=0)
		{
			//logger.debug("AST(tot="+shots.size()+"): add "+count+" new, rem "+toBeDeleted.size()+" old");
			//logger.debug("note from add shot"+count);
			//logger.debug("ScreenChanged");
			World.notifyScreenChangedListener();
		}
		return toBeDeleted;
	}
	
	/*
	 * 
	 * holt sich die aktuellen Daten aus dem GameStatus
	 * 
	 */
	public void updateStatus(GameStatus status, StatusFlags objectExist, int aktTick, TastenTyp vlt, int latenz) {
		if (objectExist.ueberpruefe(StatusFlags.SHIP_EXISTS)) {
			if (myShip == null) {
				status.getShip().toInternPosition();
				myShip = new MyShip(status.getShip());
				
				//logger.debug("ScreenChanged");
				World.notifyScreenChangedListener();
				//logger.debug("note from ship");
			}
			else {
				status.getShip().toInternPosition();
				myShip.setPosition(status.getShip());
			}
			//myShip.setOrientation(status.getShip());
			myShip.setOrientation(status.getShip(),vlt,latenz);

		}
		if (objectExist.ueberpruefe(StatusFlags.SAUCER_EXISTS))
			if (mySaucer == null) {
				status.getSaucer().toInternPosition();
				mySaucer = new MySaucer(status.getSaucer());
				//logger.warn("ScreenChanged");
				World.notifyScreenChangedListener();
				//logger.debug("note from sauc");

			}
			else {
				status.getSaucer().toInternPosition();
				mySaucer.setPosition(status.getSaucer());
			}
		else {
			mySaucer = null;
		}
		List<MyAsteroid> toBeDeleted = findeAsteroiden(status.getAsteroids());
		for (MyAsteroid a: toBeDeleted) {
			myAsteroids.remove(a);
		}
		List<MyShot> toBeDeletedShots = findeShots(status.getShots());
		for (MyShot a: toBeDeletedShots) {
			myShots.remove(a);
		}
		
		if (toBeDeleted.size()!=0 || toBeDeletedShots.size()!=0)
		{
			//logger.debug("ScreenChanged");
			World.notifyScreenChangedListener();
			//logger.debug("note from shot or ast"+toBeDeleted.size()+toBeDeletedShots.size());
		}

	}

	public MyShip getMyShip() {
		return myShip;
	}
	public List<MyAsteroid> getMyAsteroids() {
		return myAsteroids;
	}
	public List<MyShot> getMyShots() {
		return myShots;
	}
	public MySaucer getMySaucer() {
		return mySaucer;
	}
}
