// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.i18n.swing;

import de.caff.i18n.I18n;

import javax.swing.*;
import java.util.Locale;
import java.util.MissingResourceException;

/**
 *  Utility class for i18n settings.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
class I18nHelper
{
  /**
   *  Set the relevant properties of a menu item.
   *  @param menuItem  menu item which properties are set
   *  @param tag       base i18n tag
   *  @param locale    locale to use
   */
  public static void setProperties(JMenuItem menuItem, String tag, Locale locale)
  {
    setProperties((AbstractButton)menuItem, tag, locale);
    try {
      menuItem.setAccelerator(KeyStroke.getKeyStroke(I18n.getString(tag+I18n.SUFFIX_ACCELERATOR, locale)));
    } catch (MissingResourceException e) {
    }
  }

  /**
   *  Set the relevant properties of a button.
   *  @param button  button which properties are set
   *  @param tag     base i18n tag
   *  @param locale  locale to use
   */
  public static void setProperties(AbstractButton button, String tag, Locale locale)
  {
    button.setText(I18n.getString(tag+I18n.SUFFIX_TEXT, locale));
    try {
      button.setToolTipText(I18n.getString(tag+I18n.SUFFIX_TOOLTIP, locale));
    } catch (MissingResourceException e) {
    }
    try {
      button.setMnemonic(I18n.getString(tag+I18n.SUFFIX_MNEMONIC, locale).charAt(0));
    } catch (Exception e) {
    }
  }

  /**
   *  Set the relevant properties of a label.
   *  @param button  label which properties are set
   *  @param tag     base i18n tag
   *  @param locale  locale to use
   */
  public static void setProperties(JLabel button, String tag, Locale locale)
  {
    button.setText(I18n.getString(tag+I18n.SUFFIX_TEXT, locale));
    try {
      button.setToolTipText(I18n.getString(tag+I18n.SUFFIX_TOOLTIP, locale));
    } catch (MissingResourceException e) {
    }
  }
}
