package de.heise.anniversary.contest.asteroids;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

/**
 * The <code>ServerConnection</code> class implements the network communication with the server.
 * <p>
 * It uses blocking UDP sockets.
 */
public class ServerConnection {
	public final int SERVER_PORT = 1979;
	protected DatagramSocket socket;

	/**
	 * Initializes this connection with server <code>serverName</code>.
	 *
	 * @param serverName
	 * 			the name of the server
	 * @throws SocketException
	 * @throws UnknownHostException
	 */
	public ServerConnection(String serverName) throws SocketException,
			UnknownHostException {
		this.socket = new DatagramSocket();
		this.socket.connect(InetAddress.getByName(serverName), SERVER_PORT);
		// TODO socket is not non-blocking; does it matter? Can their be new
		// decisions without new input?
	}

	/**
	 * Closes the network connection. Must be called to free resources.
	 */
	public void close() {
		socket.close();
	}

	/**
	 * Receive a <code>FramePacket</code> from the server.
	 *
	 * This call blocks and waits until a packet with the right size arrives.
	 *
	 * @param framePacket
	 * 			the <code>FramePacket</code> to be filled with the received data
	 * @throws IOException
	 * @see FramePacket
	 */
	public void receive(FramePacket framePacket) throws IOException {
		DatagramPacket datagramPacket = framePacket.getDatagramPacket();
		while (true) {
			socket.receive(datagramPacket);
			if (datagramPacket.getLength() != FramePacket.SIZE) {
				System.out.println("received packet with wrong size");
				continue;
			}
			break;
		}
	}

	/**
	 * Send the <code>keysPacket</code> data to the server.
	 *
	 * @param keysPacket
	 * 			the data to be sent to the server
	 * @throws IOException
	 * @see KeysPacket
	 */
	public void send(KeysPacket keysPacket) throws IOException {
		socket.send(keysPacket.getDatagramPacket());
	}
}
