/*
created: Jun 27, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
*/

package asteroids;

import static asteroids.AsteroidsConstants.*;

import java.awt.Color;

import asteroids.data.ShotData;
import de.heise.anniversary.contest.asteroids.Position;



public class Bullet
{
  private final static int BULLET_LAG = 2;
  private final static Color[] COLORS = new Color[]
    { Color.CYAN, Color.MAGENTA, Color.BLUE, Color.YELLOW, Color.GREEN };
  
  private static int nextColor;
  private static int misses;
  
  private Color color;
  private int sx, sy;
  private int[][] slot;
  private int age;
  private Target target;
  private int lastDist = Integer.MAX_VALUE;
  private boolean missed;
  private boolean removed;
  private int startFrame;
  
  
  
  public Bullet(Position pos, int angleCounter, Target target, GameWorld world)
  {
    startFrame = world.getFrameNo();
    sx = pos.getX();
    sy = pos.getY();
    slot = ShotData.getData(angleCounter);
    this.target = target;
    color = target.getColor();
    if (color == Target.DEFAULT_COLOR) {
      color = COLORS[nextColor];
      target.setColor(color);
      nextColor = (nextColor + 1) % COLORS.length;
    }
  }
  
  
  public void sync(GameWorld world)
  {
    age++;
    
    /*
    if (isTrackable() && !missed) {
      int dist = Tools.calcDistance(getX(), getY(), target.getX(), target.getY());
      if (dist > lastDist) {
        // vorbei geschossen
        missed = true;
        if (world.getTargetMonitor().isAlive(target)) {
          misses++;
          System.out.println("TARGET NOT HIT: " + target.getKind() + "  " + misses);
        }
      }
      lastDist = dist;
    }
    */
  }
  
  
  public int getFrameAge(GameWorld world)
  {
    return world.getFrameNo() - startFrame;
  }


  public Target getTarget()
  {
    return target;
  }


  public Color getColor()
  {
    return color;
  }


  public int getX()
  {
    return sx + slot[age - BULLET_LAG][0];
  }
  
  
  public int getY()
  {
    return sy + slot[age - BULLET_LAG][1];
  }
  
  
  public boolean isTrackable()
  {
    return age >= BULLET_LAG;
  }
  
  
  public boolean isExpired()
  {
    return removed || age >= ShotData.SLOT_SIZE;
  }


  public boolean isMissed()
  {
    return missed;
  }


  public void registerRemove()
  {
    this.removed = true;
  }
}
