/*
created: Jun 17, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
*/

package asteroids;

import static asteroids.AsteroidsConstants.*;

import java.awt.Color;
import java.util.*;

import de.heise.anniversary.contest.asteroids.*;



public class Target
{
  public final static int BUFFER_SIZE = 32;
  public final static int SUITABLE_BUFFER_FILL = 8;
  public final static int SHOT_LIVE = 60;
  public final static Color DEFAULT_COLOR = Color.DARK_GRAY;
  
  private static int failures;
  
  private TargetKind kind;
  private int x;
  private int y;
  private Asteroid.Type asteroidType;
  
  private int[] xBuf = new int[BUFFER_SIZE];
  private int[] yBuf = new int[BUFFER_SIZE];
  private int bufNextPos;
  private int bufPrevPos;
  private int bufFill;
  private int distance;
  private int etcFrame;
  //private double collisionAngle;
  
  private TurnDirection canBeHit; // null = kann nicht getroffen werden
  private int hitTurnFrames;
  private int hitShotFrames;
  
  private List<Bullet> fire = new ArrayList<Bullet>();
  private Color color = DEFAULT_COLOR;
  
  
  
  public Target(TargetKind kind, Asteroid subject)
  {
    this.kind = kind;
    
    if (!kind.isUfo()) {
      asteroidType = subject.getType();
    }
  }
  
  
  private void clearBuffer()
  {
    bufPrevPos = 0;
    bufNextPos = 0;
    bufFill = 0;
  }
  
  
  public void setPosition(int x, int y)
  {
    if (getKind() == TargetKind.SMALL_UFO && bufFill >= 3) {
      //System.out.println("ufo speed: " + getSpeedX() + "/" + getSpeedY());
      float sx = getSpeedX();
      int esx = x - xBuf[bufPrevPos];
      float sy = getSpeedY();
      int esy = y - yBuf[bufPrevPos];
      if ((esx != 0 || esy != 0) /* TODO macht UFO Pause? */ &&
           Math.abs(esx) < 3 && Math.abs(esy) < 3 &&
          (Math.abs(sx - esx) > 0.7 || Math.abs(sy - esy) > 0.7)) {
        System.out.println("* UFO changed direction *  " + esx + "/" + esy + "  " +
                           Math.abs(sx - esx) + "/" + Math.abs(sy - esy));
        clearBuffer();
      }
    }
    
    this.x = x;
    this.y = y;
    
    xBuf[bufNextPos] = x;
    yBuf[bufNextPos] = y;
    
    bufPrevPos = bufNextPos;
    bufNextPos++;
    if (bufNextPos == BUFFER_SIZE) {
      bufNextPos = 0;
    }
    if (bufFill < BUFFER_SIZE) {
      bufFill++;
    }
  }
  
  
  
  public TargetKind getKind()
  {
    return kind;
  }


  public int getX()
  {
    return x;
  }


  public int getY()
  {
    return y;
  }


  public Asteroid.Type getAsteroidType()
  {
    return asteroidType;
  }
  
  
  public int getDistance()
  {
    return distance;
  }


  public void updateDistance(Position pos)
  {
    distance = Tools.calcDistance(pos.getX(), pos.getY(), x, y);
  }
  
  
  public boolean isBufferSuitableFilled()
  {
    return bufFill >= SUITABLE_BUFFER_FILL;
  }


  // 0-3
  public int getEstimationAccuracy()
  {
    if (bufFill >= BUFFER_SIZE) {
      return 3;
    }
    if (bufFill >= SUITABLE_BUFFER_FILL) {
      return 2;
    }
    if (bufFill >= 3) {
      return 1;
    }
    return 0;
  }
  
  
  // beruecksichtigt Distanz
  public boolean isGoodEstimation()
  {
    int ea = getEstimationAccuracy();
    if (ea == 3) {
      return true;
    }
    else if (ea == 0) {
      return false;
    }
    else {
      return bufFill >= Math.min(distance / getKind().getMinRadius() / 2, BUFFER_SIZE);
    }
  }
  
  
  private int getOldestBufferIndex()
  {
    if (bufFill >= BUFFER_SIZE) {
      return bufNextPos;
    }
    else {
      return 0;
    }
  }
  
  
  public float getSpeedX()
  {
    if (bufFill < 2) {
      return 0.0f;
      //throw new AssertionError("Buffer not suitable");
    }
    
    int startIndex = getOldestBufferIndex();
    int diff = Tools.correctDistX(x - xBuf[startIndex]);
    
    if (Math.abs(diff) > WIDTH / 2) {
      throw new AssertionError("Illegal DiffX: " + diff);
    }
    
    float speed = (float) diff / (float) (bufFill - 1);
    if (Math.abs(speed) > 10) {
      System.out.println("!!! WRONG SPEED: " + speed);
    }
    return speed;
  }
  
  
  public float getSpeedY()
  {
    if (bufFill < 2) {
      return 0.0f;
      //throw new AssertionError("Buffer not suitable");
    }
    
    int startIndex = getOldestBufferIndex();
    int diff = Tools.correctDistY(y - yBuf[startIndex]);
    
    if (Math.abs(diff) > HEIGHT / 2) {
      throw new AssertionError("Illegal DiffY: " + diff);
    }
    
    float speed = (float) diff / (float) bufFill;
    if (Math.abs(speed) > 10) {
      System.out.println("!!! WRONG SPEED: " + speed);
    }
    return speed;
  }
  
  
  /*public double getHeading()
  {
    return Tools.calcAngle(getSpeedX(), getSpeedY());
  }*/
  
  
  public int estimateX(int frames)
  {
    int ex = x + (int) (getSpeedX() * frames);
    return Tools.correctX(ex);
  }
  
  
  public int estimateY(int frames)
  {
    int ey = y + (int) (getSpeedY() * frames);
    return Tools.correctY(ey);
  }


  public boolean isOnCollision()
  {
    return etcFrame != 0;
  }


  public void setOnCollision(int frame/*, double heading*/)
  { 
    /*String s = "onCollision: " + (etc - System.currentTimeMillis()) +
               "  " + Tools.calcCompassAngle(heading) + "";
    if (etc == 0) {
      s += " REMOVED";
    }
    System.out.println(s);*/
    
    //this.onCollision = onCollision;
    this.etcFrame = frame;
    //this.collisionAngle = heading;
  }


  // expected time of collision
  public int getEtcFramesLeft(GameWorld world)
  {
    return etcFrame - world.getFrameNo();
  }


  /*public double getCollisionAngle()
  {
    return collisionAngle;
  }*/
  
  
  public void registerFire(Bullet bullet)
  {
    //firedCounter += SHOT_LIVE;
    fire.add(bullet);
  }
  
  
  public int getFireCount()
  {
    int fc = 0;
    
    for (Bullet b : fire) {
      if (!b.isExpired() && !b.isMissed()) {
        fc++;
      }
    }
    
    return fc;
    
    //return (firedCounter + SHOT_LIVE - 1) / SHOT_LIVE;
  }
  
  
  public int getFireFrameAge(GameWorld world)
  {
    int fa = Integer.MAX_VALUE;
    
    for (Bullet b : fire) {
      int a = b.getFrameAge(world);
      if (a < fa) {
        fa = a;
      }
    }
    
    return fa;
  }
  
  
  public boolean isFirePermission(GameWorld world)
  {
    int extraShots = 0;
    int tc = world.getTargetMonitor().getTargetCount() * 2 -
             world.getTargetMonitor().getTargetCount(TargetKind.SMALL_ASTEROID);
    if (tc <= 3) {
      extraShots = 1;
      if (tc <= 2) {
        extraShots = 2;
      }
    }
    
    int fc = getFireCount();
    
    if (isOnCollision() && fc == 0) {
      return true;
    }
    
    if (fc > 0 && getFireFrameAge(world) > 3) {
      // Salve unterbrochen
      return false;
    }
    
    //if (true) return fc <= 0 + extraShots;
    
    switch (getKind()) {
      case SMALL_ASTEROID :
        return fc <= 0 + extraShots;
      case MEDIUM_ASTEROID :
        return fc <= 1 + extraShots;
      case BIG_ASTEROID :
        return fc <= 3 + extraShots;
      default :
        // UFO
        return fc <= 1 + extraShots;
    }
  }
  
  
  public boolean isDistanceOk(GameWorld world)
  {
    //if (true) return true; // TODO ?
    
    if (getFireCount() > 0) {
      return true;
    }
    
    //int sc = world.getGameStatus().getShots().size();
    
    if (isOnCollision() || getKind().isUfo() || getKind() != TargetKind.BIG_ASTEROID) {
      return true;
    }
    /*else if (sc - getFireCount() <= 0) {
      // Salve
      return true;
    }*/
    else {
      int smc = world.getTargetMonitor().getTargetCount(TargetKind.SMALL_ASTEROID) +
                world.getTargetMonitor().getTargetCount(TargetKind.MEDIUM_ASTEROID);
      int maxDist = 2400 / (smc + 1);
      return getDistance() <= Math.max(maxDist, 200);
    }
  }


  public TurnDirection getHitDirection()
  {
    return canBeHit;
  }


  public void setHitDirection(TurnDirection canBeHit)
  {
    this.canBeHit = canBeHit;
  }


  public int getHitTurnFrames()
  {
    return hitTurnFrames;
  }


  public void setHitTurnFrames(int hitTurnFrames)
  {
    this.hitTurnFrames = hitTurnFrames;
  }


  public int getHitShotFrames()
  {
    return hitShotFrames;
  }


  public void setHitShotFrames(int hitShotFrames)
  {
    this.hitShotFrames = hitShotFrames;
  }


  public Color getColor()
  {
    return color;
  }


  public void setColor(Color color)
  {
    this.color = color;
  }
}
