/*
created: Jun 24, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
*/

package asteroids;

import static asteroids.AsteroidsConstants.*;
import asteroids.data.ShotData;
import de.heise.anniversary.contest.asteroids.Ship;



public class TargetAnalyzer
{
  private final static int ANGLE_FRAMES = 40;
  private final static int TURN_LAG = 2;
  private final static int VECTOR_SIZE = ShotData.SLOT_SIZE + ANGLE_FRAMES + SHOT_LAG + TURN_LAG;
  
  private int[][] tx    = new int[ASTEROID_MAX][VECTOR_SIZE];
  private int[][] ty    = new int[ASTEROID_MAX][VECTOR_SIZE];
  
  
  
  private void initTargetData(GameWorld world)
  {
    TargetMonitor targets = world.getTargetMonitor();
    
    for (int ti=0; ti<targets.getTargetCount(); ti++) {
      Target t = targets.getTarget(ti);
      
      float x = t.getX();
      float y = t.getY();
      float vx = t.getSpeedX();
      float vy = t.getSpeedY();
      
      for (int cycle=0; cycle<VECTOR_SIZE; cycle++) {
        tx[ti][cycle] = Tools.correctX(Math.round(x));
        ty[ti][cycle] = Tools.correctY(Math.round(y));
        x += vx;
        y += vy;
      }
    }
  }
  
  
  // 0 oder Anzahl der Shot Frames
  private int calcHit(Ship ship, int targetIndex, int angleCounter, int turnFrames)
  { 
    int ac = Tools.mathModulo(angleCounter, 256);
    int[][] slot = ShotData.getData(ac);
    if (slot == null) {
      return 0;
    }
    
    for (int i=0; i<slot.length; i++) {
      int sx = ship.getX() + slot[i][0];
      int sy = ship.getY() + slot[i][1];
      //Tools.correctX(sx);
      //Tools.correctY(sy);
      int x = tx[targetIndex][turnFrames + SHOT_LAG + TURN_LAG + i];
      int y = ty[targetIndex][turnFrames + SHOT_LAG + TURN_LAG + i];
      
      int r = 10; //radius[targetIndex] * 3 / 2;
      if (Tools.calcDistance(sx, sy, x, y) <= r) {
        //System.out.println("hit: " + targetIndex);
        return i + SHOT_LAG + TURN_LAG;
      }
    }
    
    return 0;
  }
  
  
  private void updateTarget(Ship ship, int targetIndex, Target t, int angleCounter)
  {
    if (t.getEstimationAccuracy() == 0) {
      t.setHitDirection(null);
      return;
    }
    if (ship == null) {
      return;
    }
    
    for (int i=0; i<ANGLE_FRAMES; i++) {
      int frames = calcHit(ship, targetIndex, angleCounter + i, i);
      if (frames > 0 && i == 0) {
        //System.out.println("hit STILL");
        t.setHitDirection(TurnDirection.STILL);
        t.setHitTurnFrames(0);
        t.setHitShotFrames(frames);
        return;
      }
      else if (frames > 0) {
        //System.out.println("hit RIGHT");
        t.setHitDirection(TurnDirection.RIGHT);
        t.setHitTurnFrames(i);
        t.setHitShotFrames(frames);
        return;
      }
      else {
        frames = calcHit(ship, targetIndex, angleCounter - i, i);
        if (frames > 0) {
          //System.out.println("hit LEFT");
          t.setHitDirection(TurnDirection.LEFT);
          t.setHitTurnFrames(i);
          t.setHitShotFrames(frames);
          return;
        }
        else {
          // kann nicht getroffen werden
          t.setHitDirection(null);
        }
      }
    }
  }
  
  
  public void updateTargets(GameWorld world)
  {
    initTargetData(world);
    TargetMonitor targets = world.getTargetMonitor();
    
    for (int i=0; i<targets.getTargetCount(); i++) {
      updateTarget(world.getGameStatus().getShip(),
                   i, targets.getTarget(i), world.getAngleMonitor().getAngleCounter());
    }
  }
}
