/*
created: Jun 18, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
*/

package asteroids;

import static asteroids.AsteroidsConstants.*;

import java.awt.Toolkit;

import asteroids.data.ShotData;

import de.heise.anniversary.contest.asteroids.*;



public class TargetDetector
{
  private final static int SHIP_RADIUS = 20;
  private  final static int VECTOR_SIZE = ASTEROID_MAX;
  private final static int INTER_CYCLES = 4;
  
  private final static int RANGE_SHOOT = ShotData.SLOT_SIZE;
  private final static int RANGE_SCAN = 180;
  
  private float[] x      = new float[VECTOR_SIZE];
  private float[] y      = new float[VECTOR_SIZE];
  private float[] vx     = new float[VECTOR_SIZE];
  private float[] vy     = new float[VECTOR_SIZE];
  private boolean[] onCollision = new boolean[VECTOR_SIZE];
  
  
  
  private static boolean isHit(int x1, int y1, int x2, int y2, int r)
  {
    int dist = Tools.calcDistance(x1, y1, x2, y2);
    return dist <= r;
    
    /*
    // Approximation in Rechteck
    return Math.abs(x1 - x2) <= r &&
           Math.abs(y1 - y2) <= r;
           */
  }
  
  
  private boolean isAmmoAvailable(Target t, GameWorld world, TargetMonitor targets, int shotCount)
      // boolean someoneOnCollision)
  {
    if (t.isOnCollision()) {
      return true;
    }
    
    Target col = targets.getTargetOnCollision(world);
    if (col != null && col.getEtcFramesLeft(world) < 80 && shotCount >= 3) {
      return false;
    }
    else {
      return true;
    }
    
    /*
    if (t.isOnCollision() || targets.isUfo()) {
      return true;
    }
    
    int reserve;
    if (someoneOnCollision) {
      reserve = 1;
    }
    else {
      if ((t.getHitDirection() != null && t.getHitShotFrames() < 40) ||
          targets.getTargetCount() <= 7 ||
          t.getFireCount() == 0 ||
          t.getKind() == TargetKind.BIG_ASTEROID) {
        reserve = 0;
      }
      else {
        reserve = 1;
      }
    }
    
    return shotCount < SHOT_MAX - reserve;
    */
  }

  
  public Target detect(GameWorld world)
  {
    GameStatus game = world.getGameStatus();
    TargetMonitor targets = world.getTargetMonitor();
    
    if (game.getShip() == null ||
        targets.getTargetCount() == 0) {
      return null;
    }
    
    int shipX = game.getShip().getX();
    int shipY = game.getShip().getY();
    
    //float factor = 1.0f / Target.BUFFER_SIZE;
    int count = targets.getTargetCount();
    
    for (int i=0; i<count; i++) {
      //System.out.println("i=" + i);
      Target t = targets.getTarget(i);
      
      onCollision[i] = false;
      x[i] = t.getX();
      y[i] = t.getY();
      vx[i] = t.getSpeedX();
      vy[i] = t.getSpeedY();
      //radius[i] = t.getKind().getRadius();
    }
    
    int ac = world.getAngleMonitor().getAngleCounter();
    int[][] slot = ShotData.getData(ac);
    if (slot == null) {
      System.out.println("********************* EMPTY SLOT *************************> " + ac);
      return null;
    }
    
    for (int cycle=0; cycle<RANGE_SCAN; cycle++) {
      for (int interCycle=0; interCycle<INTER_CYCLES; interCycle++) {
        int sx = 0;
        int sy = 0;
        if (cycle >= SHOT_LAG && cycle < RANGE_SHOOT - 1) {
          int dx = slot[cycle - SHOT_LAG + 1][0] - slot[cycle - SHOT_LAG][0];
          int dy = slot[cycle - SHOT_LAG + 1][1] - slot[cycle - SHOT_LAG][1];
          sx = shipX + slot[cycle - SHOT_LAG][0] - dx / 2 + dx * (interCycle+1) / INTER_CYCLES;
          sy = shipY + slot[cycle - SHOT_LAG][1] - dy / 2 + dy * (interCycle+1) / INTER_CYCLES;
          //sx = Tools.correctX(sx);
          //sy = Tools.correctY(sy);
        }
        
        for (int i=0; i<count; i++) {
          if (vx[i] == 0 && vy[i] == 0) {
            continue;
          }
          
          x[i] += vx[i] / INTER_CYCLES;
          x[i] = Tools.correctX(x[i]);
          y[i] += vy[i] / INTER_CYCLES;
          y[i] = Tools.correctY(y[i]);
          Target target = targets.getTarget(i);
          
          if (isHit(shipX, shipY, (int) x[i], (int) y[i],
                    target.getKind().getMaxRadius() + SHIP_RADIUS)) {
            int etc = world.getFrameNo() + cycle;
            //double ca = Tools.calcAngle(t.getX() - shipX, t.getY() - shipY);
            target.setOnCollision(etc /*, ca*/);
            onCollision[i] = true;
          }
          
          if (cycle >= SHOT_LAG && cycle < RANGE_SHOOT &&
              (target.isGoodEstimation() || target.isOnCollision()) &&
              target.isFirePermission(world) &&
              target.isDistanceOk(world)) {
            //boolean someoneOnCollision = targets.getTargetsOnCollisionCount() > 0;
            int shotCount = game.getShots().size();
            if (isAmmoAvailable(target, world, targets, shotCount)) {
              int r = Math.min(target.getKind().getMinRadius(), 10);
              if (isHit(sx, sy, (int) x[i], (int) y[i], r)) {
                //System.out.println("target: ac=" + ac +
                //                   "  " + (x[i]-shipX) + "/" + (y[i]-shipY));
                return target;
              }
            }
          }
        }
      }
    }
    
    for (int i=0; i<count; i++) {
      Target t = targets.getTarget(i);
      if (!onCollision[i] && t.isBufferSuitableFilled()) {
        t.setOnCollision(0);
      }
    }
    
    return null;
  }
}
