/*
created: Jun 19, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
*/

package asteroids.behaviours;

import static asteroids.AsteroidsConstants.*;
import asteroids.*;
import asteroids.gui.DebugPainter;
import de.heise.anniversary.contest.asteroids.Ship;



public class DefenseBehaviour implements Behaviour
{
  private TurnDirection dir = TurnDirection.RIGHT;
  
  
  
  private static boolean shotAvailable(GameWorld world)
  {
    return world.getTargetMonitor().isUfo() ||
           world.getGameStatus().getShots().size() < SHOT_MAX;
  }
  

  public void action(GameWorld world)
  {
    AngleMonitor angle = world.getAngleMonitor();
    Ship ship = world.getGameStatus().getShip();
    
    Target t = world.getTargetDetector().detect(world);
    if (t != null && shotAvailable(world)) {
      if (world.fire()) {
        Bullet bullet = new Bullet(ship, angle.getAngleCounter(), t, world);
        world.getBulletMonitor().addBullet(bullet);
        t.registerFire(bullet);
      }
      //System.out.println("fire: " + world.getAngleMonitor().getAngleCounter());
    }
    
    t = world.getTargetMonitor().getTargetOnCollision(world);
    DebugPainter.get().setCollidingTarget(t);
    
    if (t != null) {
      int prio = 10;
      int timeLeft = t.getEtcFramesLeft(world) * 1000 / 60;
      if (timeLeft < 3000) {
        prio += 10;
        if (timeLeft < 1800) {
          prio += 30;
        }
      }
      
      /*
      double diff = Tools.calcAngleDiff(t.getCollisionAngle(), angle.getAngleRadian());
      if (Math.abs(diff) > 0.3) {
        dir = (diff >= 0) ? TurnDirection.LEFT : TurnDirection.RIGHT;
        //if (prio >= 50) {
        //System.out.println("urgent defense >>> " + dir + "   " + diff + "   " +
        //                   (t.getX() - ship.getX()) + "/" + (t.getY() - ship.getY()) +
        //                   "  " + timeLeft + "ms");
        //}
      }
      */
      
      if (t.getHitDirection() != null && t.getHitDirection() != TurnDirection.STILL) {
        dir = t.getHitDirection();
      }
      
      world.turn(dir, prio);
    }
  }

}
