/*
created: Jun 19, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
*/

package asteroids.behaviours;

import asteroids.*;
import asteroids.data.ShotData;
import de.heise.anniversary.contest.asteroids.*;



public class TestShotBehaviour implements Behaviour
{
  private TestShotState state = TestShotState.TURN;
  private TestShotState lastState;
  private int measureWait;
  private int[][] measurement = new int[ShotData.SLOT_SIZE][2];
  private int pos;
  
  
  
  public TestShotBehaviour()
  {
    for (int i=0; i<measurement.length; i++) {
      measurement[i] = new int[2];
    }
  }
  
  
  public void setState(TestShotState state)
  {
    this.state = state;
  }



  public void action(GameWorld world)
  {
    if (world.isFrameLost()) {
      throw new AssertionError("Frame lost while measuring shots");
    }
    
    if (state != lastState) {
      System.out.println("test shot state: " + state);
      lastState = state;
    }
    
    GameStatus game = world.getGameStatus();
    Ship ship = game.getShip();
    int ac = world.getAngleMonitor().getAngleCounter();
    
    if (game.getSaucer() != null) {
      state = TestShotState.TRIGGER;
      return;
    }
    
    switch (state) {
      case TRIGGER :
        if (world.getLastTurn() != TurnDirection.STILL) {
          break;
        }
        if (!world.getAngleMonitor().isFineAdjusted() || ShotData.existData(ac)) {
          System.out.println("fineAdjusted=" + world.getAngleMonitor().isFineAdjusted() +
                             "   existData=" + ShotData.existData(ac) +
                             "          ac=" + ac);
          state = TestShotState.TURN;
        }
        else if (/*world.getLastTurn() == TurnDirection.STILL &&*/
                 game.getShots().size() == 0) {
          world.fire();
          pos = 0;
          measureWait = 0;
          state = TestShotState.MEASURE;
        }
        break;
      case MEASURE :
        if (game.getShots().size() == 1) {
          Shot shot = game.getShots().get(0);
          //int dist = Tools.distance(ship.getX(), ship.getY(), shot.getX(), shot.getY());
          
          measurement[pos][0] = shot.getX() - ship.getX();
          measurement[pos][1] = shot.getY() - ship.getY();
          //System.out.println("ac=" + ac + "   " + measurement[pos][0] + "/" + measurement[pos][1]);
          pos++;
          if (pos == measurement.length) {
            double angle = world.getAngleMonitor().getAngleRadian();
            double measuredAngle = Tools.calcAngle(measurement[40][0], measurement[40][1]);
            System.out.println("angle: " + angle + "  measured: " + measuredAngle + "  wait: " + measureWait);
            if (Tools.calcAngleDistance(angle, measuredAngle) > 0.03) {
              throw new AssertionError("Wrong angle");
            }
            ShotData.setData(ac, measurement);
            state = TestShotState.TURN;
          }
        }
        else {
          if (measureWait == 3) {
            state = TestShotState.TRIGGER;
          }
          else {
            measureWait++;
          }
        }
        break;
      case TURN :
        /*
        int nextAc = world.getLastTurn() == TurnDirection.RIGHT ? (ac + 1) % 256 : ac;
        if (!world.getAngleMonitor().isFineAdjusted() || ShotData.existData(nextAc)) {
          world.turn(TurnDirection.RIGHT);
        }
        else*/
        if (world.getLastTurn() == TurnDirection.RIGHT)
        {
          world.turn(TurnDirection.STILL, 0);
          state = TestShotState.TRIGGER;
        }
        else {
          world.turn(TurnDirection.RIGHT, 0);
        }
        break;
    }
  }
  
  
  
  public static enum TestShotState {
    TRIGGER, /*WAIT,*/ MEASURE, TURN;
  }
}
