/*
created: Jun 24, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
*/

package asteroids.gui;

import java.io.IOException;

import javax.swing.JFrame;

import asteroids.GameWorld;
import de.caff.asteroid.*;



public class AsteroidsDisplay extends JFrame
{
  private FrameDisplay display;
  //private DebugPainter painter = new DebugPainter();
  
  
  
  public AsteroidsDisplay(FrameDisplay display)
  {
    this.display = display;
    
    //painter.setGameWorld(world);
    display.setDebugPainter(DebugPainter.get());
  }
  
  
  public void update(byte[] data, int frameCounter)
  {
    try {
      FrameInfo frame = new FrameInfo(frameCounter, data, null, 0);
      display.frameReceived(frame);
    }
    catch (IOException ex) {
      throw new RuntimeException(ex);
    }
  }
  
  
  public static AsteroidsDisplay showDisplay()
  {
    FrameDisplay display = new FrameDisplay(640);
    AsteroidsDisplay frame = new AsteroidsDisplay(display);
    frame.getContentPane().add(display);
    frame.pack();
    frame.setVisible(true);
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    return frame;
  }
}
