// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

/**
 *  A stupid player character which just presses thrust all the time and fires as fast as possible.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>
 */
public class StupidPlayer
        implements FrameListener,
                   GameData
{
  /** MAME access. */
  private Communication com;
  /** Press fire in next frame? */
  private boolean fire;

  /**
   *  Constructor.
   *  @param com communication with MAME
   */
  public StupidPlayer(Communication com)
  {
    this.com = com;
    com.addFrameListener(new HallOfFameFiller(com, "dumm!"));
  }

  /**
   * Called each time a frame is received.
   * <p/>
   * <b>ATTENTION:</b> this is called from the communication thread!
   * Implementing classes must be aware of this and take care by synchronization or similar!
   *
   * @param frame the received frame
   */
  public void frameReceived(FrameInfo frame)
  {
    if (frame != null  &&  frame.isGameRunning()) {
      if (frame.getSpaceShip() != null) {
        com.pushButton(BUTTON_THRUST);
        if (fire) {
          com.pushButton(BUTTON_FIRE);
        }
        fire = !fire;
      }
    }
  }
}
