// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.analysis;

import de.caff.asteroid.GameData;

/**
 *  Some shared constants used in dunp file i/o.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>.
 */
public interface FileFormat
        extends GameData
{
  /** Current version of de.caff format. */
  byte FORMAT_VERSION = '\0';
  /** de.caff prefix (vrsion 0)*/
  byte[] DECAFF_INTRO = {
          'A', 'S', 'T', '-', 'D', 'M', 'P', FORMAT_VERSION
  };

  /** Common prefix of c't format. */
  byte[] CT_INTRO_PREFIX = {
          0x63, 0x74, 0x6D, 0x61, 0x6D, 0x65
  };
  /** Additional prefix c't format, version 1. */
  byte[] CT_INTRO_POSTFIX_1 = {
          '1', 0x0D, 0x0A, 0x02, 0x00
  };
  /** Additional prefix c't format, version 2. */
  byte[] CT_INTRO_POSTFIX_2 = {
          '2', 0x0D, 0x0A, 0x02, 0x00
  };
  /** Marker for outgoing datagrams in de.caff format. */
  byte OUTGOING_MARKER = 'O';
  /** Marker for incoming datagrams in de.caff format. */
  byte INCOMING_MARKER = 'I';
}
