// ============================================================================
// File:               $File$
//
// Project:
//
// Purpose:
//
// Author:             Rammi
//
// Copyright Notice:   (c) 1999-2006  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date: 2006-02-01 13:48:49 +0100 (Mi, 01 Feb 2006) $
//
// History:	       $Log$
//=============================================================================

package de.caff.util.debug;

/**
 *  A listener for raw fatal error messages.
 *
 *  @see Debug
 *
 *  @author Rammi
 */
public interface FatalMessageDebugListener
{
  /**
   *  Receive a raw fatal error message and return whether the program shall be
   *  exited.
   *  @param   msg  the message
   *  @param   pos  position
   *  @return  unequal <code>0</code> -- exit the program<br>
   *           <code>0</code> -- go on
   */
  public int receiveFatalMessage(String msg, String pos);
}
