// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings;

import de.caff.i18n.I18n;

import java.util.Locale;

/**
 *  Base class used for enum values.
 * 
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
abstract class AbstractBasicEnumValue
        implements EnumValue
{
  /** The basic I18n tag. */
  private final String baseTag;

  /**
   *  Create an abstract basic enum value.
   *  @param baseTag basic i18n tag
   */
  protected AbstractBasicEnumValue(String baseTag)
  {
    this.baseTag = baseTag;
  }

  /**
   * Get a human readable name for this enum value.
   *
   * @param l locale to use
   * @return human readable short name
   */
  public String getShortName(Locale l)
  {
    return I18n.getString(baseTag+I18n.SUFFIX_TEXT, l);
  }

  /**
   * Get a longer description which describes this value.
   *
   * @param l locale to use
   * @return human readable description or <code>null</code> if no description is available
   */
  public String getLongName(Locale l)
  {
    String name = SettingsTools.getOptionalI18nString(baseTag+I18n.SUFFIX_DESCRIPTION, l);
    return name == null  ?  getShortName(l)  :  name;
  }

  /**
   * Get the basic enum value.
   * This is needed when wrappers are used.
   *
   * @return basic value
   */
  public EnumValue getBasicValue()
  {
    return this;
  }
}
