#include "KeysPacket.h"

KeysPacket::KeysPacket()
{
    signature[0] = 'c';
    signature[1] = 't';
    signature[2] = 'm';
    signature[3] = 'a';
    signature[4] = 'm';
    signature[5] = 'e';
    keys = '@';
    ping = 0;
}

void KeysPacket::clear()
{
    keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
    if (b)
	keys |= KEY_HYPERSPACE;
    else
	keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
    if (b)
	keys |= KEY_FIRE;
    else
	keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
    if (b)
	keys |= KEY_THRUST;
    else
	keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
    if (b)
    {
	keys |= KEY_LEFT;
	right(false);
    }
    else
	keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
    if (b)
    {
	keys |= KEY_RIGHT;
	left(false);
    }
    else
	keys &= ~KEY_RIGHT;
}

