// hyperspaziergang.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <getopt.h>

#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif


#include "player.h"
#include "Globals.h"

/* options descriptor */
static const char *shortopts = "vha";
static struct option longopts[] = {
    { "verbose",   0,     0,    'v' },
    { "help",      0,     0,    'h' },
    { "address",   1,     0,    'a' },
    { 0, 0, 0, 0 }
};

void Usage()
{
    printf("Usage: hyperspayziergang OPTIONS\n\navailable options\n");
    printf("\t-h\t--help\tprint this help messagen");
    printf("\t-v\t--verbose\tbe verbose\n");
    printf("\t-a\t--address\tIP address of MAME server\n\n");
}


bool verbose = false;



int main(int argc, char* argv[])
{
    // default values
    const char *par_ip = "127.0.0.1";

    // parse command line
    char ch;
    while ((ch = getopt_long(argc, argv, shortopts, longopts, 0)) != -1)
    {
	switch (ch) 
	{
	case 'v':
	    verbose = true;
	    break;
	    
	case 'a':
	    par_ip = optarg;
	    break;
	    
	case 'h':
	default:
	    Usage();
	    break;	    	   
	}
    }
    argc -= optind;
    argv += optind;
    

    // original code
	unsigned long server_ip = inet_addr(par_ip);
	if (server_ip == INADDR_NONE)
	{
		fprintf(stderr, "Ungueltige IP-Adresse: '%s'\n", argv[1]);
		exit(1);
	}

#if defined(WINDOWS)
	WSADATA wsadata;
	if (WSAStartup(MAKEWORD(2,2), &wsadata))
	{
		fprintf(stderr, "Fehler beim Initialisieren von Winsock.\n");
		exit(2);
	}
#endif


	SOCKET sd;
	sd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sd == INVALID_SOCKET)
	{
		fprintf(stderr, "Fehler %d bei socket().\n", WSAGetLastError());
		exit(2);
	}

#if defined(WINDOWS)
	unsigned long enable_nonblocking = 1;
	if (ioctlsocket(sd, FIONBIO, &enable_nonblocking))
	{
		fprintf(stderr, "Kann Socket nicht auf nonblocking setzen (%d)", WSAGetLastError());
		exit(1);
	}
#else
    if (-1 == fcntl(sd, F_SETFL, O_NONBLOCK))
    {
        perror("Kann Socket nicht auf non-blocking setzen");
        exit(1);
    }
#endif
	sockaddr_in sa;
	memset(&sa, 0, sizeof sa);
	sa.sin_family = AF_INET;
	sa.sin_addr.s_addr = 0;
	sa.sin_port = 0;

	if (bind(sd, (struct sockaddr*) &sa, sizeof sa))
	{
		fprintf(stderr, "Fehler %d bei bind().\n", WSAGetLastError());
		exit(2);
	}

	Player player(sd, server_ip);
	player.Run();

	return 0;
}
