// Zoltan Zomotor
// connection.cpp: Beispielspieler fr Asteroids (Verbindung zu Mame)
// Harald Bgeholz / c't; Umstrukturierung Matthias Fuchs

#include <errno.h>
#include <stdio.h>

#include <string.h>
#include <stdarg.h>

#if defined(WINDOWS) || defined(_WIN32)
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAEWOULDBLOCK EAGAIN
#define WSAGetLastError() errno
#endif


#include "connection.h"
#ifdef SIMULATION
   gzfile        Sim::gzf=NULL;
   bool          Sim::sim=0;
   unsigned char Sim::simkey='@';
   unsigned char Sim::aktkey='@';
   int           Sim::frame=0;
   char          Sim::ping=0;
#endif

FramePacket::FramePacket(void)
{
   frameno = 0;
   ping = 0;
   memset(vectorram,0,1024);
}

NamePacket::NamePacket(void){
  memset(signature,0,38);
  strcpy(signature,"ctname---DrZ---");
}

KeysPacket::KeysPacket(void)
{
   signature[0] = 'c';
   signature[1] = 't';
   signature[2] = 'm';
   signature[3] = 'a';
   signature[4] = 'm';
   signature[5] = 'e';
   keys = '@';
   ping = 0;
}
bool KeysPacket::getThrust(){
  return (keys & KEY_THRUST);
}

void KeysPacket::clear(void)
{
   keys = '@';
}
void KeysPacket::start(bool b){
  if (b)
    keys |= KEY_START;
  else
    keys &= ~KEY_START;
}

void KeysPacket::hyperspace(bool b)
{
   if (b)
      keys |= KEY_HYPERSPACE;
   else
      keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
   if (b)
      keys |= KEY_FIRE;
   else
      keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
   if (b)
      keys |= KEY_THRUST;
   else
      keys &= ~KEY_THRUST;
}


void KeysPacket::left(bool b)
{
   if (b)
   {
      keys |= KEY_LEFT;
      keys &= ~KEY_RIGHT;
   }
   else
      keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
   if (b)
   {
      keys |= KEY_RIGHT;
      keys &= ~KEY_LEFT;
   }
   else
      keys &= ~KEY_RIGHT;
}

bool KeysPacket::start(void) const
{
   return (keys & KEY_START) != 0;
}

bool KeysPacket::hyperspace(void) const
{
   return (keys & KEY_HYPERSPACE) != 0;
}

bool KeysPacket::fire(void) const
{
   return (keys & KEY_FIRE) != 0;
}

bool KeysPacket::thrust(void) const
{
   return (keys & KEY_THRUST) != 0;
}

bool KeysPacket::right(void) const
{
   return (keys & KEY_RIGHT) != 0;
}

bool KeysPacket::left(void) const
{
   return (keys & KEY_LEFT) != 0;
}


connection_error::connection_error (const char* format, ...)
{
   va_list arglist;
   va_start(arglist, format);

   vsprintf(message, format, arglist);

   va_end(arglist);
}


Connection::Connection (const char* server_ip_str)
:  sd (INVALID_SOCKET),
   server_ip (INADDR_NONE)
{
#if defined(WINDOWS) || defined(_WIN32)
   WSADATA wsadata;
   wsadata.wVersion = 0;      // Merker fr ungltig
#endif

   try
   {
#ifdef SIMULATION
     if(strncmp(basename((char *)server_ip_str),"asteroids",9)==0){
       sim.sim = true;
       sim.gzf = gzopen(server_ip_str,"rb");
       if (sim.gzf==NULL) throw connection_error("Error opening %s.\n",server_ip_str);
       unsigned char buf[1025];
       gzread(sim.gzf,buf,11);
       //       char header[11] = {0x63,0x74,0x6D, 0x61, 0x6D, 0x65, 0x32, 0x0D, 0x0A, 0x02, 0x00};
       char header[11] = "ctmame2\r\n";
       header[9]=0x02;
       header[10]=0x00;
       if (strncmp((char *)buf,header,11) != 0)
	 throw connection_error("falsches Fileformat\n");
       OutputInfo2("Header: %s",header);
       gzread(sim.gzf,buf,2); // PortNr.
       OutputInfo2("Port-Nr. 0x%X 0x%X\n",buf[0], buf[1]);
       gzread(sim.gzf,buf,4); // IP-Nr
       OutputInfo2("IP-Nr. %1d %1d %1d %1d\n",buf[0],buf[1],buf[2],buf[3]);
       gzread(sim.gzf,buf,8);
       for(int i=0;i<8;i++) 
	 if(buf[i] != 0)
	   throw connection_error("Lesefehler %d\n",i);

       gzread(sim.gzf,buf,32);
       OutputInfo2("Name: '%s'\n",buf);
//        int bytes_read = gzread(sim.gzf,buf,1025);
//        if(bytes_read==0)	throw game_over();
//        else if(bytes_read ==-1) throw  connection_error("Lesefehler recvfrom().\n");
//        else if(bytes_read != 1025) throw  connection_error("Nur %d bytes gelesen in recvfrom().\n",bytes_read);
       
       return;
     }
     sim.sim=false;
#endif
      server_ip = inet_addr(server_ip_str);
      if (server_ip == INADDR_NONE)
         throw connection_error("Ungueltige IP-Adresse: '%s'\n", server_ip_str);

#if defined(WINDOWS) || defined(_WIN32)
      if (WSAStartup(MAKEWORD(2,2), &wsadata))
         throw connection_error("Fehler beim Initialisieren von Winsock.\n");
#endif

      sd = socket(AF_INET, SOCK_DGRAM, 0);
      if (sd == INVALID_SOCKET)
         throw connection_error("Fehler %d bei socket().\n", WSAGetLastError());

#if defined(WINDOWS) || defined(_WIN32)
      unsigned long enable_nonblocking = 1;
      if (ioctlsocket(sd, FIONBIO, &enable_nonblocking))
#else
      if (-1 == fcntl(sd, F_SETFL, O_NONBLOCK))
#endif
         throw connection_error("Kann Socket nicht auf nonblocking setzen (%d)", WSAGetLastError());
      sockaddr_in sa;
      memset(&sa, 0, sizeof sa);
      sa.sin_family = AF_INET;
      sa.sin_addr.s_addr = 0;
      sa.sin_port = 0;

      if (bind(sd, (struct sockaddr*) &sa, sizeof sa))
         throw connection_error("Fehler %d bei bind().\n", WSAGetLastError());
   }
   catch (connection_error &ce)
   {
      if (sd != INVALID_SOCKET)
	//         closesocket (sd);
         close (sd);
#if defined(WINDOWS) || defined(_WIN32)
      if (wsadata.wVersion != 0)
         WSACleanup();
#endif

      throw;
   }
   catch (...)
   {
      throw;
   }
}


Connection::~Connection()
{
   if (sd != INVALID_SOCKET)
     //      closesocket (sd);
     close (sd);
#if defined(WINDOWS) || defined(_WIN32)
   WSACleanup();
#endif
#ifdef SIMULATION
   if(sim.sim && sim.gzf!=0) gzclose(sim.gzf);
#endif
}


bool Connection::IsLittleEndian (void) 
{
   static __int16 littleEndian = 1;

   return *reinterpret_cast<__int8*>(&littleEndian);
}

game_over::game_over(void){
  fprintf(stderr,"Game over\n");
}

busy::busy (const char* format, ...)
{
   va_list arglist;
   va_start(arglist, format);

   vsprintf(message, format, arglist);

   va_end(arglist);
}

void Connection::ReceivePacket(FramePacket &packet)
{
#ifdef SIMULATION
  sim.frame++;
  if(sim.sim){
    int bytes_read = gzread(sim.gzf,packet.vectorram,1024);
    if(bytes_read==0)	throw game_over();
    else if(bytes_read ==-1) throw  connection_error("Lesefehler recvfrom().\n");
    else if(bytes_read != 1024) throw  connection_error("Nur %d bytes gelesen in recvfrom().\n",bytes_read);

    bytes_read = gzread(sim.gzf,&sim.simkey,1);
    if(bytes_read==0)	throw game_over();
    else if(bytes_read ==-1) throw  connection_error("Lesefehler recvfrom().\n");
    else if(bytes_read != 1) throw  connection_error("Nur %d bytes gelesen in recvfrom().\n",bytes_read);
    OutputInfo2("old: %s%s%s%s%s sim: %s%s%s%s%s diff: %s%s%s%s%s",
		sim.simkey & sim.KEY_FIRE?      "F":"-",
		sim.simkey & sim.KEY_HYPERSPACE?"H":"-",
		sim.simkey & sim.KEY_LEFT?      "L":
		sim.simkey & sim.KEY_RIGHT?     "R":"-",
		sim.simkey & sim.KEY_THRUST?    "T":"-",
		sim.simkey & sim.KEY_START?     "S":"-",
		sim.aktkey & sim.KEY_FIRE?      "F":"-",
		sim.aktkey & sim.KEY_HYPERSPACE?"H":"-",
		sim.aktkey & sim.KEY_LEFT?      "L":
		sim.aktkey & sim.KEY_RIGHT?     "R":"-",
		sim.aktkey & sim.KEY_THRUST?    "T":"-",
		sim.aktkey & sim.KEY_START?     "S":"-",
		sim.simkey & sim.KEY_FIRE       ^ sim.aktkey & sim.KEY_FIRE?         "X":"-",
                sim.simkey & sim.KEY_HYPERSPACE ^ sim.aktkey & sim.KEY_HYPERSPACE?   "X":"-",
	       (sim.simkey & sim.KEY_LEFT       ^ sim.aktkey&sim.KEY_LEFT) ||      
	       (sim.simkey & sim.KEY_RIGHT      ^ sim.aktkey&sim.KEY_RIGHT)?         "X":"-",
		sim.simkey & sim.KEY_THRUST     ^ sim.aktkey&sim.KEY_THRUST?         "X":"-",
		sim.simkey & sim.KEY_START      ^ sim.aktkey&sim.KEY_START?          "X":"-");



    packet.frameno++;
    packet.ping=sim.ping;
    
    return;
  } else {
    OutputInfo2("akt: %s%s%s%s%s \n",
		sim.aktkey & sim.KEY_FIRE?      "F":"-",
		sim.aktkey & sim.KEY_HYPERSPACE?"H":"-",
		sim.aktkey & sim.KEY_LEFT?      "L":
		sim.aktkey & sim.KEY_RIGHT?     "R":"-",
		sim.aktkey & sim.KEY_THRUST?    "T":"-",
		sim.aktkey & sim.KEY_START?     "S":"-");
  }
#endif    
  //   sockaddr_in sender;
   fd_set readfds, writefds, exceptfds;
   do
   {
      FD_ZERO(&readfds);
      FD_ZERO(&writefds);
      FD_ZERO(&exceptfds);
      FD_SET(sd, &readfds);
      FD_SET(sd, &exceptfds);
      select(sd+1, &readfds, &writefds, &exceptfds, NULL);
      unsigned int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
      if(strncmp(packet.vectorram,"game over",strlen("game over"))==0)
	throw game_over();
      if(strncmp(packet.vectorram,"busy",strlen("busy"))==0)
	throw busy("%10s \n",packet.vectorram);
      if (bytes_received != sizeof packet)
	throw connection_error("Fehler %d bei recvfrom(). Vectorram '%s'\n", WSAGetLastError(), packet.vectorram);
      FD_ZERO(&readfds);
      FD_ZERO(&writefds);
      FD_ZERO(&exceptfds);
      FD_SET(sd, &readfds);
      timeval zero;
      zero.tv_sec = zero.tv_usec = 0;
      select(sd+1, &readfds, &writefds, &exceptfds, &zero);
   } while(FD_ISSET(sd, &readfds));

}


void Connection::SendPacket(const KeysPacket &packet)
{
#ifdef SIMULATION
  sim.aktkey=packet.getKeys();
  if(sim.sim){
    sim.ping = packet.ping;
    //    OutputInfo("\n");
    return;
  }
#endif
   sockaddr_in server;
   memset(&server, 0, sizeof server);
   server.sin_family = AF_INET;
   server.sin_port = htons(1979);
   server.sin_addr.s_addr = server_ip;
   unsigned int bytes_sent = sendto(sd, (char *)&packet, sizeof packet, 0,
      (sockaddr*)&server, sizeof server);
   if (bytes_sent != sizeof packet)
   {
      int err = WSAGetLastError();
      if (err != WSAEWOULDBLOCK)
         throw connection_error("Fehler %d bei sendto().\n", err);
   }
}
void Connection::SendPacket(const NamePacket &packet)
{
   sockaddr_in server;
   memset(&server, 0, sizeof server);
   server.sin_family = AF_INET;
   server.sin_port = htons(1979);
   server.sin_addr.s_addr = server_ip;
   unsigned int bytes_sent = sendto(sd, (char *)&packet, sizeof packet, 0,
      (sockaddr*)&server, sizeof server);
   if (bytes_sent != sizeof packet)
   {
      int err = WSAGetLastError();
      if (err != WSAEWOULDBLOCK)
         throw connection_error("Fehler %d bei sendto().\n", err);
   }
}
