// output.cpp: Gekapselte Ausgabefunktionen
// Matthias Fuchs

#include "output.h"

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include<string.h>
#if defined(WINDOWS) || defined(_WIN32)
#include <windows.h>
#endif

static int Frame=0;
#ifdef OUTPUT
static int LastFrame=0;
static int lineLength=0;
#endif
void OutputSetFrame(const int& frame){
  Frame=frame;
}
void OutputError    (const char* str)
{
#ifdef OUTPUT
   fprintf (stderr, "Error: %s", str);
#endif
}

void OutputError2   (const char* format, ...)
{
   char str[1024];

   va_list arglist;
   va_start(arglist, format);

   vsprintf(str, format, arglist);

   va_end(arglist);

   OutputError (str);
}

void OutputWarning  (const char* str)
{
#ifdef OUTPUT
   fprintf (stderr, "Warning: %s", str);
#endif
}

void OutputWarning2   (const char* format, ...)
{
   char str[1024];

   va_list arglist;
   va_start(arglist, format);

   vsprintf(str, format, arglist);

   va_end(arglist);

   OutputWarning (str);
}

void OutputInfo     (const char* str)
{
#ifdef OUTPUT
  if(strlen(str)>0){
    if(LastFrame<Frame){
      fprintf(stdout,"\n");
      fprintf (stdout, "%5d: %s",Frame, str);
      lineLength=strlen(str);
    }
    else{
      lineLength+=strlen(str);
      if(strchr(str,'\n')==NULL){
	if(lineLength+strlen(str)>184 ){
	  fprintf(stdout,"\n       ");
	  lineLength = strlen(str) + 7;
	} 
      }else {
	fprintf(stdout,"       ");
	lineLength = strlen(str) + 7;
      }
      fprintf (stdout, "%s",str);
    }
    
  LastFrame=Frame;
  }
#endif
}

void OutputInfo2    (const char* format, ...)
{
   char str[1024];

   va_list arglist;
   va_start(arglist, format);

   vsprintf(str, format, arglist);

   va_end(arglist);

   OutputInfo (str);
}

void OutputDebug    (const char* str)
{
#ifdef OUTPUT
#if defined(WINDOWS) || defined(_WIN32)
   OutputDebugString (str);
#else
   fprintf (stderr, "Debug: %s", str);
#endif
#endif
}

void OutputDebug2   (const char* format, ...)
{
   char str[1024];

   va_list arglist;
   va_start(arglist, format);

   vsprintf(str, format, arglist);

   va_end(arglist);

   OutputDebug (str);
}


