// -*- mode:C++; -*-
// Zoltan Zomotor
// asteroid.cpp: Beispielspieler fr Asteroids
// Matthias Fuchs
// Original: Harald Bgeholz / c't

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "output.h"
#include "connection.h"
#include "game.h"
#include "exampleplayer.h"


int main(int argc, const char* argv[])
{
#ifdef _DEBUG
   OutputDebug2
      ("LittleEndian: %s", Connection::IsLittleEndian() ? "Ja" : "Nein");
#endif

   bool killFlag=false;
   if (argc > 2)
   {
      fprintf(stderr, "Aufruf: asteroid <IP-Adresse>\n");
      return 1;
   }
       ExamplePlayer player;

   for(int tt=0;;tt++){
     try{
       //       OutputInfo2("Try %d\n",tt);
       
       Connection con(argc == 2 ? argv[1] : "127.0.0.1");
       Game game(con, player);
       game.Run();
     } catch (connection_error &ce){
       OutputError(ce.what());
       break;
     }catch(game_over go){
       killFlag=false;
#ifdef PROTOKOLL
       OutputInfo2("\n------------ Total Score: %d --------------\n\n",player.totscore);
       const char *file="newhighscore.txt";
       const char *mode="a";
       FILE *fid = fopen(file,mode);
       fprintf(fid,"asteroids-%s.gz: ",player.ct_time_string);
       fprintf(fid,"Score %6d, Points: %6d / Level %2d / Lost %d   Shots=(%4d,%4d) ,  Asts=%4d, UFO: big=%2d small=%2d, ttc=%3d, ttd=%3d, tOther=%d\n\n",   
	       player.totscore,
	       player.trackedPoints,
	       player.level,
	       player.lostShips,
	       player.nOwnShotsTotSoll,
	       player.nOwnShotsTotIst,
	       player.nTotTrackedAst,
	       player.nBigSaucers,
	       player.nSmallSaucers,
	       player.nTtcShot,
	       player.nTtdShot,
	       player.nOtherShot);
       fclose(fid);
#endif
       return 0;
       break;
     }catch(busy &b){
#ifdef PROTOKOLL
       if(!killFlag){
	 OutputError(b.what());
	 OutputInfo("kill ship\n");
	 killFlag=true;
       }
#endif
       char xmacro[256];
       int sec=random()%2;
       sprintf(xmacro,"echo -e KeyStr F3 Delay %d |xmacroplay :0 2>/dev/null 1>/dev/null",sec);
       system(xmacro);
       sleep(sec);
     } catch (...) {
       OutputError("Unerwarteter Fehler.");
     }
   }
   return 0;
}
