// -*- mode: C++; -*-
// Zoltan Zomotor
// exampleplayer.h: Beispielspieler fr Asteroids
// Matthias Fuchs
// Original: Harald Bgeholz / c't
#ifndef ExamplePlayerH
#define ExamplePlayerH

#include "interfaceplayer.h"

#include "game.h"
#include<math.h>

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#ifndef M_TWOPI
#define M_TWOPI (M_PI * 2.0)
#endif

#ifndef M_PI_2
#define M_PI_2 1.57079632679489661923
#endif

#ifndef MAXFLOAT
#define MAXFLOAT 1e+37
#endif

#ifndef MAXINT
#define MAXINT 0x7FFFFFFF
#endif

static const double DPH = M_PI/128.; //0.024543692606170; // 2 pi / 256
static const int FRAME_DELAY = 0;
static const int TTC_DANGER = 42; 
static const int MIN_DIST_DANGER = 300*300; // Px ist schon sehr nahe
static const int RBUFFER = 32;
static const int PERM_SIZE = 7;


//static const double LNLAM = log(1.-1./1024.);  // v_ship(t) = v_ship(0)*exp(t/T*LNLAM)), T=1*Frame, t=n*Frame




typedef struct {
unsigned int i:INDBITS;
} indT;

class Track;
class TrackedSaucer;
class TrackedAsteroid;
class TtcC;

class AimC{
 public:
  double idx;      // Abstand zum Schiff
  double idy;
  double dx;      // Abstand zum Schiff
  double dy;
  double d2;      // Abstand^2 
  double xobj;
  double yobj;
  double obj_xp;
  double obj_yp;
  double obj_v2;
  double kx;   // Zielvektor
  double ky;
  double kxd;   // Zielvektor
  double kyd;
  int    indphkd; // Winkel-Index
  int    indphs; // Schiffswinkel-Index
  int    nDPH;
  double ts;   // Schussdauer
  int    fd;   // Delay (Framedelay + Frames fr Drehung Raumschiff)
  int  ping;
  bool fire;   // Schieen!
  bool oofFire; // out of focus Schuss
  double  radius; // Zielradius
  int sls;
  double deltaX;
  double deltaY;
  bool AimF(void);
};

void indWrap(int &ind);
void angWrap(double &ang);
double octWrap(const double &_ang);
void indToPh(double &ph, int &ind);
double indToPh(int& ind);
int phToInd(const double &ph);
int kToInd(const double& kx, const double &ky);
void fraction(const int& ixy, const int ip[], int ipsum, const double& p, double &xy);
double precision(int ipsum);
double subRound(const double& z);
void bubble_sort(double a[], const int& size);
void bubble_sort(TtcC a[], const int& size);
bool inOct(const double& x, const double& y,const int& radius);
double calcTtc(const double& dx, const double& dy, const double& dxp, const double& dyp,const double& radius);
int calcMinDist(const Track& a, const Track &s, const int& radius2 );

class TrackedShip : public Ship{
 public:
  double xpp,ypp;
  int lx, ly;    // Koordinaten im letzten Frame
  double xd, yd; // Prdizierte Koordinaten
  int lixp, liyp;
  double lxp, lyp; // Geschwindigkeit im letzten Frame
  int ixp, iyp;  
  double xpd, ypd; // Prdizierte Geschwindigkeit zum Zeitpunkt ping+1
  int t;
  bool accelFrame;
  int naccel;
  AimC aim;
  bool tooLate;
  int ind[INDSIZE];   
  int turn[INDSIZE];
  bool thrust[INDSIZE];
  double xp[INDSIZE],yp[INDSIZE],v2[INDSIZE];  // Geschwindigkeit des Schiffs
  double x[INDSIZE],y[INDSIZE];
  int taggedId[INDSIZE];

  int indphkd[MAX_ASTEROIDS+1]; 
  int ts[MAX_ASTEROIDS+1];
  int fd[MAX_ASTEROIDS+1];
  bool fire[MAX_ASTEROIDS+1];
  bool oofFire[MAX_ASTEROIDS+1];
  int  nDPH[MAX_ASTEROIDS+1]; // 0 no turn, >0 left, <0 right
  double ttd[MAX_ASTEROIDS+1]; // Time to destruct, auer UFO!
  int sls[MAX_ASTEROIDS+1];
  double df[MAX_ASTEROIDS+1]; // Time to destruct, auer UFO!
  double dof[MAX_ASTEROIDS+1]; // Time to destruct, auer UFO!

  void Speed(const GameStatus& state, const bool& thrust);
  void Align(const GameStatus& state);
  void Turn(const unsigned char& keysPing);
  void TurnLeft(const unsigned char& keysPing);
  void TurnRight(const unsigned char& keysPing);
  void NoTurn(const unsigned char& keysPing);
  TrackedShip(void);
  TrackedShip& operator=(const TrackedShip& p);
  void set(const GameStatus& state);
  void Aim(const TrackedAsteroid& a,const int& i, const GameStatus& state);
  void Aim(const TrackedSaucer& a , const int& i, const GameStatus& state);
  void Aim(const int& i, const GameStatus& state);
  void predict(const GameStatus& state, const int& frames);
  bool shootThisFirst(int curr,int reqShots, int other);
  void nextShot(const int& iObj, int& lfd, int& lnDPH);
};

class TrackedSaucer : public Saucer{
 public:
  bool   lpresent;
  int    id;
  int    lx,ly;
  double xp,yp,v2;
  unsigned short iNextYP;
  int iNextSaucerID;
  int nTags;
  double ttc;
  int set(const GameStatus& state, unsigned int& nBigSaucers, unsigned int& nSmallSaucers);
  void Speed(void);
  double Ttc(void);
  TrackedSaucer(void);
};
class Track {
 public:
  int age;        // Lebensdauer
  double x, y;    // Getrackte Koordinaten
  double deltaX, deltaY; // Genauigkeit der Koordinaten +-delta
  int lx,ly;      // Gemessene Koordinaten im vorigen Frame
  int ixp[8], iyp[8]; // 8-Periodische Geschwindigkeit
  double xp,yp,v2; // Geschwindigkeit
  double xp0; // Angenommene Anfangs-Geschwindigkeit in Abschussrichtung
  double yp0; // Wird nach 8 Frames durch die gemessene ersetzt
  double ttc;     // time to collision mit Schiff     
  double dtc_x, dtc_y;  // Distance to collision
  double dtc;      // distance^2 to collision
  double dc;       // 
  bool matched;    // Asteroid konnte zugeordnet werden
  int dsigma_init;
  int dsigma;
  virtual void Ttc(const double& radius, const Ship& ship);
  //  virtual void newTtc(int dkorr, Ship ship);
  virtual bool Match(const int& ix, const int& iy, const int& xn, const int& yn, const int& latenz); // Passt aktueller asteroid zum Track?
  virtual void clear(int &x, int &y);

  void set(const int& ix, const int& iy, const int& latenz, double &x, double &y);
  //  void set(const int& ix, const int& iy);
};

class TrackedAsteroid : public Track, public Asteroid{
 private:
 public:
  void set(const Asteroid& asteroid, const GameStatus& state);
  int id;
  bool exploded;
  int requiredShots;
  int nTags;
  int ttd; // Time to destruction
  void init(const Asteroid& asteroid, const GameStatus& state,const int& _id);
  double Ttc(const TrackedShip& ship);
  bool Match(const Asteroid& asteroid, const GameStatus& state); // Passt aktueller asteroid zum Track?
  void clear();
  TrackedAsteroid& operator=(const TrackedAsteroid& p);
  inline TrackedAsteroid(void);
  void Dist(const Ship& ship);
  void AllowedShots(const GameStatus& state);
};

inline TrackedAsteroid::TrackedAsteroid(void)
  :id(MAXINT){}

class TrackedShot : public Track, public Shot{
 private:
  void set(const Shot& shot, const int& latenz);
 public:
  bool hit;  // Schuss geht ins Ziel
  int id;
  bool own_shot;
  double sdx, sdy, sd; //Abstand des Schusses zum UFO
  int shipind;
  int sls; // shotLifeSpan
  int taggedId;      // aktuell getaggedtes Objekt
  int taggedIdAimed; // Id des Objekts, auf das gezielt wurde
  double tta;  // Time to asteroid
  void init(const Shot& shot, const TrackedShip& ship, const TrackedSaucer& saucer,const GameStatus& state, const int& _id);
  void Ttc(const Ship& ship);
  double  Ttc(const TrackedAsteroid& ast); // return value: Neue Anzahl von nTags
  double Ttc(const TrackedSaucer& saucer);
  bool Match(const Shot& shot, const int& latenz);
  void clear();
  TrackedShot& operator=(const TrackedShot& p);
  void Dist(const Ship& ship);
  void Dist(const Saucer& saucer);
  inline TrackedShot(void);
 };
inline TrackedShot::TrackedShot(void)
  :hit(false),
   id(MAXINT),
   own_shot(false),
   sdx(MAXFLOAT),
   sdy(MAXFLOAT),
   sd(MAXFLOAT),
   shipind(MAXINT),
   taggedId(MAXINT),
   tta(MAXFLOAT){}
class Info{
 public:
  int hits;
  int saucerShot;
  int ttcShot;
  int tttShot;
  int ttdShot;
  int interShot;
  Info(void);
};

class TtcC {
 public:
  int    i;
  double t;
  int  ttd;
};

class ExamplePlayer : public InterfacePlayer
{
 private:
  int nTrackedShots;    // Anzahl der getrackten Asteroiden
  int nTrackedAst;    // Anzahl der getrackten Asteroiden
  bool slsSetFlag;
  bool slsGetFlag;
  int slsPraed[4];
  int slsShot;
  int shotAge;
  int nSlsOff;
public:
  int ShotHS;
  int sMinDistHS;
  int aMinDistHS;
  int TtcHS;
  int allHS;
  int nextShotID;
  int nextAstID;
  int lSaucerID;
  int isaucer;
  int births;
  int iSaucerExplosion;
  TrackedAsteroid asteroids[MAX_ASTEROIDS];
  TrackedShot shots[MAX_SHOTS];
  bool cflag[MAX_ASTEROIDS]; //continue-Flag: true, wenn kein weiterer Schuss auf Asteroid i abgegeben werden soll
  TtcC ttc[MAX_ASTEROIDS+1]; // Einschlielich UFO
  int ttcDanger;
  TrackedShip ship;
  TrackedSaucer saucer;
  double ttns[4]; // Time to next shot
  bool fire;     // jetzt schieen
  int iLshotId;    // voriger Schuss 
  int tLshot;    // Zeitpunkt des letzten Schusses
  bool loaded;   // Kanone geladen
  bool thrust;   // jetzt Schub
  unsigned int tlhyper; // Zeitpunkt letzter Hyperspace-Sprung
  int nownshots;
  int km1;       // vorheriger keysPing
  int km2;       // vorletzter keysPing
  virtual void MakeTurn(const GameStatus& gamestate, KeysPacket &turn);
  ExamplePlayer(void);
  void TrackShots(const GameStatus& gamestate);
  void TrackAsteroids(const GameStatus& gamestate);
  void incTrackedShots(void);
  void incTrackedAst(void);
  void subTrackedShots(const int& cleared);
  void subTrackedAst(const int& cleared);
  bool shootThisFirst(const int& curr, const int& nasteroids, int& iShootThis);
  void GetCflag(const int& i, const int& s, const GameStatus& state, const int& ts);   // Continue-Flag fr i-ten asteroiden


  void CalcDest(const unsigned char& ping, int &nDPH);
  void FlyToDest(const GameStatus& state, KeysPacket &keys);
  void FlyToDestNoTurn(const GameStatus& state, KeysPacket &keys);
  void TurnToNextBorders(const GameStatus& state, KeysPacket &keys);
};

static const double saucerYp[3]={-2,0,2};
static const double shotSpeed2[256]={
  62.015625,  // [0]     
  62.078125,  // [1]  	 
  62.156250,  // [2]  	 
  62.406250,  // [3]  	 
  62.578125,  // [4]  	 
  63.015625,  // [5]  	 
  63.578125,  // [6]  	 
  61.953125,  // [7]  	 
  62.703125,  // [8]  	 
  63.125000,  // [9]  	 
  62.140625,  // [10] 	 
  62.656250,  // [11] 	 
  63.781250,  // [12] 	 
  62.500000,  // [13] 	 
  63.812500,  // [14] 	 
  62.656250,  // [15] 	 
  62.328125,  // [16] 	 
  63.125000,  // [17] 	 
  62.156250,  // [18] 	 
  62.140625,  // [19] 	 
  63.062500,  // [20] 	 
  63.265625,  // [21] 	 
  62.578125,  // [22] 	 
  61.953125,  // [23] 	 
  64.140625,  // [24] 	 
  63.640625,  // [25] 	 
  63.203125,  // [26] 	 
  62.828125,  // [27] 	 
  63.781250,  // [28] 	 
  63.562500,  // [29] 	 
  63.406250,  // [30] 	 
  63.312500,  // [31] 	 
  63.281250,  // [32] 	 
  63.312500,  // [33] 	 
  62.078125,  // [34] 	 
  62.265625,  // [35] 	 
  62.515625,  // [36] 	 
  62.828125,  // [37] 	 
  63.203125,  // [38] 	 
  62.500000,  // [39] 	 
  63.031250,  // [40] 	 
  63.625000,  // [41] 	 
  63.265625,  // [42] 	 
  64.015625,  // [43] 	 
  63.062500,  // [44] 	 
  63.015625,  // [45] 	 
  63.953125,  // [46] 	 
  62.328125,  // [47] 	 
  63.390625,  // [48] 	 
  62.656250,  // [49] 	 
  63.140625,  // [50] 	 
  64.390625,  // [51] 	 
  63.203125,  // [52] 	 
  62.656250,  // [53] 	 
  63.578125,  // [54] 	 
  63.125000,  // [55] 	 
  64.265625,  // [56] 	 
  63.906250,  // [57] 	 
  63.281250,  // [58] 	 
  63.015625,  // [59] 	 
  62.578125,  // [60] 	 
  64.250000,  // [61] 	 
  64.140625,  // [62] 	 
  64.015625,  // [63] 	 
  64.000000,  // [64] 	 
  64.062500,  // [65] 	 
  64.140625,  // [66] 	 
  64.390625,  // [67] 	 
  62.578125,  // [68] 	 
  63.015625,  // [69] 	 
  63.578125,  // [70] 	 
  63.906250,  // [71] 	 
  64.656250,  // [72] 	 
  63.125000,  // [73] 	 
  64.062500,  // [74] 	 
  62.656250,  // [75] 	 
  63.781250,  // [76] 	 
  64.390625,  // [77] 	 
  63.812500,  // [78] 	 
  62.656250,  // [79] 	 
  64.156250,  // [80] 	 
  63.125000,  // [81] 	 
  63.953125,  // [82] 	 
  63.906250,  // [83] 	 
  63.062500,  // [84] 	 
  65.000000,  // [85] 	 
  64.281250,  // [86] 	 
  63.625000,  // [87] 	 
  64.140625,  // [88] 	 
  63.640625,  // [89] 	 
  63.203125,  // [90] 	 
  62.828125,  // [91] 	 
  63.781250,  // [92] 	 
  63.562500,  // [93] 	 
  63.406250,  // [94] 	 
  63.312500,  // [95] 	 
  63.281250,  // [96] 	 
  63.312500,  // [97] 	 
  63.406250,  // [98] 	 
  63.562500,  // [99] 	 
  63.781250,  // [100]	 
  62.828125,  // [101]	 
  63.203125,  // [102]	 
  63.640625,  // [103]	 
  64.140625,  // [104]	 
  63.625000,  // [105]	 
  64.281250,  // [106]	 
  65.000000,  // [107]	 
  63.062500,  // [108]	 
  63.906250,  // [109]	 
  63.953125,  // [110]	 
  63.125000,  // [111]	 
  64.156250,  // [112]	 
  62.656250,  // [113]	 
  63.812500,  // [114]	 
  64.390625,  // [115]	 
  63.781250,  // [116]	 
  62.656250,  // [117]	 
  64.062500,  // [118]	 
  63.125000,  // [119]	 
  64.656250,  // [120]	 
  63.906250,  // [121]	 
  63.578125,  // [122]	 
  63.015625,  // [123]	 
  62.578125,  // [124]	 
  64.390625,  // [125]	 
  64.140625,  // [126]	 
  64.062500,  // [127]	 
  64.000000,  // [128]	 
  64.015625,  // [129]	 
  64.140625,  // [130]	 
  64.250000,  // [131]	 
  62.578125,  // [132]	 
  63.015625,  // [133]	 
  63.281250,  // [134]	 
  63.906250,  // [135]	 
  64.265625,  // [136]	 
  63.125000,  // [137]	 
  63.578125,  // [138]	 
  62.656250,  // [139]	 
  63.203125,  // [140]	 
  64.390625,  // [141]	 
  63.140625,  // [142]	 
  62.656250,  // [143]	 
  63.390625,  // [144]	 
  62.328125,  // [145]	 
  63.953125,  // [146]	 
  63.015625,  // [147]	 
  63.062500,  // [148]	 
  64.015625,  // [149]	 
  63.265625,  // [150]	 
  63.625000,  // [151]	 
  63.031250,  // [152]	 
  62.500000,  // [153]	 
  63.203125,  // [154]	 
  62.828125,  // [155]	 
  62.515625,  // [156]	 
  62.265625,  // [157]	 
  62.078125,  // [158]	 
  63.312500,  // [159]	 
  63.281250,  // [160]	 
  63.312500,  // [161]	 
  63.406250,  // [162]	 
  63.562500,  // [163]	 
  63.781250,  // [164]	 
  62.828125,  // [165]	 
  63.203125,  // [166]	 
  63.640625,  // [167]	 
  64.140625,  // [168]	 
  61.953125,  // [169]	 
  62.578125,  // [170]	 
  63.265625,  // [171]	 
  63.062500,  // [172]	 
  62.140625,  // [173]	 
  62.156250,  // [174]	 
  63.125000,  // [175]	 
  62.328125,  // [176]	 
  62.656250,  // [177]	 
  63.812500,  // [178]	 
  62.500000,  // [179]	 
  63.781250,  // [180]	 
  62.656250,  // [181]	 
  62.140625,  // [182]	 
  63.125000,  // [183]	 
  62.703125,  // [184]	 
  61.953125,  // [185]	 
  63.578125,  // [186]	 
  63.015625,  // [187]	 
  62.578125,  // [188]	 
  62.406250,  // [189]	 
  62.156250,  // [190]	 
  62.078125,  // [191]	 
  62.015625,  // [192]	 
  62.031250,  // [193]	 
  62.156250,  // [194]	 
  62.265625,  // [195]	 
  62.578125,  // [196]	 
  63.015625,  // [197]	 
  63.281250,  // [198]	 
  61.953125,  // [199]	 
  62.312500,  // [200]	 
  63.125000,  // [201]	 
  61.656250,  // [202]	 
  62.656250,  // [203]	 
  63.203125,  // [204]	 
  62.500000,  // [205]	 
  63.140625,  // [206]	 
  62.656250,  // [207]	 
  61.562500,  // [208]	 
  62.328125,  // [209]	 
  62.156250,  // [210]	 
  61.250000,  // [211]	 
  63.062500,  // [212]	 
  62.281250,  // [213]	 
  61.562500,  // [214]	 
  61.953125,  // [215]	 
  63.031250,  // [216]	 
  62.500000,  // [217]	 
  63.203125,  // [218]	 
  62.828125,  // [219]	 
  62.515625,  // [220]	 
  62.265625,  // [221]	 
  62.078125,  // [222]	 
  63.312500,  // [223]	 
  63.281250,  // [224]	 
  63.312500,  // [225]	 
  62.078125,  // [226]	 
  62.265625,  // [227]	 
  62.515625,  // [228]	 
  62.828125,  // [229]	 
  63.203125,  // [230]	 
  62.500000,  // [231]	 
  63.031250,  // [232]	 
  61.953125,  // [233]	 
  61.562500,  // [234]	 
  62.281250,  // [235]	 
  63.062500,  // [236]	 
  61.250000,  // [237]	 
  62.156250,  // [238]	 
  62.328125,  // [239]	 
  61.562500,  // [240]	 
  62.656250,  // [241]	 
  63.140625,  // [242]	 
  62.500000,  // [243]	 
  63.203125,  // [244]	 
  62.656250,  // [245]	 
  61.656250,  // [246]	 
  63.125000,  // [247]	 
  62.312500,  // [248]	 
  61.953125,  // [249]	 
  63.281250,  // [250]	 
  63.015625,  // [251]	 
  62.578125,  // [252]	 
  62.265625,  // [253]	 
  62.156250,  // [254]	 
  62.031250   // [255]	 
};

static const double shotSpeed[256]={
  sqrt(shotSpeed2[0  ]),
  sqrt(shotSpeed2[1  ]),
  sqrt(shotSpeed2[2  ]),
  sqrt(shotSpeed2[3  ]),
  sqrt(shotSpeed2[4  ]),
  sqrt(shotSpeed2[5  ]),
  sqrt(shotSpeed2[6  ]),
  sqrt(shotSpeed2[7  ]),
  sqrt(shotSpeed2[8  ]),
  sqrt(shotSpeed2[9  ]),
  sqrt(shotSpeed2[10 ]),
  sqrt(shotSpeed2[11 ]),
  sqrt(shotSpeed2[12 ]),
  sqrt(shotSpeed2[13 ]),
  sqrt(shotSpeed2[14 ]),
  sqrt(shotSpeed2[15 ]),
  sqrt(shotSpeed2[16 ]),
  sqrt(shotSpeed2[17 ]),
  sqrt(shotSpeed2[18 ]),
  sqrt(shotSpeed2[19 ]),
  sqrt(shotSpeed2[20 ]),
  sqrt(shotSpeed2[21 ]),
  sqrt(shotSpeed2[22 ]),
  sqrt(shotSpeed2[23 ]),
  sqrt(shotSpeed2[24 ]),
  sqrt(shotSpeed2[25 ]),
  sqrt(shotSpeed2[26 ]),
  sqrt(shotSpeed2[27 ]),
  sqrt(shotSpeed2[28 ]),
  sqrt(shotSpeed2[29 ]),
  sqrt(shotSpeed2[30 ]),
  sqrt(shotSpeed2[31 ]),
  sqrt(shotSpeed2[32 ]),
  sqrt(shotSpeed2[33 ]),
  sqrt(shotSpeed2[34 ]),
  sqrt(shotSpeed2[35 ]),
  sqrt(shotSpeed2[36 ]),
  sqrt(shotSpeed2[37 ]),
  sqrt(shotSpeed2[38 ]),
  sqrt(shotSpeed2[39 ]),
  sqrt(shotSpeed2[40 ]),
  sqrt(shotSpeed2[41 ]),
  sqrt(shotSpeed2[42 ]),
  sqrt(shotSpeed2[43 ]),
  sqrt(shotSpeed2[44 ]),
  sqrt(shotSpeed2[45 ]),
  sqrt(shotSpeed2[46 ]),
  sqrt(shotSpeed2[47 ]),
  sqrt(shotSpeed2[48 ]),
  sqrt(shotSpeed2[49 ]),
  sqrt(shotSpeed2[50 ]),
  sqrt(shotSpeed2[51 ]),
  sqrt(shotSpeed2[52 ]),
  sqrt(shotSpeed2[53 ]),
  sqrt(shotSpeed2[54 ]),
  sqrt(shotSpeed2[55 ]),
  sqrt(shotSpeed2[56 ]),
  sqrt(shotSpeed2[57 ]),
  sqrt(shotSpeed2[58 ]),
  sqrt(shotSpeed2[59 ]),
  sqrt(shotSpeed2[60 ]),
  sqrt(shotSpeed2[61 ]),
  sqrt(shotSpeed2[62 ]),
  sqrt(shotSpeed2[63 ]),
  sqrt(shotSpeed2[64 ]),
  sqrt(shotSpeed2[65 ]),
  sqrt(shotSpeed2[66 ]),
  sqrt(shotSpeed2[67 ]),
  sqrt(shotSpeed2[68 ]),
  sqrt(shotSpeed2[69 ]),
  sqrt(shotSpeed2[70 ]),
  sqrt(shotSpeed2[71 ]),
  sqrt(shotSpeed2[72 ]),
  sqrt(shotSpeed2[73 ]),
  sqrt(shotSpeed2[74 ]),
  sqrt(shotSpeed2[75 ]),
  sqrt(shotSpeed2[76 ]),
  sqrt(shotSpeed2[77 ]),
  sqrt(shotSpeed2[78 ]),
  sqrt(shotSpeed2[79 ]),
  sqrt(shotSpeed2[80 ]),
  sqrt(shotSpeed2[81 ]),
  sqrt(shotSpeed2[82 ]),
  sqrt(shotSpeed2[83 ]),
  sqrt(shotSpeed2[84 ]),
  sqrt(shotSpeed2[85 ]),
  sqrt(shotSpeed2[86 ]),
  sqrt(shotSpeed2[87 ]),
  sqrt(shotSpeed2[88 ]),
  sqrt(shotSpeed2[89 ]),
  sqrt(shotSpeed2[90 ]),
  sqrt(shotSpeed2[91 ]),
  sqrt(shotSpeed2[92 ]),
  sqrt(shotSpeed2[93 ]),
  sqrt(shotSpeed2[94 ]),
  sqrt(shotSpeed2[95 ]),
  sqrt(shotSpeed2[96 ]),
  sqrt(shotSpeed2[97 ]),
  sqrt(shotSpeed2[98 ]),
  sqrt(shotSpeed2[99 ]),
  sqrt(shotSpeed2[100]),
  sqrt(shotSpeed2[101]),
  sqrt(shotSpeed2[102]),
  sqrt(shotSpeed2[103]),
  sqrt(shotSpeed2[104]),
  sqrt(shotSpeed2[105]),
  sqrt(shotSpeed2[106]),
  sqrt(shotSpeed2[107]),
  sqrt(shotSpeed2[108]),
  sqrt(shotSpeed2[109]),
  sqrt(shotSpeed2[110]),
  sqrt(shotSpeed2[111]),
  sqrt(shotSpeed2[112]),
  sqrt(shotSpeed2[113]),
  sqrt(shotSpeed2[114]),
  sqrt(shotSpeed2[115]),
  sqrt(shotSpeed2[116]),
  sqrt(shotSpeed2[117]),
  sqrt(shotSpeed2[118]),
  sqrt(shotSpeed2[119]),
  sqrt(shotSpeed2[120]),
  sqrt(shotSpeed2[121]),
  sqrt(shotSpeed2[122]),
  sqrt(shotSpeed2[123]),
  sqrt(shotSpeed2[124]),
  sqrt(shotSpeed2[125]),
  sqrt(shotSpeed2[126]),
  sqrt(shotSpeed2[127]),
  sqrt(shotSpeed2[128]),
  sqrt(shotSpeed2[129]),
  sqrt(shotSpeed2[130]),
  sqrt(shotSpeed2[131]),
  sqrt(shotSpeed2[132]),
  sqrt(shotSpeed2[133]),
  sqrt(shotSpeed2[134]),
  sqrt(shotSpeed2[135]),
  sqrt(shotSpeed2[136]),
  sqrt(shotSpeed2[137]),
  sqrt(shotSpeed2[138]),
  sqrt(shotSpeed2[139]),
  sqrt(shotSpeed2[140]),
  sqrt(shotSpeed2[141]),
  sqrt(shotSpeed2[142]),
  sqrt(shotSpeed2[143]),
  sqrt(shotSpeed2[144]),
  sqrt(shotSpeed2[145]),
  sqrt(shotSpeed2[146]),
  sqrt(shotSpeed2[147]),
  sqrt(shotSpeed2[148]),
  sqrt(shotSpeed2[149]),
  sqrt(shotSpeed2[150]),
  sqrt(shotSpeed2[151]),
  sqrt(shotSpeed2[152]),
  sqrt(shotSpeed2[153]),
  sqrt(shotSpeed2[154]),
  sqrt(shotSpeed2[155]),
  sqrt(shotSpeed2[156]),
  sqrt(shotSpeed2[157]),
  sqrt(shotSpeed2[158]),
  sqrt(shotSpeed2[159]),
  sqrt(shotSpeed2[160]),
  sqrt(shotSpeed2[161]),
  sqrt(shotSpeed2[162]),
  sqrt(shotSpeed2[163]),
  sqrt(shotSpeed2[164]),
  sqrt(shotSpeed2[165]),
  sqrt(shotSpeed2[166]),
  sqrt(shotSpeed2[167]),
  sqrt(shotSpeed2[168]),
  sqrt(shotSpeed2[169]),
  sqrt(shotSpeed2[170]),
  sqrt(shotSpeed2[171]),
  sqrt(shotSpeed2[172]),
  sqrt(shotSpeed2[173]),
  sqrt(shotSpeed2[174]),
  sqrt(shotSpeed2[175]),
  sqrt(shotSpeed2[176]),
  sqrt(shotSpeed2[177]),
  sqrt(shotSpeed2[178]),
  sqrt(shotSpeed2[179]),
  sqrt(shotSpeed2[180]),
  sqrt(shotSpeed2[181]),
  sqrt(shotSpeed2[182]),
  sqrt(shotSpeed2[183]),
  sqrt(shotSpeed2[184]),
  sqrt(shotSpeed2[185]),
  sqrt(shotSpeed2[186]),
  sqrt(shotSpeed2[187]),
  sqrt(shotSpeed2[188]),
  sqrt(shotSpeed2[189]),
  sqrt(shotSpeed2[190]),
  sqrt(shotSpeed2[191]),
  sqrt(shotSpeed2[192]),
  sqrt(shotSpeed2[193]),
  sqrt(shotSpeed2[194]),
  sqrt(shotSpeed2[195]),
  sqrt(shotSpeed2[196]),
  sqrt(shotSpeed2[197]),
  sqrt(shotSpeed2[198]),
  sqrt(shotSpeed2[199]),
  sqrt(shotSpeed2[200]),
  sqrt(shotSpeed2[201]),
  sqrt(shotSpeed2[202]),
  sqrt(shotSpeed2[203]),
  sqrt(shotSpeed2[204]),
  sqrt(shotSpeed2[205]),
  sqrt(shotSpeed2[206]),
  sqrt(shotSpeed2[207]),
  sqrt(shotSpeed2[208]),
  sqrt(shotSpeed2[209]),
  sqrt(shotSpeed2[210]),
  sqrt(shotSpeed2[211]),
  sqrt(shotSpeed2[212]),
  sqrt(shotSpeed2[213]),
  sqrt(shotSpeed2[214]),
  sqrt(shotSpeed2[215]),
  sqrt(shotSpeed2[216]),
  sqrt(shotSpeed2[217]),
  sqrt(shotSpeed2[218]),
  sqrt(shotSpeed2[219]),
  sqrt(shotSpeed2[220]),
  sqrt(shotSpeed2[221]),
  sqrt(shotSpeed2[222]),
  sqrt(shotSpeed2[223]),
  sqrt(shotSpeed2[224]),
  sqrt(shotSpeed2[225]),
  sqrt(shotSpeed2[226]),
  sqrt(shotSpeed2[227]),
  sqrt(shotSpeed2[228]),
  sqrt(shotSpeed2[229]),
  sqrt(shotSpeed2[230]),
  sqrt(shotSpeed2[231]),
  sqrt(shotSpeed2[232]),
  sqrt(shotSpeed2[233]),
  sqrt(shotSpeed2[234]),
  sqrt(shotSpeed2[235]),
  sqrt(shotSpeed2[236]),
  sqrt(shotSpeed2[237]),
  sqrt(shotSpeed2[238]),
  sqrt(shotSpeed2[239]),
  sqrt(shotSpeed2[240]),
  sqrt(shotSpeed2[241]),
  sqrt(shotSpeed2[242]),
  sqrt(shotSpeed2[243]),
  sqrt(shotSpeed2[244]),
  sqrt(shotSpeed2[245]),
  sqrt(shotSpeed2[246]),
  sqrt(shotSpeed2[247]),
  sqrt(shotSpeed2[248]),
  sqrt(shotSpeed2[249]),
  sqrt(shotSpeed2[250]),
  sqrt(shotSpeed2[251]),
  sqrt(shotSpeed2[252]),
  sqrt(shotSpeed2[253]),
  sqrt(shotSpeed2[254]),
  sqrt(shotSpeed2[255])
};
static const double shotdxp[256]={
    0.000,  // [0]     
   -0.250,  // [1]  	 
   -0.375,  // [2]  	 
   -0.625,  // [3]  	 
   -0.750,  // [4]  	 
   -1.000,  // [5]  	 
   -1.250,  // [6]  	 
   -1.375,  // [7]  	 
   -1.625,  // [8]  	 
   -1.750,  // [9]  	 
   -2.000,  // [10] 	 
   -2.125,  // [11] 	 
   -2.375,  // [12] 	 
   -2.500,  // [13] 	 
   -2.750,  // [14] 	 
   -2.875,  // [15] 	 
   -3.125,  // [16] 	 
   -3.250,  // [17] 	 
   -3.375,  // [18] 	 
   -3.625,  // [19] 	 
   -3.750,  // [20] 	 
   -4.000,  // [21] 	 
   -4.125,  // [22] 	 
   -4.250,  // [23] 	 
   -4.500,  // [24] 	 
   -4.625,  // [25] 	 
   -4.750,  // [26] 	 
   -4.875,  // [27] 	 
   -5.125,  // [28] 	 
   -5.250,  // [29] 	 
   -5.375,  // [30] 	 
   -5.500,  // [31] 	 
   -5.625,  // [32] 	 
   -5.750,  // [33] 	 
   -5.875,  // [34] 	 
   -6.000,  // [35] 	 
   -6.125,  // [36] 	 
   -6.250,  // [37] 	 
   -6.375,  // [38] 	 
   -6.500,  // [39] 	 
   -6.625,  // [40] 	 
   -6.750,  // [41] 	 
   -6.875,  // [42] 	 
   -7.000,  // [43] 	 
   -7.000,  // [44] 	 
   -7.125,  // [45] 	 
   -7.250,  // [46] 	 
   -7.250,  // [47] 	 
   -7.375,  // [48] 	 
   -7.375,  // [49] 	 
   -7.500,  // [50] 	 
   -7.625,  // [51] 	 
   -7.625,  // [52] 	 
   -7.625,  // [53] 	 
   -7.750,  // [54] 	 
   -7.750,  // [55] 	 
   -7.875,  // [56] 	 
   -7.875,  // [57] 	 
   -7.875,  // [58] 	 
   -7.875,  // [59] 	 
   -7.875,  // [60] 	 
   -8.000,  // [61] 	 
   -8.000,  // [62] 	 
   -8.000,  // [63] 	 
   -8.000,  // [64] 	 
   -8.000,  // [65] 	 
   -8.000,  // [66] 	 
   -8.000,  // [67] 	 
   -7.875,  // [68] 	 
   -7.875,  // [69] 	 
   -7.875,  // [70] 	 
   -7.875,  // [71] 	 
   -7.875,  // [72] 	 
   -7.750,  // [73] 	 
   -7.750,  // [74] 	 
   -7.625,  // [75] 	 
   -7.625,  // [76] 	 
   -7.625,  // [77] 	 
   -7.500,  // [78] 	 
   -7.375,  // [79] 	 
   -7.375,  // [80] 	 
   -7.250,  // [81] 	 
   -7.250,  // [82] 	 
   -7.125,  // [83] 	 
   -7.000,  // [84] 	 
   -7.000,  // [85] 	 
   -6.875,  // [86] 	 
   -6.750,  // [87] 	 
   -6.625,  // [88] 	 
   -6.500,  // [89] 	 
   -6.375,  // [90] 	 
   -6.250,  // [91] 	 
   -6.125,  // [92] 	 
   -6.000,  // [93] 	 
   -5.875,  // [94] 	 
   -5.750,  // [95] 	 
   -5.625,  // [96] 	 
   -5.500,  // [97] 	 
   -5.375,  // [98] 	 
   -5.250,  // [99] 	 
   -5.125,  // [100]	 
   -4.875,  // [101]	 
   -4.750,  // [102]	 
   -4.625,  // [103]	 
   -4.500,  // [104]	 
   -4.250,  // [105]	 
   -4.125,  // [106]	 
   -4.000,  // [107]	 
   -3.750,  // [108]	 
   -3.625,  // [109]	 
   -3.375,  // [110]	 
   -3.250,  // [111]	 
   -3.125,  // [112]	 
   -2.875,  // [113]	 
   -2.750,  // [114]	 
   -2.500,  // [115]	 
   -2.375,  // [116]	 
   -2.125,  // [117]	 
   -2.000,  // [118]	 
   -1.750,  // [119]	 
   -1.625,  // [120]	 
   -1.375,  // [121]	 
   -1.250,  // [122]	 
   -1.000,  // [123]	 
   -0.750,  // [124]	 
   -0.625,  // [125]	 
   -0.375,  // [126]	 
   -0.250,  // [127]	 
    0.000,  // [128]	 
    0.125,  // [129]	 
    0.375,  // [130]	 
    0.500,  // [131]	 
    0.750,  // [132]	 
    1.000,  // [133]	 
    1.125,  // [134]	 
    1.375,  // [135]	 
    1.500,  // [136]	 
    1.750,  // [137]	 
    1.875,  // [138]	 
    2.125,  // [139]	 
    2.250,  // [140]	 
    2.500,  // [141]	 
    2.625,  // [142]	 
    2.875,  // [143]	 
    3.000,  // [144]	 
    3.125,  // [145]	 
    3.375,  // [146]	 
    3.500,  // [147]	 
    3.750,  // [148]	 
    3.875,  // [149]	 
    4.000,  // [150]	 
    4.250,  // [151]	 
    4.375,  // [152]	 
    4.500,  // [153]	 
    4.750,  // [154]	 
    4.875,  // [155]	 
    5.000,  // [156]	 
    5.125,  // [157]	 
    5.250,  // [158]	 
    5.500,  // [159]	 
    5.625,  // [160]	 
    5.750,  // [161]	 
    5.875,  // [162]	 
    6.000,  // [163]	 
    6.125,  // [164]	 
    6.250,  // [165]	 
    6.375,  // [166]	 
    6.500,  // [167]	 
    6.625,  // [168]	 
    6.625,  // [169]	 
    6.750,  // [170]	 
    6.875,  // [171]	 
    7.000,  // [172]	 
    7.000,  // [173]	 
    7.125,  // [174]	 
    7.250,  // [175]	 
    7.250,  // [176]	 
    7.375,  // [177]	 
    7.500,  // [178]	 
    7.500,  // [179]	 
    7.625,  // [180]	 
    7.625,  // [181]	 
    7.625,  // [182]	 
    7.750,  // [183]	 
    7.750,  // [184]	 
    7.750,  // [185]	 
    7.875,  // [186]	 
    7.875,  // [187]	 
    7.875,  // [188]	 
    7.875,  // [189]	 
    7.875,  // [190]	 
    7.875,  // [191]	 
    7.875,  // [192]	 
    7.875,  // [193]	 
    7.875,  // [194]	 
    7.875,  // [195]	 
    7.875,  // [196]	 
    7.875,  // [197]	 
    7.875,  // [198]	 
    7.750,  // [199]	 
    7.750,  // [200]	 
    7.750,  // [201]	 
    7.625,  // [202]	 
    7.625,  // [203]	 
    7.625,  // [204]	 
    7.500,  // [205]	 
    7.500,  // [206]	 
    7.375,  // [207]	 
    7.250,  // [208]	 
    7.250,  // [209]	 
    7.125,  // [210]	 
    7.000,  // [211]	 
    7.000,  // [212]	 
    6.875,  // [213]	 
    6.750,  // [214]	 
    6.625,  // [215]	 
    6.625,  // [216]	 
    6.500,  // [217]	 
    6.375,  // [218]	 
    6.250,  // [219]	 
    6.125,  // [220]	 
    6.000,  // [221]	 
    5.875,  // [222]	 
    5.750,  // [223]	 
    5.625,  // [224]	 
    5.500,  // [225]	 
    5.250,  // [226]	 
    5.125,  // [227]	 
    5.000,  // [228]	 
    4.875,  // [229]	 
    4.750,  // [230]	 
    4.500,  // [231]	 
    4.375,  // [232]	 
    4.250,  // [233]	 
    4.000,  // [234]	 
    3.875,  // [235]	 
    3.750,  // [236]	 
    3.500,  // [237]	 
    3.375,  // [238]	 
    3.125,  // [239]	 
    3.000,  // [240]	 
    2.875,  // [241]	 
    2.625,  // [242]	 
    2.500,  // [243]	 
    2.250,  // [244]	 
    2.125,  // [245]	 
    1.875,  // [246]	 
    1.750,  // [247]	 
    1.500,  // [248]	 
    1.375,  // [249]	 
    1.125,  // [250]	 
    1.000,  // [251]	 
    0.750,  // [252]	 
    0.500,  // [253]	 
    0.375,  // [254]	 
    0.125   // [255]	 
};
static const double shotdyp[256]={
    7.875,  // [0]     
    7.875,  // [1]  	 
    7.875,  // [2]  	 
    7.875,  // [3]  	 
    7.875,  // [4]  	 
    7.875,  // [5]  	 
    7.875,  // [6]  	 
    7.750,  // [7]  	 
    7.750,  // [8]  	 
    7.750,  // [9]  	 
    7.625,  // [10] 	 
    7.625,  // [11] 	 
    7.625,  // [12] 	 
    7.500,  // [13] 	 
    7.500,  // [14] 	 
    7.375,  // [15] 	 
    7.250,  // [16] 	 
    7.250,  // [17] 	 
    7.125,  // [18] 	 
    7.000,  // [19] 	 
    7.000,  // [20] 	 
    6.875,  // [21] 	 
    6.750,  // [22] 	 
    6.625,  // [23] 	 
    6.625,  // [24] 	 
    6.500,  // [25] 	 
    6.375,  // [26] 	 
    6.250,  // [27] 	 
    6.125,  // [28] 	 
    6.000,  // [29] 	 
    5.875,  // [30] 	 
    5.750,  // [31] 	 
    5.625,  // [32] 	 
    5.500,  // [33] 	 
    5.250,  // [34] 	 
    5.125,  // [35] 	 
    5.000,  // [36] 	 
    4.875,  // [37] 	 
    4.750,  // [38] 	 
    4.500,  // [39] 	 
    4.375,  // [40] 	 
    4.250,  // [41] 	 
    4.000,  // [42] 	 
    3.875,  // [43] 	 
    3.750,  // [44] 	 
    3.500,  // [45] 	 
    3.375,  // [46] 	 
    3.125,  // [47] 	 
    3.000,  // [48] 	 
    2.875,  // [49] 	 
    2.625,  // [50] 	 
    2.500,  // [51] 	 
    2.250,  // [52] 	 
    2.125,  // [53] 	 
    1.875,  // [54] 	 
    1.750,  // [55] 	 
    1.500,  // [56] 	 
    1.375,  // [57] 	 
    1.125,  // [58] 	 
    1.000,  // [59] 	 
    0.750,  // [60] 	 
    0.500,  // [61] 	 
    0.375,  // [62] 	 
    0.125,  // [63] 	 
    0.000,  // [64] 	 
   -0.250,  // [65] 	 
   -0.375,  // [66] 	 
   -0.625,  // [67] 	 
   -0.750,  // [68] 	 
   -1.000,  // [69] 	 
   -1.250,  // [70] 	 
   -1.375,  // [71] 	 
   -1.625,  // [72] 	 
   -1.750,  // [73] 	 
   -2.000,  // [74] 	 
   -2.125,  // [75] 	 
   -2.375,  // [76] 	 
   -2.500,  // [77] 	 
   -2.750,  // [78] 	 
   -2.875,  // [79] 	 
   -3.125,  // [80] 	 
   -3.250,  // [81] 	 
   -3.375,  // [82] 	 
   -3.625,  // [83] 	 
   -3.750,  // [84] 	 
   -4.000,  // [85] 	 
   -4.125,  // [86] 	 
   -4.250,  // [87] 	 
   -4.500,  // [88] 	 
   -4.625,  // [89] 	 
   -4.750,  // [90] 	 
   -4.875,  // [91] 	 
   -5.125,  // [92] 	 
   -5.250,  // [93] 	 
   -5.375,  // [94] 	 
   -5.500,  // [95] 	 
   -5.625,  // [96] 	 
   -5.750,  // [97] 	 
   -5.875,  // [98] 	 
   -6.000,  // [99] 	 
   -6.125,  // [100]	 
   -6.250,  // [101]	 
   -6.375,  // [102]	 
   -6.500,  // [103]	 
   -6.625,  // [104]	 
   -6.750,  // [105]	 
   -6.875,  // [106]	 
   -7.000,  // [107]	 
   -7.000,  // [108]	 
   -7.125,  // [109]	 
   -7.250,  // [110]	 
   -7.250,  // [111]	 
   -7.375,  // [112]	 
   -7.375,  // [113]	 
   -7.500,  // [114]	 
   -7.625,  // [115]	 
   -7.625,  // [116]	 
   -7.625,  // [117]	 
   -7.750,  // [118]	 
   -7.750,  // [119]	 
   -7.875,  // [120]	 
   -7.875,  // [121]	 
   -7.875,  // [122]	 
   -7.875,  // [123]	 
   -7.875,  // [124]	 
   -8.000,  // [125]	 
   -8.000,  // [126]	 
   -8.000,  // [127]	 
   -8.000,  // [128]	 
   -8.000,  // [129]	 
   -8.000,  // [130]	 
   -8.000,  // [131]	 
   -7.875,  // [132]	 
   -7.875,  // [133]	 
   -7.875,  // [134]	 
   -7.875,  // [135]	 
   -7.875,  // [136]	 
   -7.750,  // [137]	 
   -7.750,  // [138]	 
   -7.625,  // [139]	 
   -7.625,  // [140]	 
   -7.625,  // [141]	 
   -7.500,  // [142]	 
   -7.375,  // [143]	 
   -7.375,  // [144]	 
   -7.250,  // [145]	 
   -7.250,  // [146]	 
   -7.125,  // [147]	 
   -7.000,  // [148]	 
   -7.000,  // [149]	 
   -6.875,  // [150]	 
   -6.750,  // [151]	 
   -6.625,  // [152]	 
   -6.500,  // [153]	 
   -6.375,  // [154]	 
   -6.250,  // [155]	 
   -6.125,  // [156]	 
   -6.000,  // [157]	 
   -5.875,  // [158]	 
   -5.750,  // [159]	 
   -5.625,  // [160]	 
   -5.500,  // [161]	 
   -5.375,  // [162]	 
   -5.250,  // [163]	 
   -5.125,  // [164]	 
   -4.875,  // [165]	 
   -4.750,  // [166]	 
   -4.625,  // [167]	 
   -4.500,  // [168]	 
   -4.250,  // [169]	 
   -4.125,  // [170]	 
   -4.000,  // [171]	 
   -3.750,  // [172]	 
   -3.625,  // [173]	 
   -3.375,  // [174]	 
   -3.250,  // [175]	 
   -3.125,  // [176]	 
   -2.875,  // [177]	 
   -2.750,  // [178]	 
   -2.500,  // [179]	 
   -2.375,  // [180]	 
   -2.125,  // [181]	 
   -2.000,  // [182]	 
   -1.750,  // [183]	 
   -1.625,  // [184]	 
   -1.375,  // [185]	 
   -1.250,  // [186]	 
   -1.000,  // [187]	 
   -0.750,  // [188]	 
   -0.625,  // [189]	 
   -0.375,  // [190]	 
   -0.250,  // [191]	 
    0.000,  // [192]	 
    0.125,  // [193]	 
    0.375,  // [194]	 
    0.500,  // [195]	 
    0.750,  // [196]	 
    1.000,  // [197]	 
    1.125,  // [198]	 
    1.375,  // [199]	 
    1.500,  // [200]	 
    1.750,  // [201]	 
    1.875,  // [202]	 
    2.125,  // [203]	 
    2.250,  // [204]	 
    2.500,  // [205]	 
    2.625,  // [206]	 
    2.875,  // [207]	 
    3.000,  // [208]	 
    3.125,  // [209]	 
    3.375,  // [210]	 
    3.500,  // [211]	 
    3.750,  // [212]	 
    3.875,  // [213]	 
    4.000,  // [214]	 
    4.250,  // [215]	 
    4.375,  // [216]	 
    4.500,  // [217]	 
    4.750,  // [218]	 
    4.875,  // [219]	 
    5.000,  // [220]	 
    5.125,  // [221]	 
    5.250,  // [222]	 
    5.500,  // [223]	 
    5.625,  // [224]	 
    5.750,  // [225]	 
    5.875,  // [226]	 
    6.000,  // [227]	 
    6.125,  // [228]	 
    6.250,  // [229]	 
    6.375,  // [230]	 
    6.500,  // [231]	 
    6.625,  // [232]	 
    6.625,  // [233]	 
    6.750,  // [234]	 
    6.875,  // [235]	 
    7.000,  // [236]	 
    7.000,  // [237]	 
    7.125,  // [238]	 
    7.250,  // [239]	 
    7.250,  // [240]	 
    7.375,  // [241]	 
    7.500,  // [242]	 
    7.500,  // [243]	 
    7.625,  // [244]	 
    7.625,  // [245]	 
    7.625,  // [246]	 
    7.750,  // [247]	 
    7.750,  // [248]	 
    7.750,  // [249]	 
    7.875,  // [250]	 
    7.875,  // [251]	 
    7.875,  // [252]	 
    7.875,  // [253]	 
    7.875,  // [254]	 
    7.875   // [255]	 
};
static const double shotph[256]={ // Winkel in radiant, Index 0 = pi
    M_PI_2    ,  //1.570796  ,  // [0]   pi/2  
    1.602532  ,  // [1]  	 
    1.618379  ,  // [2]  	 
    1.649995  ,  // [3]  	 
    1.665748  ,  // [4]  	 
    1.697104  ,  // [5]  	 
    1.728213  ,  // [6]  	 
    1.746388  ,  // [7]  	 
    1.777480  ,  // [8]  	 
    1.792878  ,  // [9]  	 
    1.827313  ,  // [10] 	 
    1.842588  ,  // [11] 	 
    1.872747  ,  // [12] 	 
    1.892547  ,  // [13] 	 
    1.922241  ,  // [14] 	 
    1.942505  ,  // [15] 	 
    1.977767  ,  // [16] 	 
    1.992216  ,  // [17] 	 
    2.013171  ,  // [18] 	 
    2.048627  ,  // [19] 	 
    2.062606  ,  // [20] 	 
    2.097740  ,  // [21] 	 
    2.119346  ,  // [22] 	 
    2.141180  ,  // [23] 	 
    2.167457  ,  // [24] 	 
    2.189224  ,  // [25] 	 
    2.211153  ,  // [26] 	 
    2.233223  ,  // [27] 	 
    2.267539  ,  // [28] 	 
    2.289626  ,  // [29] 	 
    2.311779  ,  // [30] 	 
    2.333976  ,  // [31] 	 
    2.356194  ,  // [32] 	 
    2.378413  ,  // [33] 	 
    2.412315  ,  // [34] 	 
    2.434685  ,  // [35] 	 
    2.456975  ,  // [36] 	 
    2.479166  ,  // [37] 	 
    2.501236  ,  // [38] 	 
    2.536048  ,  // [39] 	 
    2.557957  ,  // [40] 	 
    2.579671  ,  // [41] 	 
    2.614649  ,  // [42] 	 
    2.636012  ,  // [43] 	 
    2.649783  ,  // [44] 	 
    2.684987  ,  // [45] 	 
    2.705910  ,  // [46] 	 
    2.734622  ,  // [47] 	 
    2.755255  ,  // [48] 	 
    2.769884  ,  // [49] 	 
    2.804918  ,  // [50] 	 
    2.824768  ,  // [51] 	 
    2.854654  ,  // [52] 	 
    2.869800  ,  // [53] 	 
    2.904218  ,  // [54] 	 
    2.919511  ,  // [55] 	 
    2.953371  ,  // [56] 	 
    2.968732  ,  // [57] 	 
    2.999696  ,  // [58] 	 
    3.015285  ,  // [59] 	 
    3.046641  ,  // [60] 	 
    3.079174  ,  // [61] 	 
    3.094752  ,  // [62] 	 
    3.125969  ,  // [63] 	 
    -M_PI,       // 3.141593  ,  // [64] 	 
   -3.110353  ,  // [65] 	 
   -3.094752  ,  // [66] 	 
   -3.063626  ,  // [67] 	 
   -3.046641  ,  // [68] 	 
   -3.015285  ,  // [69] 	 
   -2.984176  ,  // [70] 	 
   -2.968732  ,  // [71] 	 
   -2.938100  ,  // [72] 	 
   -2.919511  ,  // [73] 	 
   -2.889038  ,  // [74] 	 
   -2.869800  ,  // [75] 	 
   -2.839641  ,  // [76] 	 
   -2.824768  ,  // [77] 	 
   -2.790148  ,  // [78] 	 
   -2.769884  ,  // [79] 	 
   -2.740799  ,  // [80] 	 
   -2.720173  ,  // [81] 	 
   -2.705910  ,  // [82] 	 
   -2.670952  ,  // [83] 	 
   -2.649783  ,  // [84] 	 
   -2.622447  ,  // [85] 	 
   -2.601173  ,  // [86] 	 
   -2.579671  ,  // [87] 	 
   -2.544932  ,  // [88] 	 
   -2.523165  ,  // [89] 	 
   -2.501236  ,  // [90] 	 
   -2.479166  ,  // [91] 	 
   -2.444850  ,  // [92] 	 
   -2.422763  ,  // [93] 	 
   -2.400610  ,  // [94] 	 
   -2.378413  ,  // [95] 	 
   -2.356194  ,  // [96] 	 
   -2.333976  ,  // [97] 	 
   -2.311779  ,  // [98] 	 
   -2.289626  ,  // [99] 	 
   -2.267539  ,  // [100]	 
   -2.233223  ,  // [101]	 
   -2.211153  ,  // [102]	 
   -2.189224  ,  // [103]	 
   -2.167457  ,  // [104]	 
   -2.132718  ,  // [105]	 
   -2.111216  ,  // [106]	 
   -2.089942  ,  // [107]	 
   -2.062606  ,  // [108]	 
   -2.041437  ,  // [109]	 
   -2.006479  ,  // [110]	 
   -1.992216  ,  // [111]	 
   -1.971590  ,  // [112]	 
   -1.942505  ,  // [113]	 
   -1.922241  ,  // [114]	 
   -1.887621  ,  // [115]	 
   -1.872747  ,  // [116]	 
   -1.842588  ,  // [117]	 
   -1.823351  ,  // [118]	 
   -1.792878  ,  // [119]	 
   -1.774289  ,  // [120]	 
   -1.743657  ,  // [121]	 
   -1.728213  ,  // [122]	 
   -1.697104  ,  // [123]	 
   -1.665748  ,  // [124]	 
   -1.648763  ,  // [125]	 
   -1.617637  ,  // [126]	 
   -1.602036  ,  // [127]	 
   -1.570796  ,  // [128]	 
   -1.555173  ,  // [129]	 
   -1.523956  ,  // [130]	 
   -1.508378  ,  // [131]	 
   -1.475845  ,  // [132]	 
   -1.444488  ,  // [133]	 
   -1.428899  ,  // [134]	 
   -1.397936  ,  // [135]	 
   -1.382575  ,  // [136]	 
   -1.348714  ,  // [137]	 
   -1.333422  ,  // [138]	 
   -1.299004  ,  // [139]	 
   -1.283858  ,  // [140]	 
   -1.253972  ,  // [141]	 
   -1.234122  ,  // [142]	 
   -1.199087  ,  // [143]	 
   -1.184459  ,  // [144]	 
   -1.163826  ,  // [145]	 
   -1.135113  ,  // [146]	 
   -1.114191  ,  // [147]	 
   -1.078987  ,  // [148]	 
   -1.065215  ,  // [149]	 
   -1.043853  ,  // [150]	 
   -1.008875  ,  // [151]	 
   -0.987161  ,  // [152]	 
   -0.965252  ,  // [153]	 
   -0.930440  ,  // [154]	 
   -0.908370  ,  // [155]	 
   -0.886179  ,  // [156]	 
   -0.863888  ,  // [157]	 
   -0.841519  ,  // [158]	 
   -0.807617  ,  // [159]	 
   -0.785398  ,  // [160]	 
   -0.763180  ,  // [161]	 
   -0.740983  ,  // [162]	 
   -0.718830  ,  // [163]	 
   -0.696742  ,  // [164]	 
   -0.662426  ,  // [165]	 
   -0.640356  ,  // [166]	 
   -0.618428  ,  // [167]	 
   -0.596660  ,  // [168]	 
   -0.570383  ,  // [169]	 
   -0.548549  ,  // [170]	 
   -0.526943  ,  // [171]	 
   -0.491809  ,  // [172]	 
   -0.477831  ,  // [173]	 
   -0.442374  ,  // [174]	 
   -0.421419  ,  // [175]	 
   -0.406971  ,  // [176]	 
   -0.371709  ,  // [177]	 
   -0.351445  ,  // [178]	 
   -0.321751  ,  // [179]	 
   -0.301951  ,  // [180]	 
   -0.271792  ,  // [181]	 
   -0.256517  ,  // [182]	 
   -0.222082  ,  // [183]	 
   -0.206683  ,  // [184]	 
   -0.175592  ,  // [185]	 
   -0.157417  ,  // [186]	 
   -0.126308  ,  // [187]	 
   -0.094952  ,  // [188]	 
   -0.079199  ,  // [189]	 
   -0.047583  ,  // [190]	 
   -0.031735  ,  // [191]	 
    0.000000  ,  // [192]	 
    0.015872  ,  // [193]	 
    0.047583  ,  // [194]	 
    0.063407  ,  // [195]	 
    0.094952  ,  // [196]	 
    0.126308  ,  // [197]	 
    0.141897  ,  // [198]	 
    0.175592  ,  // [199]	 
    0.191184  ,  // [200]	 
    0.222082  ,  // [201]	 
    0.241118  ,  // [202]	 
    0.271792  ,  // [203]	 
    0.286939  ,  // [204]	 
    0.321751  ,  // [205]	 
    0.336675  ,  // [206]	 
    0.371709  ,  // [207]	 
    0.392340  ,  // [208]	 
    0.406971  ,  // [209]	 
    0.442374  ,  // [210]	 
    0.463648  ,  // [211]	 
    0.491809  ,  // [212]	 
    0.513252  ,  // [213]	 
    0.534955  ,  // [214]	 
    0.570383  ,  // [215]	 
    0.583636  ,  // [216]	 
    0.605545  ,  // [217]	 
    0.640356  ,  // [218]	 
    0.662426  ,  // [219]	 
    0.684617  ,  // [220]	 
    0.706908  ,  // [221]	 
    0.729277  ,  // [222]	 
    0.763180  ,  // [223]	 
    0.785398  ,  // [224]	 
    0.807617  ,  // [225]	 
    0.841519  ,  // [226]	 
    0.863888  ,  // [227]	 
    0.886179  ,  // [228]	 
    0.908370  ,  // [229]	 
    0.930440  ,  // [230]	 
    0.965252  ,  // [231]	 
    0.987161  ,  // [232]	 
    1.000413  ,  // [233]	 
    1.035841  ,  // [234]	 
    1.057544  ,  // [235]	 
    1.078987  ,  // [236]	 
    1.107149  ,  // [237]	 
    1.128422  ,  // [238]	 
    1.163826  ,  // [239]	 
    1.178456  ,  // [240]	 
    1.199087  ,  // [241]	 
    1.234122  ,  // [242]	 
    1.249046  ,  // [243]	 
    1.283858  ,  // [244]	 
    1.299004  ,  // [245]	 
    1.329679  ,  // [246]	 
    1.348714  ,  // [247]	 
    1.379612  ,  // [248]	 
    1.395204  ,  // [249]	 
    1.428899  ,  // [250]	 
    1.444488  ,  // [251]	 
    1.475845  ,  // [252]	 
    1.507389  ,  // [253]	 
    1.523213  ,  // [254]	 
    1.554925     // [255]	 
};
// Positive Drehrichtung nach links:
static const int phx[256]={
  0,      // phx[0]   
  -152,   // phx[1]   
  -152,   // phx[2]   
  -152,	  // phx[3]   
  -152,   // phx[4]   
  -296,   // phx[5]   
  -296,   // phx[6]   
  -296,   // phx[7]   
  -296,   // phx[8]   
  -440,   // phx[9]   
  -440,   // phx[10]  
  -440,   // phx[11]  
  -440,   // phx[12]  
  -584,   // phx[13]  
  -584,   // phx[14]  
  -584,   // phx[15]  
  -584,   // phx[16]  
  -720,   // phx[17]  
  -720,   // phx[18]  
  -720,   // phx[19]  
  -720,   // phx[20]  
  -856,   // phx[21]  
  -856,   // phx[22]  
  -856,   // phx[23]  
  -856,   // phx[24]  
  -976,   // phx[25]  
  -976,   // phx[26]  
  -976,   // phx[27]  
  -976,   // phx[28]  
  -1088,  // phx[29]  
  -1088,  // phx[30]  
  -1088,  // phx[31]  
  -1088,  // phx[32]  
  -1192,  // phx[33]  
  -1192,  // phx[34]  
  -1192,  // phx[35]  
  -1192,  // phx[36]  
  -1280,  // phx[37]  
  -1280,  // phx[38]  
  -1280,  // phx[39]  
  -1280,  // phx[40]  
  -1360,  // phx[41]  
  -1360,  // phx[42]  
  -1360,  // phx[43]  
  -1360,  // phx[44]  
  -1416,  // phx[45]  
  -1416,  // phx[46]  
  -1416,  // phx[47]  
  -1416,  // phx[48]  
  -1472,  // phx[49]  
  -1472,  // phx[50]  
  -1472,  // phx[51]  
  -1472,  // phx[52]  
  -1504,  // phx[53]  
  -1504,  // phx[54]  
  -1504,  // phx[55]  
  -1504,  // phx[56]  
  -1528,  // phx[57]  
  -1528,  // phx[58]  
  -1528,  // phx[59]  
  -1528,  // phx[60]  
  -1536,  // phx[61]  
  -1536,  // phx[62]  
  -1536,  // phx[63]  
  -1536,  // phx[64]  
  -1536,  // phx[65]  
  -1536,  // phx[66]  
  -1536,  // phx[67]  
  -1528,  // phx[68]  
  -1528,  // phx[69]  
  -1528,  // phx[70]  
  -1528,  // phx[71]  
  -1504,  // phx[72]  
  -1504,  // phx[73]  
  -1504,  // phx[74]  
  -1504,  // phx[75]  
  -1472,  // phx[76]  
  -1472,  // phx[77]  
  -1472,  // phx[78]  
  -1472,  // phx[79]  
  -1416,  // phx[80]  
  -1416,  // phx[81]  
  -1416,  // phx[82]  
  -1416,  // phx[83]  
  -1360,  // phx[84]  
  -1360,  // phx[85]  
  -1360,  // phx[86]  
  -1360,  // phx[87]  
  -1280,  // phx[88]  
  -1280,  // phx[89]  
  -1280,  // phx[90]  
  -1280,  // phx[91]  
  -1192,  // phx[92]  
  -1192,  // phx[93]  
  -1192,  // phx[94]  
  -1192,  // phx[95]  
  -1088,  // phx[96]  
  -1088,  // phx[97]  
  -1088,  // phx[98]  
  -1088,  // phx[99]  
  -976,   // phx[100] 
  -976,   // phx[101] 
  -976,   // phx[102] 
  -976,   // phx[103] 
  -856,   // phx[104] 
  -856,   // phx[105] 
  -856,   // phx[106] 
  -856,   // phx[107] 
  -720,   // phx[108] 
  -720,   // phx[109] 
  -720,   // phx[110] 
  -720,   // phx[111] 
  -584,   // phx[112] 
  -584,   // phx[113] 
  -584,   // phx[114] 
  -584,   // phx[115] 
  -440,   // phx[116] 
  -440,   // phx[117] 
  -440,   // phx[118] 
  -440,   // phx[119] 
  -296,   // phx[120] 
  -296,   // phx[121] 
  -296,   // phx[122] 
  -296,   // phx[123] 
  -152,   // phx[124] 
  -152,   // phx[125] 
  -152,   // phx[126] 
  -152,   // phx[127] 
  0,      // phx[128] 
  152,    // phx[129] 
  152,    // phx[130] 
  152,    // phx[131] 
  152,    // phx[132] 
  296,    // phx[133] 
  296,    // phx[134] 
  296,    // phx[135] 
  296,    // phx[136] 
  440,    // phx[137] 
  440,    // phx[138] 
  440,    // phx[139] 
  440,    // phx[140] 
  584,    // phx[141] 
  584,    // phx[142] 
  584,    // phx[143] 
  584,    // phx[144] 
  720,    // phx[145] 
  720,    // phx[146] 
  720,    // phx[147] 
  720,    // phx[148] 
  856,    // phx[149] 
  856,    // phx[150] 
  856,    // phx[151] 
  856,    // phx[152] 
  976,    // phx[153] 
  976,    // phx[154] 
  976,    // phx[155] 
  976,    // phx[156] 
  1088,   // phx[157] 
  1088,   // phx[158] 
  1088,   // phx[159] 
  1088,   // phx[160] 
  1192,   // phx[161] 
  1192,   // phx[162] 
  1192,   // phx[163] 
  1192,   // phx[164] 
  1280,   // phx[165] 
  1280,   // phx[166] 
  1280,   // phx[167] 
  1280,   // phx[168] 
  1360,   // phx[169] 
  1360,   // phx[170] 
  1360,   // phx[171] 
  1360,   // phx[172] 
  1416,   // phx[173] 
  1416,   // phx[174] 
  1416,   // phx[175] 
  1416,   // phx[176] 
  1472,   // phx[177] 
  1472,   // phx[178] 
  1472,   // phx[179] 
  1472,   // phx[180] 
  1504,   // phx[181] 
  1504,   // phx[182] 
  1504,   // phx[183] 
  1504,   // phx[184] 
  1528,   // phx[185] 
  1528,   // phx[186] 
  1528,   // phx[187] 
  1528,   // phx[188] 
  1536,   // phx[189] 
  1536,   // phx[190] 
  1536,   // phx[191] 
  1536,   // phx[192] 
  1536,   // phx[193] 
  1536,   // phx[194] 
  1536,   // phx[195] 
  1528,   // phx[196] 
  1528,   // phx[197] 
  1528,   // phx[198] 
  1528,   // phx[199] 
  1504,   // phx[200] 
  1504,   // phx[201] 
  1504,   // phx[202] 
  1504,   // phx[203] 
  1472,   // phx[204] 
  1472,   // phx[205] 
  1472,   // phx[206] 
  1472,   // phx[207] 
  1416,   // phx[208] 
  1416,   // phx[209] 
  1416,   // phx[210] 
  1416,   // phx[211] 
  1360,   // phx[212] 
  1360,   // phx[213] 
  1360,   // phx[214] 
  1360,   // phx[215] 
  1280,   // phx[216] 
  1280,   // phx[217] 
  1280,   // phx[218] 
  1280,   // phx[219] 
  1192,   // phx[220] 
  1192,   // phx[221] 
  1192,   // phx[222] 
  1192,   // phx[223] 
  1088,   // phx[224] 
  1088,   // phx[225] 
  1088,   // phx[226] 
  1088,   // phx[227] 
  976,    // phx[228] 
  976,    // phx[229] 
  976,    // phx[230] 
  976,    // phx[231] 
  856,    // phx[232] 
  856,    // phx[233] 
  856,    // phx[234] 
  856,    // phx[235] 
  720,    // phx[236] 
  720,    // phx[237] 
  720,    // phx[238] 
  720,    // phx[239] 
  584,    // phx[240] 
  584,    // phx[241] 
  584,    // phx[242] 
  584,    // phx[243] 
  440,    // phx[244] 
  440,    // phx[245] 
  440,    // phx[246] 
  440,    // phx[247] 
  296,    // phx[248] 
  296,    // phx[249] 
  296,    // phx[250] 
  296,    // phx[251] 
  152,    // phx[252] 
  152,    // phx[253] 
  152,    // phx[254] 
  152	  // phx[255] 
};
static const int phy[256]={
  1536,   // phy[0]  
  1528,	  // phy[1]  
  1528,	  // phy[2]  
  1528,	  // phy[3]  
  1528,	  // phy[4]  
  1504,	  // phy[5]  
  1504,	  // phy[6]  
  1504,	  // phy[7]  
  1504,	  // phy[8]  
  1472,	  // phy[9]  
  1472,	  // phy[10] 
  1472,	  // phy[11] 
  1472,	  // phy[12] 
  1416,	  // phy[13] 
  1416,	  // phy[14] 
  1416,	  // phy[15] 
  1416,	  // phy[16] 
  1360,	  // phy[17] 
  1360,	  // phy[18] 
  1360,	  // phy[19] 
  1360,	  // phy[20] 
  1280,	  // phy[21] 
  1280,	  // phy[22] 
  1280,	  // phy[23] 
  1280,	  // phy[24] 
  1192,	  // phy[25] 
  1192,	  // phy[26] 
  1192,	  // phy[27] 
  1192,	  // phy[28] 
  1088,	  // phy[29] 
  1088,	  // phy[30] 
  1088,	  // phy[31] 
  1088,	  // phy[32] 
  976 ,	  // phy[33] 
  976 ,	  // phy[34] 
  976 ,	  // phy[35] 
  976 ,	  // phy[36] 
  856 ,	  // phy[37] 
  856 ,	  // phy[38] 
  856 ,	  // phy[39] 
  856 ,	  // phy[40] 
  720 ,	  // phy[41] 
  720 ,	  // phy[42] 
  720 ,	  // phy[43] 
  720 ,	  // phy[44] 
  584 ,	  // phy[45] 
  584 ,	  // phy[46] 
  584 ,	  // phy[47] 
  584 ,	  // phy[48] 
  440 ,	  // phy[49] 
  440 ,	  // phy[50] 
  440 ,	  // phy[51] 
  440 ,	  // phy[52] 
  296 ,	  // phy[53] 
  296 ,	  // phy[54] 
  296 ,	  // phy[55] 
  296 ,	  // phy[56] 
  152 ,	  // phy[57] 
  152 ,	  // phy[58] 
  152 ,	  // phy[59] 
  152 ,	  // phy[60] 
  0   ,	  // phy[61] 
  0   ,	  // phy[62] 
  0   ,	  // phy[63] 
  0   ,	  // phy[64] 
  0   ,	  // phy[65] 
  0   ,	  // phy[66] 
  0   ,	  // phy[67] 
  -152,	  // phy[68] 
  -152,	  // phy[69] 
  -152,	  // phy[70] 
  -152,	  // phy[71] 
  -296,	  // phy[72] 
  -296,	  // phy[73] 
  -296,	  // phy[74] 
  -296,	  // phy[75] 
  -440,	  // phy[76] 
  -440,	  // phy[77] 
  -440,	  // phy[78] 
  -440,	  // phy[79] 
  -584,	  // phy[80] 
  -584,	  // phy[81] 
  -584,	  // phy[82] 
  -584,	  // phy[83] 
  -720,	  // phy[84] 
  -720,	  // phy[85] 
  -720,	  // phy[86] 
  -720,	  // phy[87] 
  -856,	  // phy[88] 
  -856,	  // phy[89] 
  -856,	  // phy[90] 
  -856,	  // phy[91] 
  -976,	  // phy[92] 
  -976,	  // phy[93] 
  -976,	  // phy[94] 
  -976,	  // phy[95] 
  -1088,  // phy[96] 
  -1088,  // phy[97] 
  -1088,  // phy[98] 
  -1088,  // phy[99] 
  -1192,  // phy[100]
  -1192,  // phy[101]
  -1192,  // phy[102]
  -1192,  // phy[103]
  -1280,  // phy[104]
  -1280,  // phy[105]
  -1280,  // phy[106]
  -1280,  // phy[107]
  -1360,  // phy[108]
  -1360,  // phy[109]
  -1360,  // phy[110]
  -1360,  // phy[111]
  -1416,  // phy[112]
  -1416,  // phy[113]
  -1416,  // phy[114]
  -1416,  // phy[115]
  -1472,  // phy[116]
  -1472,  // phy[117]
  -1472,  // phy[118]
  -1472,  // phy[119]
  -1504,  // phy[120]
  -1504,  // phy[121]
  -1504,  // phy[122]
  -1504,  // phy[123]
  -1528,  // phy[124]
  -1528,  // phy[125]
  -1528,  // phy[126]
  -1528,  // phy[127]
  -1536,  // phy[128]
  -1528,  // phy[129]
  -1528,  // phy[130]
  -1528,  // phy[131]
  -1528,  // phy[132]
  -1504,  // phy[133]
  -1504,  // phy[134]
  -1504,  // phy[135]
  -1504,  // phy[136]
  -1472,  // phy[137]
  -1472,  // phy[138]
  -1472,  // phy[139]
  -1472,  // phy[140]
  -1416,  // phy[141]
  -1416,  // phy[142]
  -1416,  // phy[143]
  -1416,  // phy[144]
  -1360,  // phy[145]
  -1360,  // phy[146]
  -1360,  // phy[147]
  -1360,  // phy[148]
  -1280,  // phy[149]
  -1280,  // phy[150]
  -1280,  // phy[151]
  -1280,  // phy[152]
  -1192,  // phy[153]
  -1192,  // phy[154]
  -1192,  // phy[155]
  -1192,  // phy[156]
  -1088,  // phy[157]
  -1088,  // phy[158]
  -1088,  // phy[159]
  -1088,  // phy[160]
  -976,	  // phy[161]
  -976,	  // phy[162]
  -976,	  // phy[163]
  -976,	  // phy[164]
  -856,	  // phy[165]
  -856,	  // phy[166]
  -856,	  // phy[167]
  -856,	  // phy[168]
  -720,	  // phy[169]
  -720,	  // phy[170]
  -720,	  // phy[171]
  -720,	  // phy[172]
  -584,	  // phy[173]
  -584,	  // phy[174]
  -584,	  // phy[175]
  -584,	  // phy[176]
  -440,	  // phy[177]
  -440,	  // phy[178]
  -440,	  // phy[179]
  -440,	  // phy[180]
  -296,	  // phy[181]
  -296,	  // phy[182]
  -296,	  // phy[183]
  -296,	  // phy[184]
  -152,	  // phy[185]
  -152,	  // phy[186]
  -152,	  // phy[187]
  -152,	  // phy[188]
  0   ,	  // phy[189]
  0   ,	  // phy[190]
  0   ,	  // phy[191]
  0   ,	  // phy[192]
  0   ,	  // phy[193]
  0   ,	  // phy[194]
  0   ,	  // phy[195]
  152 ,	  // phy[196]
  152 ,	  // phy[197]
  152 ,	  // phy[198]
  152 ,	  // phy[199]
  296 ,	  // phy[200]
  296 ,	  // phy[201]
  296 ,	  // phy[202]
  296 ,	  // phy[203]
  440 ,	  // phy[204]
  440 ,	  // phy[205]
  440 ,	  // phy[206]
  440 ,	  // phy[207]
  584 ,	  // phy[208]
  584 ,	  // phy[209]
  584 ,	  // phy[210]
  584 ,	  // phy[211]
  720 ,	  // phy[212]
  720 ,	  // phy[213]
  720 ,	  // phy[214]
  720 ,	  // phy[215]
  856 ,	  // phy[216]
  856 ,	  // phy[217]
  856 ,	  // phy[218]
  856 ,	  // phy[219]
  976 ,	  // phy[220]
  976 ,	  // phy[221]
  976 ,	  // phy[222]
  976 ,	  // phy[223]
  1088,	  // phy[224]
  1088,	  // phy[225]
  1088,	  // phy[226]
  1088,	  // phy[227]
  1192,	  // phy[228]
  1192,	  // phy[229]
  1192,	  // phy[230]
  1192,	  // phy[231]
  1280,	  // phy[232]
  1280,	  // phy[233]
  1280,	  // phy[234]
  1280,	  // phy[235]
  1360,	  // phy[236]
  1360,	  // phy[237]
  1360,	  // phy[238]
  1360,	  // phy[239]
  1416,	  // phy[240]
  1416,	  // phy[241]
  1416,	  // phy[242]
  1416,	  // phy[243]
  1472,	  // phy[244]
  1472,	  // phy[245]
  1472,	  // phy[246]
  1472,	  // phy[247]
  1504,	  // phy[248]
  1504,	  // phy[249]
  1504,	  // phy[250]
  1504,	  // phy[251]
  1528,	  // phy[252]
  1528,	  // phy[253]
  1528,	  // phy[254]
  1528	  // phy[255]
};
static const  double astsin[256]={
127.0/128.,
127.0/128.,
127.0/128.,
127.0/128.,
126.0/128.,
126.0/128.,
126.0/128.,
125.0/128.,
125.0/128.,
124.0/128.,
123.0/128.,
122.0/128.,
122.0/128.,
121.0/128.,
120.0/128.,
118.0/128.,
117.0/128.,
116.0/128.,
115.0/128.,
113.0/128.,
112.0/128.,
111.0/128.,
109.0/128.,
107.0/128.,
106.0/128.,
104.0/128.,
102.0/128.,
100.0/128.,
98.0/128.,
96.0/128.,
94.0/128.,
92.0/128.,
90.0/128.,
88.0/128.,
85.0/128.,
83.0/128.,
81.0/128.,
78.0/128.,
76.0/128.,
73.0/128.,
71.0/128.,
68.0/128.,
65.0/128.,
63.0/128.,
60.0/128.,
57.0/128.,
54.0/128.,
51.0/128.,
49.0/128.,
46.0/128.,
43.0/128.,
40.0/128.,
37.0/128.,
34.0/128.,
31.0/128.,
28.0/128.,
25.0/128.,
22.0/128.,
19.0/128.,
16.0/128.,
12.0/128.,
 9.0/128.,
 6.0/128.,
 3.0/128.,
 0.0/128.,
-3.0/128.,
-6.0/128.,
-9.0/128.,
-12.0/128.,
-16.0/128.,
-19.0/128.,
-22.0/128.,
-25.0/128.,
-28.0/128.,
-31.0/128.,
-34.0/128.,
-37.0/128.,
-40.0/128.,
-43.0/128.,
-46.0/128.,
-49.0/128.,
-51.0/128.,
-54.0/128.,
-57.0/128.,
-60.0/128.,
-63.0/128.,
-65.0/128.,
-68.0/128.,
-71.0/128.,
-73.0/128.,
-76.0/128.,
-78.0/128.,
-81.0/128.,
-83.0/128.,
-85.0/128.,
-88.0/128.,
-90.0/128.,
-92.0/128.,
-94.0/128.,
-96.0/128.,
-98.0/128.,
-100.0/128.,
-102.0/128.,
-104.0/128.,
-106.0/128.,
-107.0/128.,
-109.0/128.,
-111.0/128.,
-112.0/128.,
-113.0/128.,
-115.0/128.,
-116.0/128.,
-117.0/128.,
-118.0/128.,
-120.0/128.,
-121.0/128.,
-122.0/128.,
-122.0/128.,
-123.0/128.,
-124.0/128.,
-125.0/128.,
-125.0/128.,
-126.0/128.,
-126.0/128.,
-126.0/128.,
-127.0/128.,
-127.0/128.,
-127.0/128.,
-127.0/128.,
-127.0/128.,
-127.0/128.,
-127.0/128.,
-126.0/128.,
-126.0/128.,
-126.0/128.,
-125.0/128.,
-125.0/128.,
-124.0/128.,
-123.0/128.,
-122.0/128.,
-122.0/128.,
-121.0/128.,
-120.0/128.,
-118.0/128.,
-117.0/128.,
-116.0/128.,
-115.0/128.,
-113.0/128.,
-112.0/128.,
-111.0/128.,
-109.0/128.,
-107.0/128.,
-106.0/128.,
-104.0/128.,
-102.0/128.,
-100.0/128.,
-98.0/128.,
-96.0/128.,
-94.0/128.,
-92.0/128.,
-90.0/128.,
-88.0/128.,
-85.0/128.,
-83.0/128.,
-81.0/128.,
-78.0/128.,
-76.0/128.,
-73.0/128.,
-71.0/128.,
-68.0/128.,
-65.0/128.,
-63.0/128.,
-60.0/128.,
-57.0/128.,
-54.0/128.,
-51.0/128.,
-49.0/128.,
-46.0/128.,
-43.0/128.,
-40.0/128.,
-37.0/128.,
-34.0/128.,
-31.0/128.,
-28.0/128.,
-25.0/128.,
-22.0/128.,
-19.0/128.,
-16.0/128.,
-12.0/128.,
-9.0/128.,
-6.0/128.,
-3.0/128.,
 0.0/128.,
 3.0/128.,
 6.0/128.,
 9.0/128.,
12.0/128.,
16.0/128.,
19.0/128.,
22.0/128.,
25.0/128.,
28.0/128.,
31.0/128.,
34.0/128.,
37.0/128.,
40.0/128.,
43.0/128.,
46.0/128.,
49.0/128.,
51.0/128.,
54.0/128.,
57.0/128.,
60.0/128.,
63.0/128.,
65.0/128.,
68.0/128.,
71.0/128.,
73.0/128.,
76.0/128.,
78.0/128.,
81.0/128.,
83.0/128.,
85.0/128.,
88.0/128.,
90.0/128.,
92.0/128.,
94.0/128.,
96.0/128.,
98.0/128.,
100.0/128.,
102.0/128.,
104.0/128.,
106.0/128.,
107.0/128.,
109.0/128.,
111.0/128.,
112.0/128.,
113.0/128.,
115.0/128.,
116.0/128.,
117.0/128.,
118.0/128.,
120.0/128.,
121.0/128.,
122.0/128.,
122.0/128.,
123.0/128.,
124.0/128.,
125.0/128.,
125.0/128.,
126.0/128.,
126.0/128.,
126.0/128.,
127.0/128.,
127.0/128.,
127.0/128.
};

static const  double astcos[256]={
 0.0/128.,
-3.0/128.,
-6.0/128.,
-9.0/128.,
-12.0/128.,
-16.0/128.,
-19.0/128.,
-22.0/128.,
-25.0/128.,
-28.0/128.,
-31.0/128.,
-34.0/128.,
-37.0/128.,
-40.0/128.,
-43.0/128.,
-46.0/128.,
-49.0/128.,
-51.0/128.,
-54.0/128.,
-57.0/128.,
-60.0/128.,
-63.0/128.,
-65.0/128.,
-68.0/128.,
-71.0/128.,
-73.0/128.,
-76.0/128.,
-78.0/128.,
-81.0/128.,
-83.0/128.,
-85.0/128.,
-88.0/128.,
-90.0/128.,
-92.0/128.,
-94.0/128.,
-96.0/128.,
-98.0/128.,
-100.0/128.,
-102.0/128.,
-104.0/128.,
-106.0/128.,
-107.0/128.,
-109.0/128.,
-111.0/128.,
-112.0/128.,
-113.0/128.,
-115.0/128.,
-116.0/128.,
-117.0/128.,
-118.0/128.,
-120.0/128.,
-121.0/128.,
-122.0/128.,
-122.0/128.,
-123.0/128.,
-124.0/128.,
-125.0/128.,
-125.0/128.,
-126.0/128.,
-126.0/128.,
-126.0/128.,
-127.0/128.,
-127.0/128.,
-127.0/128.,
-127.0/128.,
-127.0/128.,
-127.0/128.,
-127.0/128.,
-126.0/128.,
-126.0/128.,
-126.0/128.,
-125.0/128.,
-125.0/128.,
-124.0/128.,
-123.0/128.,
-122.0/128.,
-122.0/128.,
-121.0/128.,
-120.0/128.,
-118.0/128.,
-117.0/128.,
-116.0/128.,
-115.0/128.,
-113.0/128.,
-112.0/128.,
-111.0/128.,
-109.0/128.,
-107.0/128.,
-106.0/128.,
-104.0/128.,
-102.0/128.,
-100.0/128.,
-98.0/128.,
-96.0/128.,
-94.0/128.,
-92.0/128.,
-90.0/128.,
-88.0/128.,
-85.0/128.,
-83.0/128.,
-81.0/128.,
-78.0/128.,
-76.0/128.,
-73.0/128.,
-71.0/128.,
-68.0/128.,
-65.0/128.,
-63.0/128.,
-60.0/128.,
-57.0/128.,
-54.0/128.,
-51.0/128.,
-49.0/128.,
-46.0/128.,
-43.0/128.,
-40.0/128.,
-37.0/128.,
-34.0/128.,
-31.0/128.,
-28.0/128.,
-25.0/128.,
-22.0/128.,
-19.0/128.,
-16.0/128.,
-12.0/128.,
-9.0/128.,
-6.0/128.,
-3.0/128.,
 0.0/128.,
 3.0/128.,
 6.0/128.,
 9.0/128.,
12.0/128.,
16.0/128.,
19.0/128.,
22.0/128.,
25.0/128.,
28.0/128.,
31.0/128.,
34.0/128.,
37.0/128.,
40.0/128.,
43.0/128.,
46.0/128.,
49.0/128.,
51.0/128.,
54.0/128.,
57.0/128.,
60.0/128.,
63.0/128.,
65.0/128.,
68.0/128.,
71.0/128.,
73.0/128.,
76.0/128.,
78.0/128.,
81.0/128.,
83.0/128.,
85.0/128.,
88.0/128.,
90.0/128.,
92.0/128.,
94.0/128.,
96.0/128.,
98.0/128.,
100.0/128.,
102.0/128.,
104.0/128.,
106.0/128.,
107.0/128.,
109.0/128.,
111.0/128.,
112.0/128.,
113.0/128.,
115.0/128.,
116.0/128.,
117.0/128.,
118.0/128.,
120.0/128.,
121.0/128.,
122.0/128.,
122.0/128.,
123.0/128.,
124.0/128.,
125.0/128.,
125.0/128.,
126.0/128.,
126.0/128.,
126.0/128.,
127.0/128.,
127.0/128.,
127.0/128.,
127.0/128.,
127.0/128.,
127.0/128.,
127.0/128.,
126.0/128.,
126.0/128.,
126.0/128.,
125.0/128.,
125.0/128.,
124.0/128.,
123.0/128.,
122.0/128.,
122.0/128.,
121.0/128.,
120.0/128.,
118.0/128.,
117.0/128.,
116.0/128.,
115.0/128.,
113.0/128.,
112.0/128.,
111.0/128.,
109.0/128.,
107.0/128.,
106.0/128.,
104.0/128.,
102.0/128.,
100.0/128.,
98.0/128.,
96.0/128.,
94.0/128.,
92.0/128.,
90.0/128.,
88.0/128.,
85.0/128.,
83.0/128.,
81.0/128.,
78.0/128.,
76.0/128.,
73.0/128.,
71.0/128.,
68.0/128.,
65.0/128.,
63.0/128.,
60.0/128.,
57.0/128.,
54.0/128.,
51.0/128.,
49.0/128.,
46.0/128.,
43.0/128.,
40.0/128.,
37.0/128.,
34.0/128.,
31.0/128.,
28.0/128.,
25.0/128.,
22.0/128.,
19.0/128.,
16.0/128.,
12.0/128.,
 9.0/128.,
 6.0/128.,
 3.0/128.
};
static const double rfact[256]={
  1./cos(octWrap(shotph[0  ])),
  1./cos(octWrap(shotph[1  ])),
  1./cos(octWrap(shotph[2  ])),
  1./cos(octWrap(shotph[3  ])),
  1./cos(octWrap(shotph[4  ])),
  1./cos(octWrap(shotph[5  ])),
  1./cos(octWrap(shotph[6  ])),
  1./cos(octWrap(shotph[7  ])),
  1./cos(octWrap(shotph[8  ])),
  1./cos(octWrap(shotph[9  ])),
  1./cos(octWrap(shotph[10 ])),
  1./cos(octWrap(shotph[11 ])),
  1./cos(octWrap(shotph[12 ])),
  1./cos(octWrap(shotph[13 ])),
  1./cos(octWrap(shotph[14 ])),
  1./cos(octWrap(shotph[15 ])),
  1./cos(octWrap(shotph[16 ])),
  1./cos(octWrap(shotph[17 ])),
  1./cos(octWrap(shotph[18 ])),
  1./cos(octWrap(shotph[19 ])),
  1./cos(octWrap(shotph[20 ])),
  1./cos(octWrap(shotph[21 ])),
  1./cos(octWrap(shotph[22 ])),
  1./cos(octWrap(shotph[23 ])),
  1./cos(octWrap(shotph[24 ])),
  1./cos(octWrap(shotph[25 ])),
  1./cos(octWrap(shotph[26 ])),
  1./cos(octWrap(shotph[27 ])),
  1./cos(octWrap(shotph[28 ])),
  1./cos(octWrap(shotph[29 ])),
  1./cos(octWrap(shotph[30 ])),
  1./cos(octWrap(shotph[31 ])),
  1./cos(octWrap(shotph[32 ])),
  1./cos(octWrap(shotph[33 ])),
  1./cos(octWrap(shotph[34 ])),
  1./cos(octWrap(shotph[35 ])),
  1./cos(octWrap(shotph[36 ])),
  1./cos(octWrap(shotph[37 ])),
  1./cos(octWrap(shotph[38 ])),
  1./cos(octWrap(shotph[39 ])),
  1./cos(octWrap(shotph[40 ])),
  1./cos(octWrap(shotph[41 ])),
  1./cos(octWrap(shotph[42 ])),
  1./cos(octWrap(shotph[43 ])),
  1./cos(octWrap(shotph[44 ])),
  1./cos(octWrap(shotph[45 ])),
  1./cos(octWrap(shotph[46 ])),
  1./cos(octWrap(shotph[47 ])),
  1./cos(octWrap(shotph[48 ])),
  1./cos(octWrap(shotph[49 ])),
  1./cos(octWrap(shotph[50 ])),
  1./cos(octWrap(shotph[51 ])),
  1./cos(octWrap(shotph[52 ])),
  1./cos(octWrap(shotph[53 ])),
  1./cos(octWrap(shotph[54 ])),
  1./cos(octWrap(shotph[55 ])),
  1./cos(octWrap(shotph[56 ])),
  1./cos(octWrap(shotph[57 ])),
  1./cos(octWrap(shotph[58 ])),
  1./cos(octWrap(shotph[59 ])),
  1./cos(octWrap(shotph[60 ])),
  1./cos(octWrap(shotph[61 ])),
  1./cos(octWrap(shotph[62 ])),
  1./cos(octWrap(shotph[63 ])),
  1./cos(octWrap(shotph[64 ])),
  1./cos(octWrap(shotph[65 ])),
  1./cos(octWrap(shotph[66 ])),
  1./cos(octWrap(shotph[67 ])),
  1./cos(octWrap(shotph[68 ])),
  1./cos(octWrap(shotph[69 ])),
  1./cos(octWrap(shotph[70 ])),
  1./cos(octWrap(shotph[71 ])),
  1./cos(octWrap(shotph[72 ])),
  1./cos(octWrap(shotph[73 ])),
  1./cos(octWrap(shotph[74 ])),
  1./cos(octWrap(shotph[75 ])),
  1./cos(octWrap(shotph[76 ])),
  1./cos(octWrap(shotph[77 ])),
  1./cos(octWrap(shotph[78 ])),
  1./cos(octWrap(shotph[79 ])),
  1./cos(octWrap(shotph[80 ])),
  1./cos(octWrap(shotph[81 ])),
  1./cos(octWrap(shotph[82 ])),
  1./cos(octWrap(shotph[83 ])),
  1./cos(octWrap(shotph[84 ])),
  1./cos(octWrap(shotph[85 ])),
  1./cos(octWrap(shotph[86 ])),
  1./cos(octWrap(shotph[87 ])),
  1./cos(octWrap(shotph[88 ])),
  1./cos(octWrap(shotph[89 ])),
  1./cos(octWrap(shotph[90 ])),
  1./cos(octWrap(shotph[91 ])),
  1./cos(octWrap(shotph[92 ])),
  1./cos(octWrap(shotph[93 ])),
  1./cos(octWrap(shotph[94 ])),
  1./cos(octWrap(shotph[95 ])),
  1./cos(octWrap(shotph[96 ])),
  1./cos(octWrap(shotph[97 ])),
  1./cos(octWrap(shotph[98 ])),
  1./cos(octWrap(shotph[99 ])),
  1./cos(octWrap(shotph[100])),
  1./cos(octWrap(shotph[101])),
  1./cos(octWrap(shotph[102])),
  1./cos(octWrap(shotph[103])),
  1./cos(octWrap(shotph[104])),
  1./cos(octWrap(shotph[105])),
  1./cos(octWrap(shotph[106])),
  1./cos(octWrap(shotph[107])),
  1./cos(octWrap(shotph[108])),
  1./cos(octWrap(shotph[109])),
  1./cos(octWrap(shotph[110])),
  1./cos(octWrap(shotph[111])),
  1./cos(octWrap(shotph[112])),
  1./cos(octWrap(shotph[113])),
  1./cos(octWrap(shotph[114])),
  1./cos(octWrap(shotph[115])),
  1./cos(octWrap(shotph[116])),
  1./cos(octWrap(shotph[117])),
  1./cos(octWrap(shotph[118])),
  1./cos(octWrap(shotph[119])),
  1./cos(octWrap(shotph[120])),
  1./cos(octWrap(shotph[121])),
  1./cos(octWrap(shotph[122])),
  1./cos(octWrap(shotph[123])),
  1./cos(octWrap(shotph[124])),
  1./cos(octWrap(shotph[125])),
  1./cos(octWrap(shotph[126])),
  1./cos(octWrap(shotph[127])),
  1./cos(octWrap(shotph[128])),
  1./cos(octWrap(shotph[129])),
  1./cos(octWrap(shotph[130])),
  1./cos(octWrap(shotph[131])),
  1./cos(octWrap(shotph[132])),
  1./cos(octWrap(shotph[133])),
  1./cos(octWrap(shotph[134])),
  1./cos(octWrap(shotph[135])),
  1./cos(octWrap(shotph[136])),
  1./cos(octWrap(shotph[137])),
  1./cos(octWrap(shotph[138])),
  1./cos(octWrap(shotph[139])),
  1./cos(octWrap(shotph[140])),
  1./cos(octWrap(shotph[141])),
  1./cos(octWrap(shotph[142])),
  1./cos(octWrap(shotph[143])),
  1./cos(octWrap(shotph[144])),
  1./cos(octWrap(shotph[145])),
  1./cos(octWrap(shotph[146])),
  1./cos(octWrap(shotph[147])),
  1./cos(octWrap(shotph[148])),
  1./cos(octWrap(shotph[149])),
  1./cos(octWrap(shotph[150])),
  1./cos(octWrap(shotph[151])),
  1./cos(octWrap(shotph[152])),
  1./cos(octWrap(shotph[153])),
  1./cos(octWrap(shotph[154])),
  1./cos(octWrap(shotph[155])),
  1./cos(octWrap(shotph[156])),
  1./cos(octWrap(shotph[157])),
  1./cos(octWrap(shotph[158])),
  1./cos(octWrap(shotph[159])),
  1./cos(octWrap(shotph[160])),
  1./cos(octWrap(shotph[161])),
  1./cos(octWrap(shotph[162])),
  1./cos(octWrap(shotph[163])),
  1./cos(octWrap(shotph[164])),
  1./cos(octWrap(shotph[165])),
  1./cos(octWrap(shotph[166])),
  1./cos(octWrap(shotph[167])),
  1./cos(octWrap(shotph[168])),
  1./cos(octWrap(shotph[169])),
  1./cos(octWrap(shotph[170])),
  1./cos(octWrap(shotph[171])),
  1./cos(octWrap(shotph[172])),
  1./cos(octWrap(shotph[173])),
  1./cos(octWrap(shotph[174])),
  1./cos(octWrap(shotph[175])),
  1./cos(octWrap(shotph[176])),
  1./cos(octWrap(shotph[177])),
  1./cos(octWrap(shotph[178])),
  1./cos(octWrap(shotph[179])),
  1./cos(octWrap(shotph[180])),
  1./cos(octWrap(shotph[181])),
  1./cos(octWrap(shotph[182])),
  1./cos(octWrap(shotph[183])),
  1./cos(octWrap(shotph[184])),
  1./cos(octWrap(shotph[185])),
  1./cos(octWrap(shotph[186])),
  1./cos(octWrap(shotph[187])),
  1./cos(octWrap(shotph[188])),
  1./cos(octWrap(shotph[189])),
  1./cos(octWrap(shotph[190])),
  1./cos(octWrap(shotph[191])),
  1./cos(octWrap(shotph[192])),
  1./cos(octWrap(shotph[193])),
  1./cos(octWrap(shotph[194])),
  1./cos(octWrap(shotph[195])),
  1./cos(octWrap(shotph[196])),
  1./cos(octWrap(shotph[197])),
  1./cos(octWrap(shotph[198])),
  1./cos(octWrap(shotph[199])),
  1./cos(octWrap(shotph[200])),
  1./cos(octWrap(shotph[201])),
  1./cos(octWrap(shotph[202])),
  1./cos(octWrap(shotph[203])),
  1./cos(octWrap(shotph[204])),
  1./cos(octWrap(shotph[205])),
  1./cos(octWrap(shotph[206])),
  1./cos(octWrap(shotph[207])),
  1./cos(octWrap(shotph[208])),
  1./cos(octWrap(shotph[209])),
  1./cos(octWrap(shotph[210])),
  1./cos(octWrap(shotph[211])),
  1./cos(octWrap(shotph[212])),
  1./cos(octWrap(shotph[213])),
  1./cos(octWrap(shotph[214])),
  1./cos(octWrap(shotph[215])),
  1./cos(octWrap(shotph[216])),
  1./cos(octWrap(shotph[217])),
  1./cos(octWrap(shotph[218])),
  1./cos(octWrap(shotph[219])),
  1./cos(octWrap(shotph[220])),
  1./cos(octWrap(shotph[221])),
  1./cos(octWrap(shotph[222])),
  1./cos(octWrap(shotph[223])),
  1./cos(octWrap(shotph[224])),
  1./cos(octWrap(shotph[225])),
  1./cos(octWrap(shotph[226])),
  1./cos(octWrap(shotph[227])),
  1./cos(octWrap(shotph[228])),
  1./cos(octWrap(shotph[229])),
  1./cos(octWrap(shotph[230])),
  1./cos(octWrap(shotph[231])),
  1./cos(octWrap(shotph[232])),
  1./cos(octWrap(shotph[233])),
  1./cos(octWrap(shotph[234])),
  1./cos(octWrap(shotph[235])),
  1./cos(octWrap(shotph[236])),
  1./cos(octWrap(shotph[237])),
  1./cos(octWrap(shotph[238])),
  1./cos(octWrap(shotph[239])),
  1./cos(octWrap(shotph[240])),
  1./cos(octWrap(shotph[241])),
  1./cos(octWrap(shotph[242])),
  1./cos(octWrap(shotph[243])),
  1./cos(octWrap(shotph[244])),
  1./cos(octWrap(shotph[245])),
  1./cos(octWrap(shotph[246])),
  1./cos(octWrap(shotph[247])),
  1./cos(octWrap(shotph[248])),
  1./cos(octWrap(shotph[249])),
  1./cos(octWrap(shotph[250])),
  1./cos(octWrap(shotph[251])),
  1./cos(octWrap(shotph[252])),
  1./cos(octWrap(shotph[253])),
  1./cos(octWrap(shotph[254])),
  1./cos(octWrap(shotph[255]))
};			



#endif
