// -*- mode:C++; -*-
// Zoltan Zomotor
// game.h: Beispielspieler fr Asteroids
// Matthias Fuchs
// Original: Harald Bgeholz / c't
#ifndef gameH
#define gameH

#include "connection.h"
#include "interfaceplayer.h"
static const int MAX_PRAED = 300;
static const int MAX_ASTEROIDS = 100;
static const int ISAUCER = MAX_ASTEROIDS;
static const int MAX_SHOTS = 100;
static const int END_FRAME = 36000; // 60 F/s * 60s/min * 10 Minuten Spielzeit
static const int AST_GROSS = 0;
static const int AST_MITTEL = 15;
static const int AST_KLEIN = 14;
static const int UFO_GROSS = 15;
static const int UFO_KLEIN = 14;
static const double RADIUS_GROSS  = 264./8 ;
static const double RADIUS_MITTEL = 144./8.;
static const double RADIUS_KLEIN  = 84./8.;
static const double RADIUS_SCHIFF = 12;
static const double RADIUS_UFO_KLEIN = RADIUS_KLEIN;
static const double RADIUS_UFO_GROSS = RADIUS_MITTEL;

static const int INDBITS = 3;
static const int INDSIZE = 1<<INDBITS;
static const int INDMASK = INDSIZE-1;

 
inline unsigned char M(unsigned char a) {return a & INDMASK;}
void normWrap(int &dx, int &dy);
void normWrap(double &dx, double &dy);
void shotWrap(double &dx, double &dy);
void normWrap(int &dx, char c);
void normxy(int &x, int &y);
void normxy(double &x, double &y);
void dist(const int& ix, const int& iy, const int& ship_x, const int& ship_y, int &dx, int &dy, int &d);
void dist(const double& x, const double& y, const int& ship_x, const int& ship_y, double &dx, double &dy, double &d);

class Object{
 public:
  int ix,iy;      // aktuelle (gemessene) Koordinaten
  virtual void set(const int& ix, const int& ix);
  void NormXY(); // Koordinaten normalisieren. 0..xmax,0...ymax
};

class Explosion : public Object{
public:
  void set(const int& ix, const int& iy);
};

class Ship : public Object{
 public:
  bool present;  // Schiff sichtbar
  int dx,dy;     // Blickrichtung des Schiffs
  bool IsPresent (void) const;
  void set(const int& _x, const int& _y, const int& _dx, const int& _dy);
};

class Enemy : public Object {
 public:
  double dx,dy; // x,y-Abstand zum Schiff
  double d;
#ifdef OUTPUT
  char name[20];
#endif
  virtual void Dist(const Ship& ship); //Abstandsberechnung
  Enemy(const Enemy&);
  Enemy(void);
};

class Shot : public Enemy
{
public:
  void set(const int& ix, const int& iy);
};

class Saucer : public Enemy
{
 public:
  double radius;  // 
  int size;    // Gre: 15 = gro, 14 = klein, 0 nicht da
  int points;
  void Dist(const Ship& ship);
  bool IsPresent (void) const;
  void set (const int& ix, const int& iy, const int& size);
};


class Asteroid : public Enemy{
 public:
  double radius;  // 
  int type; // 1 ... 4, uere Form
  int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein
  int points;
  virtual void set(const int& ix, const int& iy, const int& type, const int& sf);
  void Dist(const Ship& ship);
  Asteroid(const Asteroid&);
  Asteroid(void);
};

class GameStatus
{
 public:
  Ship ship;          
  Saucer saucer;
  int nasteroids; // Anzahl raw_asteroiden
  int nexplosions;
  int nObj;  // Anzahl der Asteroiden + Explosionen
  int nEnemy;  // Anzahl der Asteroiden + Explosionen
  int nSmallAsteroids;
  int nBigAsteroids;
  unsigned int lifes; // Anzahl Leben
  Asteroid raw_asteroids[MAX_ASTEROIDS];
  Explosion explosion[MAX_ASTEROIDS+1];
  int nshots;     // Anzahl Schsse
  Shot raw_shots[MAX_SHOTS];
  unsigned int t;         // Anzahl Durchlufe
  unsigned int frameno;   // aktuelle Framezahl; ohne Frameverlust == t
  unsigned int gameFrameNo;
  unsigned int level;
  int ping;
  unsigned char keysPing;
  unsigned char framePing;
  int latenz;
  bool accFrame; // Im nchsten Frame kann beschleunigt werden
  int shotLifeSpan[4];
  int score;
  int pauseLeft;
  void clear(void);
  int IncAsteroids(void);
  //  GameStatus(const GameStatus&);
  GameStatus(void);
  
};

class Game
{
public:
  int score;
  int overflow;
  int lscore;
  unsigned int nSmallSaucers;
  unsigned int nBigSaucers;
  unsigned int nbigasteroids;
  char txt[1025]; // sicher ist sicher
  Game(Connection &con, InterfacePlayer &pl);
  void Run(void);
  void gameover(void);

protected:
  void InterpretScreen(const FramePacket &packet, GameStatus& game);

private:
   Connection &connection;
   InterfacePlayer &player;
};


inline Enemy::Enemy(const Enemy& e){
  dx=e.dx;
  dy=e.dy;
  d =e.d ;
  ix=e.ix;
  iy=e.iy;      // aktuelle (gemessene) Koordinaten
}

inline Enemy::Enemy(void)
	     : dx(0),
	     dy(0),
	     d(0)
{}
inline Asteroid::Asteroid(const Asteroid& a){
  radius=a.radius; 
  type=a.type;     
  sf=a.sf;       
  dx=a.dx;
  dy=a.dy;
  d =a.d;
  ix=a.ix;
  iy=a.iy;      // aktuelle (gemessene) Koordinaten
}
inline Asteroid::Asteroid(void)
		:  radius(0),
		type(0),
		sf(0)
{}
#endif
