// This file is part of "Omniroid", an Asteroids bot written for the 2008 c't anniversary contest
// Omniroid was written by Vladimir "CyberShadow" Panteleev <thecybershadow@gmail.com>
// This file is written in the D Programming Language ( http://digitalmars.com/d/ )

/// A "fake" network client, which uses our own game emulator instead of MAME.
module fakeclient;

import network;
import asteroids;
import vgadebug, textoutput;
import std.random;
import utils;
debug import std.stdio;

const int PACKET_LOSS = 1; // packet loss is (100%) / PACKETLOSS; 1 = off
const int PACKET_LAG = 0; // 0 = off

class FakeClient : NetworkClient
{
	Game game;
	bool packetSent;
	KeysPacket keys;
	KeysPacket[] nextKeys;
	ubyte frameCount;
	FILE* dbgout;
	
	this()
	{
		dbgout = fopen("dbgfake.txt", "wt");
		game.Initialize();
		int i = rand()&0x3FFF;
		i = 1183;
		writefln("FakeClient waiting %d frames", i);
		game.ObjAngle[0] = i%256;
		for (; i; i--) game.Step();
		game.Input_Start = true;
		nextKeys.length = PACKET_LAG;
	}

	~this()
	{
		fclose(dbgout);
	}

	void waitForPacket()
	{
		//std.stdio.writefln("FakeClient:");
		do {
			game.Input_HyperSpace       = keys.data.hyperspace;
			game.Input_Fire             = keys.data.fire;
			game.Input_Thrust           = keys.data.thrust;
			game.Input_CounterClockwise = keys.data.left;
			game.Input_Clockwise        = keys.data.right;
			//writef("<");
			game.Step();
			//writef(">");
			dumpScreenN(game.ActiveVideoPage(), "fake/");
			dumpGameN(game, "fakescreens/");
			if (!game.PlayerPrompt_Timeout)
				fwritef(dbgout, "%s", gameDebugInfo(game, scrollLockStatus())); fflush(dbgout);
			frameCount++;
		} while (rand()%PACKET_LOSS == 1);
		packetSent = false;
		if (nextKeys.length)
		{
			keys = nextKeys[0];
			nextKeys = nextKeys[1..$];
		}
	}

	bool receivePacket(ref FramePacket packet)
	{
		if (packetSent)
			waitForPacket();
		packet.display[] = game.ActiveVideoPage();
		packet.frameno = frameCount;
		packet.ping = keys.data.ping;
		packetSent = true;
		return true;
	}

	void sendPacket(ref KeysPacket packet)
	{
		if (rand()%PACKET_LOSS == 1)
			return;
		nextKeys ~= packet;
	}

	void sendName(string name)
	{
	}
}
