// This file is part of "Omniroid", an Asteroids bot written for the 2008 c't anniversary contest
// Omniroid was written by Vladimir "CyberShadow" Panteleev <thecybershadow@gmail.com>
// This file is written in the D Programming Language ( http://digitalmars.com/d/ )

/// Simple bot that spins on the spot and shoots at stuff as it rotates.
module simplebot;

import asteroids;
import syncbot;
import network;

class SimpleBot : SyncBot
{
	this(NetworkClient network)
	{
		super(network);
	}

	override KeysData getInput()
	{
		KeysData dontFire;
		dontFire.left = true;
		if ((pool[0].FireHistory >> 7) ||         // we fired last frame
			 pool[0].ObjType[OBJECT_SHIP] != 1)   // ship not visible
			return dontFire;

		KeysData fire = dontFire;
		fire.fire = true;

		auto myPool = cast(FastGame[])(pool[0..1].dup); // one game will be enough
		myPool[0].ObjType[OBJECT_SHIP_BULLETS..MAX_OBJECTS] = 0;
		stepUsing(fire, myPool);
		KeysData result = dontFire;
		while (myPool[0].ObjType[OBJECT_LAST_SHIP_BULLET])
		{
			stepUsing(dontFire, myPool); myPool.length = 1;
			if (myPool[0].Lives < pool[0].Lives)
				break;
			if (myPool[0].Score != pool[0].Score)
			{
				result = fire;
				break;
			}
		}
		
		// check if we're gonna die, then hyperspace (safely of course)
		myPool = getFastPool();
		int wereGonnaDieIn = -1;
	futureLoop:
		for (int f=0; f<20; f++) // take into account lag / packet loss
		{
			stepUsing(f==0 ? result : dontFire, myPool);
			foreach (ref game; myPool)
				if (game.Lives < pool[0].Lives)
				{
					wereGonnaDieIn = f;
					break futureLoop;
				}
		}
		KeysData jump = result;
		jump.hyperspace = true;
		if (wereGonnaDieIn >= 0)
		{
			// check if we can enter hyperspace safely
			myPool = getFastPool;
			for (int f=0; f<90-f*2; f++)
			{
				stepUsing(f==0?jump:result, myPool);
				foreach (ref game; myPool)
					if (game.SafeJump == 0x80 || game.Lives != pool[0].Lives) // this choice leads to DEATH!
						return result;
			}
			return jump;
		}
		// just fire (if we can/need to), then
		return result;
	}
}

NetworkClient client;

void main(string[] args)
{
	if (client is null)
		client = new UdpNetworkClient(args.length>1?args[1]:"127.0.0.1");
	auto bot = new SimpleBot(client);
	bot.run();
}
