import std.stdio;
import asteroids;
import vgadebug;
import display;

void main()
{
	Game[256] pool;
	foreach(i,ref game;pool)
	{
		game.Initialize();
		game.ObjAngle[0] = i;
		game.Input_Start = true;
		game.Input_Thrust = true;
	}
	auto parser = new DisplayParser();

	do {
		foreach (ref game;pool)
			game.Step();
		parser.interpret(pool[0].ActiveVideoPage);
	} while (!parser.ship_present || parser.ship_thrust);
	foreach (i, ref game;pool)
	{
		writef("%02X ", i);
		parser.interpret(game.ActiveVideoPage);
		assert(!parser.ship_thrust);
	}
	
	do {
		foreach (ref game;pool)
			game.Step();
		parser.interpret(pool[0].ActiveVideoPage);
	} while (!parser.ship_thrust);
	foreach (i, ref game;pool)
	{
		writef("%02X ", i);
		parser.interpret(game.ActiveVideoPage);
		assert(parser.ship_thrust);
	}
}