// This file is part of "Omniroid", an Asteroids bot written for the 2008 c't anniversary contest
// Omniroid was written by Vladimir "CyberShadow" Panteleev <thecybershadow@gmail.com>
// This file is written in the D Programming Language ( http://digitalmars.com/d/ )

/// Base bot class.
module basebot;

import std.c.time;
import std.stdio;
import std.string, std.conv;
import network;
import display;
import vgadebug;

/// An abstract bot class.
class Bot
{
	NetworkClient network;
	DisplayParser display;
	//FILE* frameSequence;

	this(NetworkClient network)
	{
		this.network = network;
		display = new DisplayParser();
		//frameSequence = fopen("frameSequence.txt", "wt");
	}

	/// The bot initialization and main loop.
	private final void receive(ref FramePacket frame)
	{
		if (!network.receivePacket(frame))
		{
			network.waitForPacket();
			bool result = network.receivePacket(frame);
			assert(result, "Network error?");
		}
		//debug dumpScreenN(frame.display);
		//fprintf(frameSequence, "%02X\n", frame.frameno); fflush(frameSequence);
	}

	final void run()
	{
		writefln("I am %s, built on %s at %s.", name, __DATE__, __TIME__);
		writefln("Connecting...");
	retry:
		network.sendPacket(KeysPacket());
		FramePacket frame;
		int n;
		while (true)
		{
			bool result;
			try
				result = network.receivePacket(frame);
			catch (Exception e)
				if (e.msg.length > 4 && e.msg[0..4] == "busy") // server is busy; wait for it to unbusy itself
				{
					writef("%s   \r", strip(e.msg)); 
					fflush(stdout);
					msleep(toInt(e.msg[5..$-2])/2);
					goto retry;
				}
				else
					throw e;
			if (result)
				break;
			msleep(1);
			if (++n%5==0)
				network.sendPacket(KeysPacket());
		}

		network.sendName(`CyberShadow \\ ` ~ name);
		writefln("Waiting for game to start...");
		do
		{
			receive(frame);
			display.interpret(frame.display);
		} while (!display.ship_present || display.nasteroids==0);

		writefln("Game started");
		do {
			KeysData keys = getInput(frame);
			network.sendKeys(keys);
			receive(frame);
		} while(true);
	}

	string name()
	{
		foreach_reverse (i,c;this.classinfo.name)
			if (c=='.')
				return this.classinfo.name[i+1..$];
		return this.classinfo.name;
	}

	/// Get input to send (should return quickly).
	abstract KeysData getInput(ref FramePacket frame);
}
