// This file is part of "Omniroid", an Asteroids bot written for the 2008 c't anniversary contest
// Omniroid was written by Vladimir "CyberShadow" Panteleev <thecybershadow@gmail.com>
// This file is written in the D Programming Language ( http://digitalmars.com/d/ )

/// Display parsing and comparing.
module display;

alias ushort[512] DisplayData;
	
struct AsteroidSprite
{
	int x;
	int y;
	int type;
	int sf;
}

struct ShotSprite
{
	int x;
	int y;
}

/// Display parser - based on the original C++ demo by Harald Bögeholz
class DisplayParser
{
	const MAX_ASTEROIDS = 27;
	const MAX_SHOTS = 6;

	bool ship_present;
	bool ship_thrust;
	int ship_x;
	int ship_y;
	int ship_dx;
	int ship_dy;
	bool saucer_present;
	int saucer_x;
	int saucer_y;
	int saucer_size;    // Size: 15 = big, 14 = small
	int nasteroids;
	AsteroidSprite asteroids[MAX_ASTEROIDS];
	int nshots;         // Anzahl Schüsse
	ShotSprite shots[MAX_SHOTS];
	
	void interpret(ushort[] vector_ram)
	{
		int dx, dy, sf, vx, vy, vz, vs;
		int v1x = 0;
		int v1y = 0;
		int shipdetect = 0;
		int ship_pc = int.min;

		ship_present = false;
		ship_thrust = false;
		saucer_present = false;
		nasteroids = 0;
		nshots = 0;

		if (vector_ram[0] != 0xe001 && vector_ram[0] != 0xe201 && vector_ram[0] != 0x0000)
			throw new Exception("Bad start of vector RAM"); // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

		int pc = 1;
		while (pc < 512-1)
		{
			int op = vector_ram[pc] >> 12;
			switch (op)
			{
			case 0xa: // LABS
				vy = vector_ram[pc] & 0x3ff;
				vx = vector_ram[pc+1] & 0x3ff;
				vs = vector_ram[pc+1] >> 12;
				ship_pc = int.min;
				break;
			case 0xb: // HALT
				return;
			case 0xc: // JSRL
				switch (vector_ram[pc] & 0xfff)
				{
				case 0x8f3:
					asteroids[nasteroids++] = AsteroidSprite(vx, vy, 0, vs);
					break;
				case 0x8ff:
					asteroids[nasteroids++] = AsteroidSprite(vx, vy, 1, vs);
					break;
				case 0x90d:
					asteroids[nasteroids++] = AsteroidSprite(vx, vy, 2, vs);
					break;
				case 0x91a:
					asteroids[nasteroids++] = AsteroidSprite(vx, vy, 3, vs);
					break;
				case 0x929:
					saucer_present = true;
					saucer_x = vx;
					saucer_y = vy;
					saucer_size = vs;
					break;
				default:
					break;
				}  
				break;
			case 0xd: // RTSL
				return;
			case 0xe: // JMPL
				/*
				pc = vector_ram[pc] & 0xfff;
				break;
				*/
				return;
			case 0xf: // SVEC
				/*
				dy = vector_ram[pc] & 0x300;
				if ((vector_ram[pc] & 0x400) != 0)
					dy = -dy;
				dx = (vector_ram[pc] & 3) << 8;
				if ((vector_ram[pc] & 4) != 0)
					dx = -dx;
				sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
				vz = (vector_ram[pc] & 0xf0) >> 4;
				*/
				if (pc == ship_pc + 3)
					ship_thrust = true;
				break;
			default:
				dy = vector_ram[pc] & 0x3ff;
				if ((vector_ram[pc] & 0x400) != 0)
					dy = -dy;
				dx = vector_ram[pc+1] & 0x3ff;
				if ((vector_ram[pc+1] & 0x400) != 0)
					dx = -dx;
				sf = op;
				vz = vector_ram[pc+1] >> 12;
				if (dx == 0 && dy == 0 && vz == 15)
					shots[nshots++] = ShotSprite(vx, vy);
				if (op == 6 && vz == 12 && dx != 0 && dy != 0)
				{
					switch (shipdetect)
					{
					case 0:
						v1x = dx;
						v1y = dy;
						break;
					case 1:
						ship_present = true;
						ship_x = vx;
						ship_y = vy;
						ship_dx = v1x - dx;
						ship_dy = v1y - dy;
						ship_pc = pc;
						break;
					}
					shipdetect++;
				}
				else if (shipdetect == 1)
					shipdetect = 0;
				if (vz == 12 && pc == ship_pc + 6)
					ship_thrust = true;
				break;
			}
			if (op <= 0xa)
				++pc;
			if (op != 0xe) // JMPL
				++pc;
		}   
	}
}

/// If the parameter contains full display data, only return the section containing the active part.
ushort[] shorten(ushort[] a)
{
	if (a.length==0x200)
		return a;
	assert(a.length==0x400);
	assert(a[0]==0xE001 || a[0]==0xE201);
	if (a[0]==0xE001)
		return a[0..0x200];
	else
		return a[0x200..0x400];
}

//debug import vgadebug;

/// Compare two displays
bool displaysMatch(ushort[] a, ushort[] b)
{
	a = shorten(a);
	b = shorten(b);
	//dumpScreen("a.txt", a);
	//dumpScreen("b.txt", b);
	//assert(0);
	ushort pca = 1, pcb = 1;
	while (pca < 0x200 && pcb < 0x200)
	{
		ubyte opa = a[pca] >> 12;
		ubyte opb = b[pcb] >> 12;
		// ...
		if (a[pca] != 0xEEEE && b[pcb] != 0xEEEE) // not a wildcard
		{
			if (a[pca] != b[pcb])
				return false;
			if (opa == 0xB)
				return true;
		}
		pca++;
		pcb++;
	}
	throw new Exception("HALT not encountered when comparing displays");
}
