#using <System.Windows.Forms.dll>
#using <System.Drawing.dll>
#using <System.dll>

#include <cmath>
// sampleclient
#include <cstdio>
#include <cstdlib>
#include <cerrno>
#include <cstring>

#include <winsock2.h>
#include "player2.h"
#include "radarbild.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Drawing;
using namespace System::Windows::Forms;
using namespace System::Threading;

namespace Radarbild 
{
   public ref class Radarbild: public Form
   {
   private:
      BufferedGraphicsContext^ context;
      BufferedGraphics^ grafx;
	  System::Windows::Forms::Timer^ timer1;
      System::Windows::Forms::Timer^ timer2;
	  long FrameZaehler;
	  long LetzterFrameZaehler;
	  int FramesProSekunde;
	  int SchiffPositionX;
	  int SchiffPositionY;
	  int SchiffRichtungX;
	  int SchiffRichtungY;
	  Thread^ BerechnungsThread;
	  Thread^ BerechnungsThread2;
	  Player2^ Spieler;

   public:
      Radarbild(unsigned long server_ip, SOCKET sd) : Form()
      {
		 // Die Koordinatenberechnung der Objekte in einem neuen Thread starten
		 Spieler = gcnew Player2(sd, server_ip); // OK, hier geht es los ...
		 BerechnungsThread = gcnew Thread( gcnew ThreadStart( Spieler, &Player2::Spiel3 ));	 
		 BerechnungsThread->Start();

		 // Fenster konfigurieren
		 this->Size = System::Drawing::Size(1033, 796);
		 this->Text = "AsteroidsAutopilot mit Radar - M. Niemeyer fr c't:creativ'08";
         this->MouseDown += gcnew MouseEventHandler( this, &Radarbild::MouseDownHandler );
         this->Resize += gcnew EventHandler( this, &Radarbild::OnResize );
		 
         // Ein Timer fr Grafikupdates.
         timer1 = gcnew System::Windows::Forms::Timer;
         timer1->Interval = 31; // ergibt ungefhr 32 FPS
         timer1->Tick += gcnew EventHandler( this, &Radarbild::OnTimer );
		 timer1->Start(); // direkt starten

		 // Ein zweiter Timer zum bestimmen der FPS unseres Radarbildes
         timer2 = gcnew System::Windows::Forms::Timer;
         timer2->Interval = 1000;
		 timer2->Tick += gcnew EventHandler( this, &Radarbild::OnTimer2 );
		 timer2->Start();

		 // allgemeine initialisierung
		 FrameZaehler = 0;

		 // Anlegen des Grafikpuffers
         context = BufferedGraphicsManager::Current;
         context->MaximumBuffer = System::Drawing::Size( this->Width + 1, this->Height + 1 );
		 grafx = context->Allocate( this->CreateGraphics(), System::Drawing::Rectangle(0,0,this->Width,this->Height) );

		 // das 1. Frame in den Puffer zeichnen
         RadarbildZeichnen( grafx->Graphics );
      }

	  ~Radarbild()
	  {
		  BerechnungsThread->Abort();
	  }

	  void SetzeSchiffsPosition( int PositionX, int PositionY, int SchiffRichtungX, int SchiffRichtungY ) {
		  this->SchiffPositionX = PositionX;
		  this->SchiffPositionY = 767 - PositionY; // Y-Achse invertieren damit Richtung im Radar korrekt
		  this->SchiffRichtungX = SchiffRichtungX;
		  this->SchiffRichtungY = 767 - SchiffRichtungY; // Y-Achse invertieren damit Richtung im Radar korrekt
	  }

   private:
      void MouseDownHandler( Object^ /*sender*/, MouseEventArgs^ e )
      {
         // Bei Rechtsklick wiedergabe anhalten bzw. das aktuelle Radar zeichnen
		 if ( e->Button == ::MouseButtons::Right )
         {
			if ( timer1->Enabled ) {
				timer1->Stop();
				timer2->Stop();
			} else {
				// ein einzelnes Frame zeichnen
				RadarbildZeichnen( grafx->Graphics );
				grafx->Render( Graphics::FromHwnd( this->Handle ) );
			}
         }

		 // Bei doppelrechtsklick starten
		 if ( e->Button == ::MouseButtons::Left )
         {
            // Timer zum Zeichnen benutzen
			 if ( !timer1->Enabled ) {
				timer1->Start();
				timer2->Start();
			}
         }
      }

   private:
      void OnTimer( Object^ /*sender*/, EventArgs^ /*e*/ )
      {
		  // Grafik in Buffer schreiben und ausgeben
		  RadarbildZeichnen( grafx->Graphics );
		  grafx->Render( Graphics::FromHwnd( this->Handle ) );
      }

	  void OnTimer2( Object^ /*sender*/, EventArgs^ /*e*/ )
      {
		  FramesProSekunde = FrameZaehler - LetzterFrameZaehler;
		  LetzterFrameZaehler = FrameZaehler;
		  //Console::WriteLine("test");
	  }

      void OnResize( Object^ /*sender*/, EventArgs^ /*e*/ )
      {
         // Grafikpuffer an genderte Fenstergren anpassen
         context->MaximumBuffer = System::Drawing::Size( this->Width + 1, this->Height + 1 );
         if ( grafx != nullptr )
         {
            delete grafx;
            grafx = nullptr;
         }
         grafx = context->Allocate( this->CreateGraphics(), System::Drawing::Rectangle(0,0,this->Width,this->Height) );
         RadarbildZeichnen( grafx->Graphics );
      }

	  // Die Ecken des Schiffs fr die Zeichnung Berechnen
	  array<Point>^ BerechneSchiffsecken( int SchiffPositionX, int SchiffPositionY, int SchiffRichtungX, int SchiffRichtungY )
	  {
		  // Aufpassen auf undefinierte Zustnde, diese knnen Auftreten, wenn Position und Richtung gleiche 
		  // Werte haben. Dann Verschieben wir die Richtung einfach ein Pixel.
		  if ( ( SchiffRichtungX - SchiffPositionX ) == 0 ) SchiffRichtungX = SchiffRichtungX+1;
		  if ( ( SchiffRichtungY - SchiffPositionY ) == 0 ) SchiffRichtungY = SchiffRichtungY+1;

		  double SpitzeAbstandVonMitte = 10;
		  // 1. Sin a
		  double sinA;
		  if ( ( SchiffRichtungX - SchiffPositionX ) == 0 ) { sinA = 1; }
		  else { sinA = ( SchiffRichtungY - SchiffPositionY ) / sqrt( pow( double(SchiffRichtungY - SchiffPositionY), 2 ) + pow( double(SchiffRichtungX - SchiffPositionX), 2) ); }
		  // 2. SpitzeY des Schiffs berechnen
		  double AbstandVonMitteY = sinA * SpitzeAbstandVonMitte;
		  double SpitzeY = SchiffPositionY + AbstandVonMitteY;
		  // 3. Cos a
		  double cosA;
		  if ( ( SchiffRichtungY - SchiffPositionY ) == 0 ) { cosA = 1; }
		  else { cosA = ( SchiffRichtungX - SchiffPositionX ) / sqrt( pow( double(SchiffRichtungY - SchiffPositionY), 2 ) + pow( double(SchiffRichtungX - SchiffPositionX), 2) ); }
		  // 4. SpitzeX des Schiffs berechnen
		  double AbstandVonMitteX = cosA * SpitzeAbstandVonMitte;
		  double SpitzeX = SchiffPositionX + AbstandVonMitteX;

		  // Mittelpunkt im Heck
		  if ( ( SchiffPositionX - SpitzeX ) == 0 ) { sinA = 1; }
		  else { sinA = ( SchiffPositionY - SpitzeY ) / sqrt( pow( double(SchiffPositionY - SpitzeY), 2 ) + pow( double(SchiffPositionX - SpitzeX), 2) ); }
		  // 2. SpitzeY des Schiffs berechnen
		  AbstandVonMitteY = sinA * ( SpitzeAbstandVonMitte * 2 );
		  double HeckY = SpitzeY + AbstandVonMitteY;
		  // 3. Cos a
		  if ( ( SchiffPositionY - SpitzeY ) == 0 ) { cosA = 1; }
		  else { cosA = ( SchiffPositionX - SpitzeX ) / sqrt( pow( double(SchiffPositionY - SpitzeY), 2 ) + pow( double(SchiffPositionX - SpitzeX), 2) ); }
		  // 4. SpitzeX des Schiffs berechnen
		  AbstandVonMitteX = cosA * (SpitzeAbstandVonMitte * 2);
		  double HeckX = SpitzeX + AbstandVonMitteX;

		  // Flgelspitzen Backbord und Steuerboard
		  // 1. Gerade aus Spitze(X|Y) und Heck(X|Y) berechnen
		  // y = dy/dx * x + b
		  double SteigungMittelachse = ( (SpitzeY - HeckY) / (SpitzeX - HeckX) );
		  double b = HeckY - ( SteigungMittelachse * HeckX );
		  //y = m * x + b
		  // 2. Gerade durch Heck und Back-/Steuerbord berechnen (Orthogonale zu 1.)
		  double SteigungOrthogonale = - ( 1 / SteigungMittelachse ); //m_o * x + c
		  double b_orth = HeckY - SteigungOrthogonale * HeckX;

		  // 3. Heck(X|Y) ist Mittelpunkt eines Kreises R = 5
		  // Eine Gerade mit der SteigungOrthogonale geht durch den Kreis
		  // beschreiben wir die Diagonale mit einem 2. Punkt: f(x) = SteigungOrthogonale * (HeckX+0,01) + b_orth
		  double OrthHilfspunktY = SteigungOrthogonale * ( HeckX + 0,01 ) + b_orth;
		  double OrthHilfspunktX = ( OrthHilfspunktY - b_orth ) / SteigungOrthogonale;
		  // 4. Berechnung der Schnittpunkte Kreis/Orthogonale
		  double Radius = 5;
		  double t = sqrt( pow(Radius, 2) / ( pow(HeckX - OrthHilfspunktX, 2) + pow(HeckY - OrthHilfspunktY, 2) ) );
		  double BackbordX = HeckX + t * (HeckX - OrthHilfspunktX);
		  double BackbordY = HeckY + t * (HeckY - OrthHilfspunktY);
		  double SteuerbordX = HeckX - t * (HeckX - OrthHilfspunktX);
		  double SteuerbordY = HeckY - t * (HeckY - OrthHilfspunktY);

		  Point Ecke1Schiff = Point(int(BackbordX), int(BackbordY));
		  Point Ecke2Schiff = Point(int(SpitzeX), int(SpitzeY));
		  Point Ecke3Schiff = Point(int(SteuerbordX), int(SteuerbordY));
		  array<Point>^ SchiffDreieck = {Ecke1Schiff,Ecke2Schiff,Ecke3Schiff};

		  // Debug: Warum gibt es manchmal merkwrdige Werte im Schiffsdreieck?
		  if ( SchiffDreieck[0].X <= -2000 ) 
		  {
			  fprintf(stderr, "DEBUG: SchiffDreieck[0].X: %d\n", SchiffDreieck[0].X);
			  fprintf(stderr, "DEBUG: BackbordX: %f\n", BackbordX);
			  fprintf(stderr, "DEBUG: BackbordY: %f\n", BackbordY);
			  fprintf(stderr, "DEBUG: SpitzeX: %f\n", SpitzeX);
			  fprintf(stderr, "DEBUG: SpitzeY: %f\n", SpitzeY);
			  fprintf(stderr, "DEBUG: SteuerbordX: %f\n", SteuerbordX);
			  fprintf(stderr, "DEBUG: SteuerbordY: %f\n", SteuerbordY);
		  }
		  
		  return SchiffDreieck;
	  }

      void RadarbildZeichnen( Graphics^ g )
      {
		 // Die neue Position ermitteln
		 //SetzeSchiffsPosition(KoordBesorgen->SchiffPositionX,KoordBesorgen->SchiffPositionY);
		 SetzeSchiffsPosition(Spieler->SchiffPositionX,Spieler->SchiffPositionY,Spieler->SchiffRichtungX,Spieler->SchiffRichtungY);

		 // Hintergrund
         grafx->Graphics->FillRectangle( Brushes::Black, 0, 0, this->Width, this->Height );

		 // die verschiedenen Stifte bereitlegen
		 Pen^ gruenerStift = gcnew Pen(Color::Green); // grn
		 gruenerStift->Width = 1;
		 Pen^ roterStift = gcnew Pen(Color::Red); // rot
		 roterStift->Width = 1;
		 Pen^ blauerStift = gcnew Pen(Color::Blue); // blau
		 blauerStift->Width = 1;
		 Pen^ gelberStift = gcnew Pen(Color::Yellow); // gelb
		 gelberStift->Width = 1;

		 // Die Grenzen des Spielfeldes einzeichnen		
		 g->DrawRectangle( roterStift, 0, 0, 1024, 768 );

		 Point Ecke1Schiff = Point(SchiffPositionX-5,SchiffPositionY+10);
		 Point Ecke2Schiff = Point(SchiffPositionX,SchiffPositionY-10);
		 Point Ecke3Schiff = Point(SchiffPositionX+5,SchiffPositionY+10);
		 array<Point>^ SchiffDreieck = {Ecke1Schiff,Ecke2Schiff,Ecke3Schiff};
		 SchiffDreieck = BerechneSchiffsecken( SchiffPositionX, SchiffPositionY, SchiffRichtungX, SchiffRichtungY );

		 // UFO - Punkte definieren + irgendwie initalisieren
		 array<Point>^ UfoPolygon = {Ecke1Schiff,Ecke2Schiff,Ecke3Schiff,Ecke2Schiff,Ecke3Schiff,Ecke2Schiff,Ecke3Schiff,Ecke2Schiff};
		 int UfoGroesse = 1;
		 // Asteroidenparameter
		 int AsteroidGroesse = 0;
		 // Zeichnen der RadarObjekte
		 for (int i = 0; Spieler->ObjektRadarElement > i; i++)
		 {	 
			 switch (Spieler->ObjektRadarSkalierung[i])
			 {
			 case 0: AsteroidGroesse = 75; break;
			 case 15: AsteroidGroesse = 37; break;
			 case 14: AsteroidGroesse = 19; break;
			 default: AsteroidGroesse = 1; break;
			 }
			 // ObjektRadar, ObjektRadarX, ObjektRadarY, ObjektRadarTyp, ObjektRadarSkalierung, ObjektRadarElement
			 switch ( Spieler->ObjektRadar[i] ) 
			 {
			 case 0:
				 // Raumschiff zeichnen
				 SchiffDreieck = BerechneSchiffsecken( Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], SchiffRichtungX, SchiffRichtungY );
				 g->DrawPolygon( gruenerStift, SchiffDreieck );
				 // dx des Raumschiffs
				 g->DrawLine( blauerStift,SchiffPositionX, SchiffPositionY, SchiffRichtungX, SchiffRichtungY );
				 g->DrawEllipse( gelberStift, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], 1, 1);
				 //fprintf(stderr, "DEBUG: ObjektRadarSkalierung: %d\n", Spieler->ObjektRadarSkalierung);
				 break;
			 case 1: // alles asteroiden
			 case 2: // alles asteroiden
			 case 3: // alles asteroiden
			 case 4: // alles asteroiden
				 g->DrawString( String::Format( "{0}", Spieler->ObjektRadarTyp[i] ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Crimson, Spieler->ObjektRadarX[i]-4, Spieler->ObjektRadarY[i]-6 );
				 g->DrawEllipse(gelberStift, Spieler->ObjektRadarX[i]-((AsteroidGroesse-1)/2), Spieler->ObjektRadarY[i]-((AsteroidGroesse-1)/2), AsteroidGroesse, AsteroidGroesse);
				 g->DrawEllipse( blauerStift, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], 1, 1);
				 break;
			 case 5: // UFO
				 UfoGroesse = -13 + Spieler->ObjektRadarSkalierung[i]; // UFO-Grssen = 14 oder 15
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]-2 * UfoGroesse), int(Spieler->ObjektRadarY[i]-6 * UfoGroesse)), 0);
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]+2 * UfoGroesse), int(Spieler->ObjektRadarY[i]-6 * UfoGroesse)), 1);
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]+4 * UfoGroesse), int(Spieler->ObjektRadarY[i]-3 * UfoGroesse)), 2);
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]+9 * UfoGroesse), int(Spieler->ObjektRadarY[i]-1 * UfoGroesse)), 3);
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]+3 * UfoGroesse), int(Spieler->ObjektRadarY[i]+4 * UfoGroesse)), 4);
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]-3 * UfoGroesse), int(Spieler->ObjektRadarY[i]+4 * UfoGroesse)), 5);
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]-9 * UfoGroesse), int(Spieler->ObjektRadarY[i]-1 * UfoGroesse)), 6);
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]-4 * UfoGroesse), int(Spieler->ObjektRadarY[i]-3 * UfoGroesse)), 7);
				 g->DrawPolygon(roterStift, UfoPolygon);
				 g->DrawEllipse( blauerStift, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], 1, 1);
				 break;
			 case 6: // Schuss
				 g->DrawEllipse( roterStift, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], 1, 1);
				 break;
			 default:
				 g->DrawString( String::Format( "?" ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Crimson, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i] );
				 break;
			 }
		 }

         // Infos einblenden
		 g->DrawString( "Rechtsklick: Standbild(er)", gcnew System::Drawing::Font( "Arial",8 ), Brushes::White, 10, 10 );
		 g->DrawString( "Linksklick: Radarbild", gcnew System::Drawing::Font( "Arial",8 ), Brushes::White, 10, 22 );
		 g->DrawString( String::Format( "Schiffsposition: {0}x{1}", SchiffPositionX, SchiffPositionY ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 850, 10 );
		 g->DrawString( String::Format( "aktueller Frame: {0}", FrameZaehler++ ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 850, 22 );
		 g->DrawString( String::Format( "Frames pro Sek.: {0}", FramesProSekunde ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 850, 34 );
      }

   protected:
      virtual void OnPaint( PaintEventArgs^ e ) override
      {
         grafx->Render( e->Graphics );
      }
   };
}
