#ifndef INTERVAL_H
#define INTERVAL_H

#include <iostream>
#include <algorithm>
#include <cassert>

template< class T >
struct Interval
{
    inline Interval() : start(0), n(0)
    {}
    inline Interval(T t0) : start(t0), n(1)
    {}
    inline Interval(T t0, T t1) : start(t0), n(t1-t0+1)
    {}
    inline bool empty() const
    {
        return n==0;
    }
    inline T end() const
    { return start+n; }
    inline bool overlaps(const Interval& i) const
    {
        return contains(i.start) || contains(i.start+i.n);
    }
    inline bool contains(T t) const
// { return t >= start && t <= end; }
    {
//        return end >= start
//                ? t >= start && t <= end
//                : !(t>end && t < start);

        T x(t - start);
        T y(n);
        return x < y;
    }
//    inline bool contains(const Interval& i) const
// { return i.start >= start && i.end <= end; }
    Interval& operator&=(const Interval& i);
    Interval& operator|=(const Interval& i);
    inline Interval& operator+=(T t)
    {
        start += t; return *this;
    }
    inline Interval& operator-=(T t)
    {
        start -= t; return *this;
    }
    T start;
    unsigned int n;
};

template< class T >
inline Interval<T> operator&(const Interval<T>& i1, const Interval<T>& i2)
{
//    return i1.overlaps(i2)
//  ? Interval<T>(std::max(i1.start, i2.start), std::min(i1.end, i2.end))
//  : Interval<T>();
    return (i1.contains(i2.start))
           ? (i2.contains(i1.start+i1.n-1))
             ? Interval<T>(i2.start, i1.start+i1.n-1)
             : i2
           : i1.contains(i2.start + i2.n-1)
             ? Interval<T>(i1.start, i2.start+i2.n-1)
             : i2.contains(i1.start)
               ? i1
               : Interval<T>();
}

//template< class T >
//inline Interval<T> operator|(const Interval<T>& i1, const Interval<T>& i2)
//{
//    if (i1.empty())
//        return i2;
//    if (i2.empty())
//        return i1;
//    assert (i1.overlaps(i2));
//    return Interval<T>(std::min(i1.start, i2.start), std::max(i1.end, i2.end));
//}

template< class T >
inline bool operator==(const Interval<T>& i1, const Interval<T>& i2)
{
    return (i1.n==i2.n)&&((i1.start==i2.start)||!i1.n);
}

template< class T >
inline bool operator!=(const Interval<T>& i1, const Interval<T>& i2)
{
    return (i1.n!=i2.n)||((i1.start!=i2.start)&&i1.start);
}

template< class T >
inline Interval<T>& Interval<T>::operator&=(const Interval<T>& i)
{
    return *this = *this & i;
}

//template< class T >
//inline Interval<T>& Interval<T>::operator|=(const Interval<T>& i)
//{ return *this = *this | i; }

template< class T >
inline std::ostream& operator<<(std::ostream& os, const Interval<T>& i)
{
    os << '[' << (int)(i.start) << ',' << (int)(i.start + i.n-1) << ']';
    return os;
}

#endif // !defined INTERVAL_H
