#include "QUnit.hpp"
#include <iostream>
#include "Interval.h"

class IntervalTest
{
    typedef Interval<uint8_t> I;
    static const I empty;

    QUnit::UnitTest qunit;

    void test_contains()
    {
        QUNIT_IS_FALSE( I(2,4).contains(1) );
        QUNIT_IS_TRUE(  I(2,4).contains(2) );
        QUNIT_IS_TRUE(  I(2,4).contains(3) );
        QUNIT_IS_TRUE(  I(2,4).contains(4) );
        QUNIT_IS_FALSE( I(2,4).contains(5) );

        QUNIT_IS_FALSE( I(253,3).contains(252) );
        QUNIT_IS_TRUE(  I(253,3).contains(253) );
        QUNIT_IS_TRUE(  I(253,3).contains(0) );
        QUNIT_IS_TRUE(  I(253,3).contains(3) );
        QUNIT_IS_FALSE( I(253,3).contains(4) );
    }

    void test_intersection1()
    {
        QUNIT_IS_EQUAL( (I(1,3) & I(2,5)), I(2,3) );
        QUNIT_IS_EQUAL( (I(1,3) & I(4,5)), empty );
        
        I a(18);
        I b(16, 19);
        I c=a;
        c &= b;
        QUNIT_IS_EQUAL( a, c );
        
        c=b;
        c &= a; 
        QUNIT_IS_EQUAL( a, c );
    }

public:

    IntervalTest(std::ostream & out, int verbose_level)
            : qunit(out, verbose_level)
    {}

    int run()
    {
        test_contains();
        test_intersection1();
        return qunit.errors();
    }
};

const IntervalTest::I IntervalTest::empty;

int main(int argc, char** argv)
{
    return IntervalTest(std::cerr, QUnit::verbose).run();
}
