#include "QUnit.hpp"
#include <iostream>
#include <vector>
#include <list>
#include "tracking.h"
#include "number1.h"
#include "captain.h" // for Event

using std::list;
using std::vector;

class TrackingTest
{

    QUnit::UnitTest qunit;
    TrackedGameState model;

    void test_absdist()
    {
        vector<Event> events;

        observation::Observation obs1;
        obs1.shots.push_back(observation::Shot(ScnCoords(111, 222)));
        obs1.shots.push_back(observation::Shot(ScnCoords(222, 333)));
        obs1.shots.push_back(observation::Shot(ScnCoords(333, 444)));
        obs1.shots.push_back(observation::Shot(ScnCoords(444, 555)));
        obs1.asteroids.push_back(observation::Asteroid(ScnCoords(900, 200), 0, 1));
        obs1.asteroids.push_back(observation::Asteroid(ScnCoords(900, 800), 0, 2));
        obs1.asteroids.push_back(observation::Asteroid(ScnCoords(100, 800), 0, 3));
        obs1.asteroids.push_back(observation::Asteroid(ScnCoords(100, 200), 0, 4));

        model.update(obs1, events);
       
        {
        TrackedGameState::asteroids_t::const_iterator a = model.asteroids.begin();
        QUNIT_IS_TRUE(a != model.asteroids.end());
        QUNIT_IS_EQUAL(1, (int)(a->type));
        QUNIT_IS_EQUAL(WorldCoords(7204,580), a->p);
        QUNIT_IS_TRUE(++a != model.asteroids.end());
        QUNIT_IS_EQUAL(2, (int)(a->type));
        QUNIT_IS_EQUAL(WorldCoords(7204,5380), a->p);
        }
        {
        TrackedGameState::shots_t::const_iterator ss = model.sshots.begin();
        QUNIT_IS_TRUE(ss != model.sshots.end());
        QUNIT_IS_EQUAL(WorldCoords(892,756), ss->p);
        QUNIT_IS_TRUE(++ss != model.sshots.end());
        QUNIT_IS_EQUAL(WorldCoords(1780,1644), ss->p);
        QUNIT_IS_TRUE(++ss == model.sshots.end());
        }
        {
        TrackedGameState::shots_t::const_iterator us = model.ushots.begin();
        QUNIT_IS_TRUE(us != model.ushots.end());
        QUNIT_IS_EQUAL(WorldCoords(2668,2532), us->p);
        QUNIT_IS_TRUE(++us != model.ushots.end());
        QUNIT_IS_EQUAL(WorldCoords(3556,3420), us->p);
        QUNIT_IS_TRUE(++us == model.ushots.end());
        }
        model.advance();
        events.clear();
        model.update(obs1, events);
        
        {
        TrackedGameState::asteroids_t::const_iterator a = model.asteroids.begin();
        QUNIT_IS_TRUE(a != model.asteroids.end());
        QUNIT_IS_EQUAL(1, (int)(a->type));
        QUNIT_IS_EQUAL(WorldCoords(7204,580), a->p);
        QUNIT_IS_TRUE(++a != model.asteroids.end());
        QUNIT_IS_EQUAL(2, (int)(a->type));
        QUNIT_IS_EQUAL(WorldCoords(7204,5380), a->p);
        }
        {
        TrackedGameState::shots_t::const_iterator ss = model.sshots.begin();
        QUNIT_IS_TRUE(ss != model.sshots.end());
        QUNIT_IS_EQUAL(WorldCoords(892,756), ss->p);
        QUNIT_IS_TRUE(++ss != model.sshots.end());
        QUNIT_IS_EQUAL(WorldCoords(1780,1644), ss->p);
        QUNIT_IS_TRUE(++ss == model.sshots.end());
        }
        {
        TrackedGameState::shots_t::const_iterator us = model.ushots.begin();
        QUNIT_IS_TRUE(us != model.ushots.end());
        QUNIT_IS_EQUAL(WorldCoords(2668,2532), us->p);
        QUNIT_IS_TRUE(++us != model.ushots.end());
        QUNIT_IS_EQUAL(WorldCoords(3556,3420), us->p);
        QUNIT_IS_TRUE(++us == model.ushots.end());
        }

        model.advance();
        obs1.shots.erase(obs1.shots.begin());
        obs1.shots.erase(obs1.shots.begin()+2);
        events.clear();
        model.update(obs1, events);

        {
        TrackedGameState::asteroids_t::const_iterator a = model.asteroids.begin();
        QUNIT_IS_TRUE(a != model.asteroids.end());
        QUNIT_IS_EQUAL(1, (int)(a->type));
        QUNIT_IS_EQUAL(WorldCoords(7204,580), a->p);
        QUNIT_IS_TRUE(++a != model.asteroids.end());
        QUNIT_IS_EQUAL(2, (int)(a->type));
        QUNIT_IS_EQUAL(WorldCoords(7204,5380), a->p);
        }
        {
        TrackedGameState::shots_t::const_iterator ss = model.sshots.begin();
        QUNIT_IS_TRUE(ss != model.sshots.end());
        QUNIT_IS_EQUAL(WorldCoords(1780,1644), ss->p);
        QUNIT_IS_TRUE(++ss == model.sshots.end());
        }
        {
        TrackedGameState::shots_t::const_iterator us = model.ushots.begin();
        QUNIT_IS_TRUE(us != model.ushots.end());
        QUNIT_IS_EQUAL(WorldCoords(2668,2532), us->p);
        QUNIT_IS_TRUE(++us == model.ushots.end());
//        QUNIT_IS_EQUAL(WorldCoords(3556,3420), us->p);
//        QUNIT_IS_TRUE(++us == model.ushots.end());
        }

    }

    void test_moveTo_vector()
    {
        vector<int> v;
        
        v.push_back(0);
        v.push_back(1);
        v.push_back(3);
        v.push_back(4);
        v.push_back(2);
        
        vector<int>::iterator i=v.begin()+4;
        QUNIT_IS_EQUAL(2, *i);
        i = moveTo(v, i, 2);
        QUNIT_IS_EQUAL(2, *i);

        QUNIT_IS_EQUAL(0, v[0]);
        QUNIT_IS_EQUAL(1, v[1]);
        QUNIT_IS_EQUAL(2, v[2]);
        QUNIT_IS_EQUAL(3, v[3]);
        QUNIT_IS_EQUAL(4, v[4]);
    }

        void test_moveTo_list()
    {
        list<int> v;
        
        v.push_back(0);
        v.push_back(1);
        v.push_back(3);
        v.push_back(4);
        v.push_back(2);
        
        list<int>::iterator i=v.begin();
        ++i; ++i; ++i; ++i;
        QUNIT_IS_EQUAL(2, *i);
        i = moveTo(v, i, 2);
        QUNIT_IS_EQUAL(2, *i);

        i=v.begin();
        QUNIT_IS_EQUAL(0, *i++);
        QUNIT_IS_EQUAL(1, *i++);
        QUNIT_IS_EQUAL(2, *i++);
        QUNIT_IS_EQUAL(3, *i++);
        QUNIT_IS_EQUAL(4, *i++);
    }

public:

    TrackingTest(std::ostream & out, int verbose_level)
            : qunit(out, verbose_level), model()
    {
    }

    int run()
    {
        test_moveTo_vector();
        test_moveTo_list();
        test_absdist();
        return qunit.errors();
    }
};


int main(int argc, char** argv)
{
    return TrackingTest(std::cerr, QUnit::normal).run();
}
