#include "captain.h"
using concurrent::MutexLock;



void Captain::setListener(CommandQueue& _commandQueue)
{
    commandQueue = &_commandQueue;
}

EventQueue& Captain::getEventQueue()
{
    return eventQueue;
}

void EventQueue::clear()
{
    MutexLock lock(mutex);
    m_queue.clear();
}

bool EventQueue::pop(Report& report)
{
    MutexLock lock(mutex);
    if (m_queue.empty())
        return false;
    report = m_queue.front();
    m_queue.pop_front();
    return true;
}

void EventQueue::push(Report& report)
{
    MutexLock lock(mutex);
    m_queue.push_back(report);
}

bool Captain::pollEvents()
{
    bool found_some = false;
    while (true) {
        Report report;
        if(!eventQueue.pop(report))
            break;
        found_some = true;
        // handle event
    }
    return found_some;
}

void* Captain::run()
{
    while(true) {
        if (pollEvents()) // and invalidate strategies
        {
#if 0
            if current strategy invalidated
            {
                reconstruct current strategy
                if evasive maneuver needed
                    {
                    } else
                    {
                        // use heuristics to find low hanging fruit
                    }
            helm.commandQueue.pushReplace();
        }
#endif
    } else {
#if 0
        // develop most promising strategy one step
        if other strat better than current
            helm.commandQueue.pushReplace();

#endif
        }
    } // end while
}

#if 0
uint8_t tacticalAction()
{
    keys.clear();   // alle Tasten loslassen
    int min_dist = 0x7fffffff;
    int min_dx = 0;
    int min_dy = 0;
    if (game.ship.present) {
        for (size_t i=0; i<game.asteroids.size(); ++i) {   // naechstgelegenen Asteroiden suchen
            int dx = game.asteroids[i].x - game.ship.x;
            while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
            while (dx > 511) dx -= 1024;
            int dy = game.asteroids[i].y - game.ship.y;
            while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
            while (dy > 383) dy -= 768;
            int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
            switch (game.asteroids[i].sf) { // Abstand um den ungefaehren Radius des Asteroiden korrigieren
                case 0:  // gro�er Asteroid
                    dist -= 40*40;
                    break;
                case 15: // mittlerer Asteroid
                    dist -= 20*20;
                    break;
                case 14: // kleiner Asteroid
                    dist -= 8*8;
                    break;
            }
            if (dist < min_dist) {
                min_dist = dist;
                min_dx = dx;
                min_dy = dy;
            }
        }
        if (game.ufo.present) {
            int dx = game.ufo.x - game.ship.x;
            while (dx < -512) dx += 1024;
            while (dx > 511) dx -= 1024;
            int dy = game.ufo.y - game.ship.y;
            while (dy < -384) dy += 768;
            while (dy > 383) dy -= 768;
            int dist = dx*dx+dy*dy;
            switch (game.ufo.size) { // Abstand um den ungefaehren Radius des UFOs korrigieren
                case 15: // grosses UFO
                    dist -= 20*12;
                    break;
                case 14: // kleines UFO
                    dist -= 10*6;
                    break;
            }
            if (dist < min_dist) {
                min_dist = dist;
                min_dx = dx;
                min_dy = dy;
            }
        }

        // Schiff in Richtung auf das naechstgelegene Objekt drehen
        // mathematisch wird hier das Kreuzprodukt aus den Vektoren
        // ship_dx/y/0 und min_dx/y/0 berechnet
        if (game.ship.dx * min_dy - game.ship.dy * min_dx > 0)
            keys.left(true);
        else
            keys.right(true);

        if (min_dist < 27*27)  // Flucht, wenn Kollision unausweichlich
            keys.hyperspace(true);

        if (min_dist > 400*400) // beschleunigen, wenn nichts in der Naehe
            keys.thrust(true);

        if (t % 2 == 0)  // Feuerknopf druecken, so schnell es geht
            keys.fire(true);
    }
}
#endif

void Captain::shutdown() volatile
{
    assert(false);
}
