#ifndef CAPTAIN_H
#define CAPTAIN_H

#include "number1.h"
//#include "concurrent.h"

#include <ext/hash_map>
namespace std {
using __gnu_cxx::hash_multimap;
}


class Node
{
public:
    Node* parent;
    std::hash_multimap<uint16_t, Node*>::iterator me_in_targeted;
    Maneuver move;
    GameState outcome;
    int32_t ufo_bonus;
    std::multimap<uint32_t, Node*>::iterator me_in_open;
    std::vector<Node*> children;
};


/**
 *
inform captain of
 model,
 events,
 actions
 and strategy persued
*/
class Report
{
public:
    uint32_t time;
    std::vector<Event> events;
    Node* newNode;
    uint16_t target;
};

#if 0
class EventQueue
{
private:
    std::list<Report> m_queue;
    concurrent::Mutex mutex;
public:
    void clear();
    bool pop(Report& report);
    void push(Report& report);
};

class Captain : public concurrent::PThread
{
    EventQueue eventQueue;
    CommandQueue* commandQueue;
    GameState model;

public:
    void setListener(CommandQueue& commandQueue);
    EventQueue& getEventQueue();

private:
    void* run();
    void shutdown() volatile;
    bool pollEvents();
};
#endif

#endif // !defined CAPTAIN_H
