#include "commlink.h"
#include <cerrno>
#include <iomanip>

using std::ostream;
using std::hex;
using std::dec;
using std::endl;
using std::setw;

ostream& operator<<(ostream& os, const Keys& k)
{
    static const char* COMMA = ", ";
    const char* comma = &COMMA[2]; // ""

    if (k.fire()) {
        os << "FIRE";
        comma = COMMA;
    }
    if (k.left()) {
        os << comma << "LEFT";
        comma = COMMA;
    }
    if (k.right()) {
        os << comma << "RIGHT";
        comma = COMMA;
    }
    if (k.thrust()) {
        os << comma << "THRUST";
        comma = COMMA;
    }
    if (k.hyperspace()) {
        os << comma << "HYPERSPACE";
    }
    return os;
}


KeysPacket::KeysPacket()
        : keys(), ping(0)
{
    signature[0] = 'c';
    signature[1] = 't';
    signature[2] = 'm';
    signature[3] = 'a';
    signature[4] = 'm';
    signature[5] = 'e';
}

void CommLink::receivePacket(FramePacket &packet, const ServerModel*& model)
{
    fd_set readfds, writefds, exceptfds;

    do {
        FD_ZERO(&readfds);
        FD_ZERO(&writefds);
        FD_ZERO(&exceptfds);
        FD_SET(sd, &readfds);
        FD_SET(sd, &exceptfds);
        select(sd+1, &readfds, &writefds, &exceptfds, NULL);
        int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
        if (bytes_received != 1026 && bytes_received != sizeof packet) {
            int err = errno;
            fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
            exit(1);
        }
        if (bytes_received == sizeof packet)
            model = &packet.model;
        else model = 0;
        FD_ZERO(&readfds);
        FD_ZERO(&writefds);
        FD_ZERO(&exceptfds);
        FD_SET(sd, &readfds);
        timeval zero;
        zero.tv_sec = zero.tv_usec = 0;
        select(sd+1, &readfds, &writefds, &exceptfds, &zero);
    } while(FD_ISSET(sd, &readfds));
}

void CommLink::sendPacket(KeysPacket &packet)
{
    sockaddr_in server;
    memset(&server, 0, sizeof server);
    server.sin_family = AF_INET;
    server.sin_port = htons(1979);
    server.sin_addr.s_addr = server_ip;
    if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server)) {
        if (errno != EAGAIN) {
            perror("Fehler bei sendto()");
            exit(1);
        }
    }
}

ostream& ServerModel::printObj(ostream& os, const char* typeString, size_t i) const
{
    os << typeString << "\t" << setw(2)<<i << "\t" << (int)(x2.objects[i]) << "\t" << setw(4) << getX(i) << "\t" << setw(4) << getY(i)
    << "\t" << setw(3) << (int)(x2.dx[i]) << "\t" << setw(3) << (int)(x2.dy[i]);
    return os;
}

void ServerModel::print(ostream& os) const
{
    int i;
    os << "ServerFrame:"<<hex << toUint16(x0[0x5c], x0[0x5d]) << dec << endl;
    os << "Type\tidx\tstate\tx\ty\tdx\tdy\tstate\tcodo\t2F8\t2F9\n";

    for(i=34; i>=31; --i)
        printObj(os, "sshot", i) << "\n";

    for(i=30; i>=29; --i)
        printObj(os, "ushot", i) << "\n";

    printObj(os, "ufo", 28)
    << "\tf2ufo:" << (int)(x2.frames2ufo) << "\t2F8:" << hex << (int)(x2._2f8) << "\t2F9:" << (int)(x2._2f9) << dec << "\n";

    printObj(os, "ship", 27)
    << "\t" << (int)(x0[0x64]) << "\t" << (int)(x0[0x65])
    << "\thdg:" << hex << (int)(x0[0x61]) << dec << "\tstate:" << hex << (int)(x2.shipState) << dec << "\n";

    for(i=26; i>=0; --i)
        printObj(os, "rock", i) << "\tsf:" << setw(2) << (int)(getRockSf(i)) << " T" << (int)(getRockType(i)) << "\n";

    os << hex << "2FB:" << (int)(x2._2fb) << "\t2FC:" << (int)(x2._2fc) << "\t2FD:"<< (int)(x2._2fd) << dec << endl;
    os << hex << "rnd:" << toUint16(x0[0x5f], x0[0x60]) << dec << endl;
}
