#ifndef COMLINK_H
#define COMLINK_H

#include <iostream>

// sockets...
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "keys.h"

#define SOCKET int
#define ADDRESS in_addr_t

inline uint16_t toUint16(uint8_t lo, uint8_t hi)
{
    return (((uint16_t)hi)<<8)+lo;
}



#pragma pack(1)
struct X200
{
    uint8_t objects[35];
    int8_t dx[35];
    int8_t dy[35];
    uint8_t xhi[35];
    uint8_t yhi[35];
    uint8_t xlo[35];
    uint8_t ylo[35];
    uint8_t initialRocks;
    uint8_t numRocks;
    uint8_t frames2ufo;
    uint8_t _2f8;
    uint8_t _2f9;
    uint8_t shipState;
    uint8_t _2fb;
    uint8_t _2fc;
    uint8_t _2fd;
};

struct ServerModel
{
    uint8_t x0[256];
    X200 x2;
    void print(std::ostream& os) const;
    inline uint16_t getX(size_t i) const
    {
        return toUint16(x2.xlo[i], x2.xhi[i]);
    }
    inline uint16_t getY(size_t i) const
    {
        return toUint16(x2.ylo[i], x2.yhi[i]);
    }
    inline uint8_t getRockType(size_t i) const
    {
        return ((x2.objects[i] & 0x18) >> 3) +1;
    }
    inline uint8_t getRockSf(size_t i) const
    {
        const uint8_t& b(x2.objects[i]);
        return (b & 1) ? 14 : ((b & 2) ? 15 : 0);
    }

private:
    std::ostream& printObj(std::ostream& os, const char* typeString, size_t i) const;
};

struct FramePacket
{
    char vectorram[1024];
    uint8_t frameno;  // wird bei jedem Frame inkrementiert
    uint8_t ping;     // Der Server schickt das letzte empfangene ping-Byte zurueck
    ServerModel model;
};

class KeysPacket
{
public:
    char signature[6];
    Keys keys;
public:
    uint8_t ping;     // wird vom Server bei naechster Gelegenheit zurueckgeschickt. Fuer Latenzmessung.

    KeysPacket();
    void clear(void);         // alle Tasten loslassen
    void hyperspace(bool b);  // Hyperspace druecken (true) oder loslassen (false)
    void fire(bool b);        // Feuerknopf druecken (true) oder loslassen (false)
    void thrust(bool b);      // Beschleunigen ...
    void right(bool b);       // rechts drehen ...
    void left(bool b);        // links drehen
    inline void setKeys(Keys _keys)
    { keys = _keys; }
};


#pragma pack()


class CommLink
{
public:
    CommLink(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip)
    {};
    void receivePacket(FramePacket &packet, const ServerModel*& model);
    void sendPacket(KeysPacket &packet);
private:
    SOCKET sd;
    ADDRESS server_ip;
};





#endif // !defined COMLINK_H

