#include "event.h"

const char* Event::getTypeString() const
{
    static const char* types[] = { "unknown0", "ushot", "sshot", "ufo", "ship", "rock", "unknown6", "unknown7"
                                 };
    return types[flags & 0x07];
}

void Event::printFlags(std::ostream& os) const
{
    if (flags & APPEAR)
        os << "APPEAR ";
    if (flags & DISAPPEAR)
        os << "DISAPPEAR ";
    if (flags & REFINE_POS)
        os << "REFINE_POS ";
    if (flags & REFINE_SPEED)
        os << "REFINE_SPEED ";
    if (flags & REFINE_ERROR)
        os << "REFINE_ERROR ";
}


std::ostream& operator<<(std::ostream& os, const Event& e)
{
    os << "Event:" << e.getTypeString() << e.id << " ";
    e.printFlags(os);
    return os;
}
