/* 
 * File:   event.h
 * Author: archmage
 *
 * Created on June 29, 2008, 11:29 AM
 */

#ifndef _EVENT_H
#define	_EVENT_H

#include <stdint.h>
#include <iostream>

class Event
{
public:
    typedef enum {
        TYPE_USHOT = 1,
        TYPE_SSHOT = 2,
        TYPE_UFO = 3,
        TYPE_SHIP = 4,
        TYPE_ROCK = 5,

        APPEAR = 8,
        DISAPPEAR = 16,
        REFINE_POS = 32,
        REFINE_SPEED = 64,
        REFINE_HEADING = 128,
        REFINE_ERROR = 256 };

    uint16_t id;
    uint16_t flags;

    inline Event() : id(), flags()
    {}
    inline Event(uint16_t _id, uint8_t _flags) : id(_id), flags(_flags)
    {}
    const char* getTypeString() const;
    void printFlags(std::ostream& os) const;
};

std::ostream& operator<<(std::ostream& os, const Event& e);


#endif	/* _EVENT_H */

