#ifndef _KEYS_H
#define	_KEYS_H

class Keys
{
private:
    uint8_t keys;

public:
    static const char KEY_HYPERSPACE = 1;
    static const char KEY_FIRE = 2;
    static const char KEY_THRUST = 4;
    static const char KEY_RIGHT = 8;
    static const char KEY_LEFT = 0x10;

    inline Keys()
    : keys(64) {}
    inline Keys(uint8_t k)
    : keys(k) {}
    
    inline operator uint8_t() const
    { return keys; }
    
    inline void clear(void)         // alle Tasten loslassen
    { keys = 64; }
    
    void hyperspace(bool b);  // Hyperspace druecken (true) oder loslassen (false)
        
    void fire(bool b);        // Feuerknopf druecken (true) oder loslassen (false)
    void thrust(bool b);      // Beschleunigen ...
    void right(bool b);       // rechts drehen ...
    void left(bool b);        // links drehen
    
    inline bool hyperspace() const
    { return keys & KEY_HYPERSPACE; }
    inline bool fire() const
    { return keys & KEY_FIRE; }
    inline bool thrust() const
    { return keys & KEY_THRUST; }
    inline bool right() const
    { return keys & KEY_RIGHT; }
    inline bool left() const
    { return keys & KEY_LEFT; }
};
std::ostream& operator<<( std::ostream& os, const Keys& c );

inline void Keys::hyperspace(bool b)
{
    if (b)
        keys |= KEY_HYPERSPACE;
    else
        keys &= ~KEY_HYPERSPACE;
}

inline void Keys::fire(bool b)
{
    if (b)
        keys |= KEY_FIRE;
    else
        keys &= ~KEY_FIRE;
}

inline void Keys::thrust(bool b)
{
    if (b)
        keys |= KEY_THRUST;
    else
        keys &= ~KEY_THRUST;
}

inline void Keys::left(bool b)
{
    if (b) {
        keys |= KEY_LEFT;
        right(false);
    } else
        keys &= ~KEY_LEFT;
}

inline void Keys::right(bool b)
{
    if (b) {
        keys |= KEY_RIGHT;
        left(false);
    } else
        keys &= ~KEY_RIGHT;
}

#endif	/* _KEYS_H */
