//#include <stdio.h>
//#include <stdlib.h>
//#include <errno.h>
//#include <string.h>
#include <iostream>
#include <cerrno>

// 2 Includes for socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes for inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes for fcntl()
#include <unistd.h>
#include <fcntl.h>
// for memset()
#define INVALID_SOCKET -1

//#include "commlink.h"
//#include "model.h"
//#include "observation.h"
#include "captain.h"
#include "number1.h"

using std::cout;

//using observation::Observation;
//using observation::Observations;

int main(int argc, char* argv[])
{
    unsigned long server_ip;
    if (argc == 2) {
        server_ip = inet_addr(argv[1]);
    } else if (argc == 1)
        server_ip = inet_addr("127.0.0.1");
    else {
        fprintf(stderr, "Aufruf: asteroid <IP-Adresse>\n");
        exit(1);
    }

    if (server_ip == INADDR_NONE) {
        fprintf(stderr, "Ungueltige IP-Adresse: '%s'\n", argv[1]);
        exit(1);
    }

    SOCKET sd;
    sd = socket(AF_INET, SOCK_DGRAM, 0);
    if (sd == INVALID_SOCKET) {
        fprintf(stderr, "Fehler %d bei socket().\n", errno);
        exit(2);
    }

    if (-1 == fcntl(sd, F_SETFL, O_NONBLOCK)) {
        perror("Kann Socket nicht auf non-blocking setzen");
        exit(1);
    }
    sockaddr_in sa;
    memset(&sa, 0, sizeof sa);
    sa.sin_family = AF_INET;
    sa.sin_addr.s_addr = 0;
    sa.sin_port = 0;

    if (bind(sd, (struct sockaddr*) &sa, sizeof sa)) {
        fprintf(stderr, "Fehler %d bei bind().\n", errno);
        exit(2);
    }

    Number1 number1(sd, server_ip);
    //Captain captain;

    //number1.setListener(captain.getEventQueue());
    //captain.setListener(number1.getCommandQueue());

// number1.start();
// captain.start();
// number1.join();
// captain.join();

    number1.run();
    return 0;
}
