
#include "world.h"

#include "number1.h"
#include <algorithm>
#include "event.h"
#include "Interval.h"

using std::cout;
using std::cerr;
using std::endl;
using std::list;
using std::vector;
using std::set;
using std::max;
using std::min;
using std::hex;
using std::dec;
using std::make_pair;
using observation::Observation;
//using concurrent::MutexLock;

Number1::Number1(SOCKET sd, ADDRESS server_ip)
        : commlink(sd, server_ip)
{}

#if 0
void Number1::setListener(EventQueue& _eventQueue)
{
    eventQueue = &_eventQueue;
}

CommandQueue& Number1::getCommandQueue()
{
    return commandQueue;
}

void CommandQueue::clear()
{
    MutexLock lock(mutex);
    m_queue.clear();
}

bool CommandQueue::popIf(const Maneuver& oldMove, Maneuver& newMove)
{
    MutexLock lock(mutex);
    if (m_queue.empty())
        return false;
    Maneuver& front = m_queue.front();
    if (front == oldMove) {
        m_queue.pop_front();
        if (m_queue.empty())
          return false;
        front = m_queue.front();
        newMove = front;
        return true;
    }
    m_queue.clear();
    return false;
}

void CommandQueue::push(const Maneuver& man)
{
    MutexLock lock(mutex);
    m_queue.push_back(man);
}

void CommandQueue::pushReplace(const Maneuver& man)
{
    MutexLock lock(mutex);
    m_queue.clear();
    m_queue.push_back(man);
}
#endif


//void Number1::reconcile(const Observation& obs)
//{
//    vector<Event> events;
//    model.update(obs, events);
//}


//void verifyObject(const ServerModel& serverModel, const char* type, int idx, const Object_t& obj);
//
//template<>

template<typename Object_t>
bool verifyObject(const ServerModel& serverModel, const char* type, int idx, const Object_t& obj)
{
    bool error(false);
    //cout << "cmp " << type << obj.id << " <-> " << idx << endl;
    if (!obj.inRange(WorldCoords(serverModel.getX(idx), serverModel.getY(idx)))) {
        cerr << "out-of-range " << type << obj.id << " <-> " << idx << "\t" << (int) (serverModel.x2.objects[idx]) << "\t" << serverModel.getX(idx) << "\t" << serverModel.getY(idx)
        << "\t" << (int) (serverModel.x2.dx[idx]) << "\t" << (int) (serverModel.x2.dy[idx]) << endl;
        error = true;
    } else
        if (abs(serverModel.x2.dx[idx] - obj.d.dx) > obj.d_error.dx) {
            cerr << "wrong x-speed " << type << obj.id << "<->obj#" << idx << "\t" << (int) (serverModel.x2.objects[idx]) << "\tp( " << serverModel.getX(idx) << ", " << serverModel.getY(idx)
            << " )\t d(" << (int) (serverModel.x2.dx[idx]) << ", " << (int) (serverModel.x2.dy[idx]) << ") "<< endl;
            error = true;
        }
        if (abs(serverModel.x2.dy[idx] - obj.d.dy) > obj.d_error.dy) {
            cerr << "wrong y-speed " << type << obj.id << "<->obj#" << idx << "\t" << (int) (serverModel.x2.objects[idx]) << "\tp( " << serverModel.getX(idx) << ", " << serverModel.getY(idx)
            << " )\t d(" << (int) (serverModel.x2.dx[idx]) << ", " << (int) (serverModel.x2.dy[idx]) << ") "<< endl;
            error = true;
        }
    return error;
}

template bool verifyObject<TrackedShot>(const ServerModel& serverModel, const char* type, int idx, const TrackedShot& obj);

template<>
bool verifyObject<>(const ServerModel& serverModel, const char* type, int idx, const TrackedUfo& ufo)
{
    bool error(false);
    assert(idx == 28);
    if ((int8_t)(serverModel.x2.objects[28])>0) {
        if (!ufo.present) {
            cerr << "missed ufo" << endl;
            error = true;
        }
        else
            error |= verifyObject<Object>(serverModel, "ufo", 28, ufo);
    } else
        if (ufo.present) {
            cerr << "superfluous ufo" << endl;
            error = true;
        }
return error;
}

template<>
bool verifyObject<>(const ServerModel& serverModel, const char* type, int idx, const TrackedAsteroid& ast)
{
    bool error(false);
    if (ast.type != serverModel.getRockType(idx)) {
        cerr << "wrong rock type" << endl;
        error = true;
    }
    if (ast.size != TrackedAsteroid::sf2size(serverModel.getRockSf(idx))) {
        cerr << "wrong rock size" << endl;
        error = true;
    }
    error |= verifyObject<Object>(serverModel, "rock", idx, ast);
    return error;
}

template<>
bool verifyObject<>(const ServerModel& serverModel, const char* type, int idx, const TrackedShip& ship)
{
    bool error(false);
    assert(idx == 27);
    if ((int8_t)(serverModel.x2.objects[27])>0) {
        if (!ship.present) {
            cerr << "missed ship" << endl;
            error = true;
        }
        else {
            error |= verifyObject<Object>(serverModel, "ship", 27, ship);
            uint8_t dir(serverModel.x0[0x61]);
            if (!ship.heading.contains(dir)) {
                cerr << "ship heading " << hex << (int)(dir) << " not contained in " << ship.heading << dec << endl;
                error = true;
            }
        }
    } else
        if (ship.present) {
            cerr << "superfluous ship" << endl;
            error = true;
        }
    return error;
}

template<typename Iter>
bool verifyObjects(const ServerModel& serverModel, const char* type, int idx0, int idx1, int di,
                   const Iter& begin, const Iter& end)
{
    bool error(false);
    Iter obj = begin;
    for (int i = idx0; i != idx1; i += di) {
        if ((int8_t)(serverModel.x2.objects[i]) > 0) {
            if (obj == end) {
                cerr << "missed " << type << "\t" << i << "\t" << (int) (serverModel.x2.objects[i]) << "\t" << serverModel.getX(i) << "\t" << serverModel.getY(i)
                << "\t" << (int) (serverModel.x2.dx[i]) << "\t" << (int) (serverModel.x2.dy[i]) << endl;
                error = true;
            } else {
                error |= verifyObject(serverModel, type, i, *(obj++));
            }
        }
    }
    for (; obj != end; ++obj) {
        cerr << "superfluous " << type << obj->id << "\t" << obj->p << "\t" << obj->d << endl;
        error = true;
    }
    return error;
}

//template<typename Iter>
//void verifyObjects(const ServerModel& serverModel, const char* type, int idx0, int idx1, int di,
//                   const Iter& begin, const Iter& end)
//{
//    Iter obj = begin;
//    for (int i = idx0; i != idx1; i += di) {
//        if ((int8_t)(serverModel.x2.objects[i]) > 0) {
//            if (obj == end) {
//                cerr << "missed " << type << "\t" << i << "\t" << (int) (serverModel.x2.objects[i]) << "\t" << serverModel.getX(i) << "\t" << serverModel.getY(i)
//                << "\t" << (int) (serverModel.x2.dx[i]) << "\t" << (int) (serverModel.x2.dy[i]) << endl;
//            } else {
//                verifyObject(serverModel, type, i, *(obj++));
//            }
//        }
//    }
//    for (; obj != end; ++obj)
//        cerr << "superfluous " << type << obj->id << "\t" << obj->p << "\t" << obj->d << endl;
//
//}


void Number1::verifyModel(const ServerModel& serverModel)
{
    bool error(false);
    error |= verifyObjects(serverModel, "sshot", 34, 30, -1, model.sshots.begin(), model.sshots.end());
    error |= verifyObjects(serverModel, "ushot", 30, 28, -1, model.ushots.begin(), model.ushots.end());
    error |= verifyObject(serverModel, "ufo", 28, model.ufo);
    error |= verifyObject(serverModel, "ship", 27, model.ship);
    error |= verifyObjects(serverModel, "rock", 26, -1, -1, model.asteroids.begin(), model.asteroids.end());

    if ((serverModel.x0[0x5c] & 3) != ((model.time + frameOffset) & 3)) {
        int nfo = ((serverModel.x0[0x5c] & 3) - (model.time & 3));

        nfo = mod(nfo, 4);
        cout << "Wrong frameOffset "<< frameOffset << " should be "<<nfo <<endl;
        cout << "Adjusting frameOffset to "<<nfo << endl;
        frameOffset = nfo;
        error = true;
    }

    if (error) {
        cout << "Errrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrror\a";
        //model.print(cout);
    }
            
    cout << endl;
}


bool Number1::instinctiveMove(Maneuver& newMove, uint16_t& newTarget) {
//    // TODO if exact heading unknown discard targets within 4*3 deg
//    // TODO if none left turn e.g. left    
//    Target best;
//    uint16_t target;
//    uint32_t bestscore(0xffffffff);
//
//    if (model.ufo.present && !model.hitByMe(model.ufo)
//            && model.targetObject(model.ufo, best)) {
//        bestscore = (best.ts - model.time + best.th / 2) / 2;
//        target = model.ufo.id;
//    }
//
//    for (list<TrackedAsteroid>::const_iterator a = model.asteroids.begin();
//            a != model.asteroids.end(); ++a) {
//        if (model.hitByMe(*a))
//            continue;
//        Target m;
//        cout << "\nTargeting " << "rock"<< a->id << ":" << endl;
//        if (model.targetObject(*a, m)) {
//            uint32_t score = m.ts - model.time + m.th;
//            if (score < bestscore) {
//                best = m;
//                bestscore = score;
//                target = a->id;
//            }
//        }
//    }
//
//    if (bestscore != 0xffffffff) {
//        //commandQueue.pushReplace(Command(model.time, Command::TURN, m.alpha));
//        //cmd = Command(model.time, Command::TURN, best.alpha);
//        newMove.when = best.ts;
//        newMove.angle = best.alpha;
//        newMove.accel_duration = 255;
//        newTarget = target;
//        return true;
//        //commandQueue.pushReplace(Command(best.ts, Command::FIRE));
//        //commandQueue.pushReplace(Maneuver3(best.alpha, best.ts));
//    } else {
//        return false;
//    }

        
    bool res(false);    
        
    Target tgt;
    if (model.findTarget(tgt)) {
    newMove.when = tgt.tfire;
    newMove.angle = tgt.alpha;
    newMove.accel_duration = 255;
    newTarget = tgt.targetId;
    res = true;
    }
    
//    if (model.ship.deathBy && model.ship.death-model.time < 100 && (tgt.targetId != model.ship.deathBy || model.ship.death < tgt.thit)) {
//        Object* obj(model.findObject(ObjectIdMatcher(model.ship.deathBy)));
//        if (obj) {
//        uint8_t sheading = model.ship.getHeading();
//        WorldDisp8 d = obj->d - model.ship.d;
//        uint8_t oangle = ast_atan2(d.dy, d.dx);
//        uint8_t ang_evas = (oangle - sheading <= 127) ? oangle - 0x40 : oangle + 0x40;
//        int8_t ticks = (int8_t)(ang_evas - sheading) / 3;
//        newMove.when = model.time+abs(ticks);
//        newMove.angle = sheading+3*ticks;
//        newMove.accel_duration = (abs((int8_t)(oangle-sheading))<0x40) ? 20 : 10; // 20 means start immed, 10 after reaching
//        newTarget = obj->id;
//        cout << "oangle:" << hex << (int)(oangle) << " ang_evas:" << (int)(ang_evas) << " move_angle:" << (int)(newMove.angle) << dec << " ticks:" << (int)(ticks)  << endl;
//        res = true;
//        }
//    } 

    return res;
}

void* Number1::run()
{

    FramePacket frame;
    Keys keys;
    uint8_t prevframe(0);
    uint32_t t(1);
    model.time = t;
    Maneuver lastMove;
    Maneuver currMove;
    uint16_t target(0);
    bool executing(false);
    KeysPacket keysPacket;
    uint32_t prevShipCollision(0);
    
    commlink.sendPacket(keysPacket);

    while (true) {
        // 1) RECEIVE FRAME

        const ServerModel* serverModel;
        commlink.receivePacket(frame, serverModel);
        if (t==1)
            prevframe = frame.frameno-1;

        if (frame.frameno != prevframe+1 || frame.ping != keysPacket.ping) {
            printf("Latenz %d. %d Frames verloren.\n", keysPacket.ping - frame.ping, frame.frameno - prevframe -1);
        }

        uint8_t n = frame.frameno - prevframe;
        t += n-1;
        observations.setTime(t);

        while (model.time < t) {
            cout << "compensating frame loss" << endl;
            model.advance();
        }

#ifndef NDEBUG
        if (serverModel) {
                serverModel->print(cout);
                cout << endl;
            }
#endif


        // 2) VERIFY MODEL

//        if (true) {
//            cout << "Our Model: ";
//            model.print(cout);
//            cout << endl;
//        }

//        if (serverModel)
//            verifyModel(*serverModel);


        // 3) INTERPRET SCREEN, RECONCILE & REFINE MODEL

        
        observations.interpretScreen(frame);
#ifndef NDEBUG
        observations.getCurrent().print(cout);
#endif
        vector<Event> events;
        model.update(observations.getCurrent(), events);

        // update collisions from events

        // 4) VERIFY MODEL AGAIN

#ifndef NDEBUG                
      if (true) {
            cout << "Our Model: (reconciled)";
            model.print(cout);
            cout << endl;
        }

        if (serverModel)
            verifyModel(*serverModel);
#endif

        // 5) ADVANCE MODEL

        if (frame.ping == keysPacket.ping) {
            model.ship.activeKeys = model.ship.sentKeys;
        }

        model.advance();
        assert ( model.time == t+1 );
        ++t;

        model.updateCollisions(events);        
        
#ifndef NDEBUG
        if (true) {
            cout << "Our Model: (advanced) ";
            model.print(cout);
            cout << endl;
        }
#endif
        keys.clear();
        if (model.ship.present) {
        // 6) POLL NEW STRATEGY

            bool popped(false);
            //            if (!executing) {
            //                popped = commandQueue.popIf(lastMove, currMove);
            //            }

            // 7) VALIDATE STRATEGY

            //   if panic
            //       {
            //       keys.clear();
            //       keys.hyperspace(true);
            //       commandQueue.clear();
            //       eventQueue.push(keys);
            //       }

            //model.checkCollisions();

            // if ship refined or target refined
            // if own maneuver
            // re-evaluate
            if (executing && model.ship.activeCommand == currMove) {
                for (vector<Event>::const_iterator e = events.begin(); e != events.end(); ++e) {
                    if (e->id == model.ship.id) {
                        executing = false;
                        break;
                    }
                    if (e->id == target) {
                        executing = false;
                        break;
                    }
                }

                // TODO check for new ship collision
                if (model.ship.death < prevShipCollision) {
                    executing = false;
                }
                prevShipCollision = model.ship.death;
            }

            if (executing) {
                keys.clear();
                Ship::mission_result_t res = model.ship.deriveKeys(t, keys);
                cout << model.ship.activeCommand << "(obj" << target << ") => " << keys << ", " << res << endl;
                if (res == Ship::MISSION_IMPOSSIBLE || res == Ship::MISSION_COMPLETED)
                    executing = false;
            }

//            if (!executing) {
            else {
                popped = instinctiveMove(currMove, target);


                if (popped) {
                    model.ship.activeCommand = currMove;
                    executing = true;

                    Ship::mission_result_t res = model.ship.deriveKeys(t, keys);
                    cout << model.ship.activeCommand << "(obj" << target << ") => " << keys << ", " << res << endl;
                    if (res == Ship::MISSION_IMPOSSIBLE || res == Ship::MISSION_COMPLETED)
                        executing = false;
                } else {
                    keys.clear();
                    if (model.ship.heading.n != 1) {
                        if (!keys.right()) {
                            cout << "no cmd, turning left for fun" << endl;
                            keys.left(true);
                        }
                    }
                }
            }

            //            if (model.ship.activeKeys.fire())
            //                keys.fire(false); // clear fire if sent fire acknowledged
        } else { // ship not present
            model.ship.activeCommand = currMove = Maneuver();
            executing = false;
            //            keys.clear();
        }

        if (model.ship.deathBy && model.ship.death - t < 3) {
            Object* o(model.findObject(ObjectIdMatcher(model.ship.deathBy)));
            if (o) {
                if (o->p_error.cheb() < 20) {
                 cout << "Resorting to hyperspace" << endl;
                 keys.hyperspace(true);
                }
            }
        }

        // 8) SEND KEYS

        ++keysPacket.ping; // jedes gesendete Paeckchen erhaelt eine individuelle Nummer zur Latenzmessung
        keysPacket.setKeys(keys);
        commlink.sendPacket(keysPacket);
        model.ship.sentKeys = keys;

        // 9) SEND REPORT TO CAPTAIN

        // model, events, actions and strategy persued
        // ...

        cout << "\n" << endl;
        prevframe = frame.frameno;
    } // while (true)
    return 0;
}

//struct Minmax
//{
//    int min;
//    int max;
//    Minmax() : min(999), max(-1) {}
//};
//
//std::map<uint16_t, Minmax > mappi;
//std::set<uint8_t> done;
//const observation::Ship& oship = observations.getCurrent().ship;
//if (oship.present) {
//    //assert(false);
//    uint8_t dir = serverModel->x0[0x61];
//    int8_t dx8(oship.heading_dx >> 3);
//    int8_t dy8(oship.heading_dy >> 3);
//    uint16_t hash((((uint8_t) (dx8)) << 8) | ((uint8_t) (dy8)));
//    cout << "head: " << (int) (dir) << ",  " << (int) (oship.heading_dx) << ", " << (int) (oship.heading_dy)
//            << "  " << (int) (dx8) << " " << (int) (dy8) << " " << hex << hash
//            << " == " << getHeadingHash(oship.heading_dx, oship.heading_dy) << dec << endl;
//    assert(getHeadings(oship.heading_dx, oship.heading_dy).contains(dir));
//
//    Minmax& minmax = mappi[hash];
//    minmax.min = std::min(minmax.min, (int) (dir));
//    minmax.max = std::max(minmax.max, (int) (dir));
//    done.insert(dir);
//    if (done.size() == 256) {
//        for (std::map<uint16_t, Minmax>::const_iterator i = mappi.begin(); i != mappi.end(); ++i)
//            cout << "mappi:" << hex << i->first << dec << " " << i->second.min << " " << i->second.max << endl;
//        return 0;
//    }
//}


void Number1::shutdown() volatile {
    assert(false);
}

