#include "screen.h"
#include "commlink.h"
#include <cassert>
#include "tracking.h"

using std::map;
using std::vector;
using std::ostream;
using std::cout;
using std::endl;
using namespace observation;

void Observations::setTime(uint32_t time)
{
    while (currentTime < time) {
        ++currentTime;
        getCurrent().clear();
        getCurrent().time = currentTime;
    }
}

Observation& Observations::interpretScreen(FramePacket &packet)
{
    Observation& current = getCurrent();
    current.interpretScreen(packet);
    return current;
}

//Observation& Observations::getSlot(uint32_t time)
//{
//    return observations[time % MAX_OBSERVATIONS];
//}
//
//Observation& Observations::getCurrent()
//{
//    return getSlot(currentTime);
//}
//
//Observation* Observations::get(uint32_t time)
//{
//    Observation* res(0);
//
//    if (currentTime - time < (size_t)(MAX_OBSERVATIONS) && (time <= currentTime)) {
//        res = &observations[time % MAX_OBSERVATIONS];
//        if (!res->present)
//            res = 0;
//    }
//    return res;
//}

void Observation::clear()
{
//    shotIds.clear();
//    asteroidIds.clear();
//    present = false;
    shots.clear();
    ufo.present = false;
    ship.present = false;
    asteroids.clear();
}

void Observation::interpretScreen(FramePacket &packet)
{
    unsigned short vector_ram[512];
    int dx, dy, sf, vz, vs(0);
    ScnCoords vp;
    int v1x = 0;
    int v1y = 0;
    int shipdetect = 0;

    clear();
    present = true;
#ifndef NDEBUG    
    cout << "ctFrame:" << (int) (packet.frameno) << endl;
#endif
    /* Vektor-RAM in 16-Bit-Worte konvertieren. War in der ersten Version mal ein sportlicher
       Typecast: unsigned short *vector_ram = (unsigned short*)packet.vectorram;
       Das klappt aber nur auf Little-Endian-Systemen, daher besser portabel: */
    for (int i = 0; i < 512; ++i)
        vector_ram[i] = (unsigned char) packet.vectorram[2 * i] | (unsigned char) packet.vectorram[2 * i + 1] << 8;

    if (vector_ram[0] != 0xe001 && vector_ram[0] != 0xe201)
        return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

    int pc = 1;
    while (pc < 512) {
        int op = vector_ram[pc] >> 12;
        switch (op) {
            case 0xa: // LABS
                vp = ScnCoords(vector_ram[pc + 1] & 0x3ff, vector_ram[pc] & 0x3ff);
                vs = vector_ram[pc + 1] >> 12;
                //cout << "LABS("<<vp<<"), "<<vs << endl;
                break;
            case 0xb: // HALT
//                cout << "HALT" << endl;
                return;
            case 0xc: // JSRL
                switch (vector_ram[pc] & 0xfff) {
                    case 0x8f3:
                        asteroids.push_back(Asteroid(vp, vs, 1));
//                        cout << "asteroid(1, " << vs << ",  " << vp << ")" << endl;
                        break;
                    case 0x8ff:
                        asteroids.push_back(Asteroid(vp, vs, 2));
//                        cout << "asteroid(2, " << vs << ",  " << vp << ")" << endl;
                        break;
                    case 0x90d:
                        asteroids.push_back(Asteroid(vp, vs, 3));
//                        cout << "asteroid(3, " << vs << ",  " << vp << ")" << endl;
                        break;
                    case 0x91a:
                        asteroids.push_back(Asteroid(vp, vs, 4));
//                        cout << "asteroid(4, " << vs << ",  " << vp << ")" << endl;
                        break;
                    case 0x929:
                        ufo.present = true;
                        ufo.pos = vp;
                        ufo.sf = vs;
//                        cout << "ufo(" << vs << ",  " << vp << ")" << endl;
                        break;
                }
                break;
            case 0xd: // RTSL
                return;
            case 0xe: // JMPL
                /*
                  pc = vector_ram[pc] & 0xfff;
                  break;
                 */
                return;
            case 0xf: // SVEC
                /*
                  dy = vector_ram[pc] & 0x300;
                  if ((vector_ram[pc] & 0x400) != 0)
                  dy = -dy;
                  dx = (vector_ram[pc] & 3) << 8;
                  if ((vector_ram[pc] & 4) != 0)
                  dx = -dx;
                  sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
                  vz = (vector_ram[pc] & 0xf0) >> 4;
                 */
                break;
            default:
                dy = vector_ram[pc] & 0x3ff;
                if ((vector_ram[pc] & 0x400) != 0)
                    dy = -dy;
                dx = vector_ram[pc + 1] & 0x3ff;
                if ((vector_ram[pc + 1] & 0x400) != 0)
                    dx = -dx;
                sf = op;
                vz = vector_ram[pc + 1] >> 12;
                if (dx == 0 && dy == 0 && vz == 15) {
                    shots.push_back(Shot(vp));
//                    cout << "shot(" << vp << ")" << endl;
                }
                if (op == 6 && vz == 12 && dx != 0 && dy != 0) {
                    switch (shipdetect) {
                        case 0:
                            v1x = dx;
                            v1y = dy;
                            ++shipdetect;
                            break;
                        case 1:
                            ship.present = true;
                            ship.pos = vp;
                            ship.heading_dx = v1x - dx;
                            ship.heading_dy = v1y - dy;
                            ++shipdetect;
//                            cout << "ship(" << vp << ",  " << ship.heading_dx << "," << ship.heading_dy << ")" << endl;
                            break;
                    }
                } else if (shipdetect == 1)
                    shipdetect = 0;

                break;
        }
        if (op <= 0xa)
            ++pc;
        if (op != 0xe) // JMPL
            ++pc;
    }

}

void Observation::print(ostream& os) const
{
       
    for(vector<Shot>::const_iterator shot=shots.begin(); shot!=shots.end();++shot) {
        os << "SHOT" << shot->pos << "->" << scn2world(shot->pos) << endl;
    }
    if (ufo.present)
        os << "UFO" << ufo.pos << "->" << scn2world(ufo.pos) << endl;
    if (ship.present)
        os << "SHIP" << ship.pos << "->" << scn2world(ship.pos) << endl;
    for(vector<Asteroid>::const_iterator ast=asteroids.begin(); ast!=asteroids.end();++ast) {
        os << "ASTEROID" << ast->pos << "->" << scn2world(ast->pos) << "\tsf" << (int)(ast->sf) << "\tT" << (int)(ast->type) << endl;
    }

}

