#ifndef SCREEN_H
#define SCREEN_H

#include <vector>
#include <map>
#include <iostream>
#include <cassert>


class FramePacket;

struct ScnCoords
{
    uint16_t x;
    uint16_t y;

    inline ScnCoords()
            : x(0), y(0)
    {}

    inline ScnCoords(uint16_t _x, uint16_t _y)
            : x(_x), y(_y)
    {}

    inline bool operator==(const ScnCoords& o) const
    {
        return x==o.x && y==o.y;
    }

    inline bool operator!=(const ScnCoords& o) const
    {
        return x!=o.x || y!=o.y;
    }

};

namespace observation
{

class Object
{
public:
    ScnCoords pos;
inline Object()
        : pos(0,0) {}
inline Object(const ScnCoords& _pos)
        : pos(_pos) {}
};

class Shot : public Object
{
public:
inline Shot(const ScnCoords& _pos)
        : Object(_pos)
{}
};

class Asteroid : public Object
{
public:
    uint8_t sf;  // scale factor: 0 = large, 15 = medium, 14 = small
    uint8_t type;  // 1 ... 4

inline Asteroid(const ScnCoords& _pos, uint8_t _sf, uint8_t _type)
        : Object(_pos), sf(_sf), type(_type)
{}
};

class Ship : public Object
{
public:
    bool present;
    int16_t heading_dx;
    int16_t heading_dy;
    Ship() : Object(), present(false), heading_dx(0), heading_dy(0) {}
};

class UFO : public Object
{
public:
    uint8_t sf;  // 15 = large, 14 = small
    bool present;  // UFO sichtbar
    UFO() : Object(), sf(0), present(false) {}
};


class Observation
{
public:
    uint32_t time;
//    std::map<uint16_t, size_t> shotIds;
//    std::map<uint16_t, size_t> asteroidIds;
    bool present;
    std::vector<Shot> shots;
    UFO ufo;
    Ship ship;
    std::vector<Asteroid> asteroids;

//    inline Observation() : time(0), shotIds(), asteroidIds(), present(false), shots(), ufo(), ship(), asteroids()
//    {}
  inline Observation() : time(0), present(false), shots(), ufo(), ship(), asteroids()
    {}
    void clear(void);
    void interpretScreen(FramePacket &packet);
//    const Asteroid& getAsteroid(uint16_t id) const;
//    const Shot& getShot(uint16_t id) const;
    void print(std::ostream& out) const;
};

class Observations
{
public:
//    static const int MAX_OBSERVATIONS = 15;
    uint32_t currentTime;
//    Observation observations[MAX_OBSERVATIONS];
    Observation observation;
    inline Observations() : currentTime(0)
    {}
    inline Observation& getCurrent() { return observation; }
    void setTime(uint32_t time);
    Observation& interpretScreen(FramePacket &packet);
//    Observation& getSlot(uint32_t time);
//    Observation* get(uint32_t time);
private:
};







inline std::ostream& operator<<(std::ostream& os, const ScnCoords& c)
{
    os << "("<<c.x<<", "<<c.y<<")";
    return os;
}


//inline const Asteroid& Observation::getAsteroid(uint16_t id) const
//{
//    std::map<uint16_t, size_t>::const_iterator i = asteroidIds.find(id);
//    if (i == asteroidIds.end()) {
//        assert (false);
//        throw std::exception();
//    }
//    return asteroids[i->second];
//}
//
//inline const Shot& Observation::getShot(uint16_t id) const
//{
//    std::map<uint16_t, size_t>::const_iterator i = shotIds.find(id);
//    if (i == shotIds.end()) {
//        assert (false);
//        throw std::exception();
//    }
//    return shots[i->second];
//}

};


#endif // !defined SCREEN_H
