#include <stdio.h>

#include "output.h"
#include "connection.h"
#include "game.h"
#include "player.h"


int main(int argc, const char* argv[])
{
   if (argc > 2)
   {
      fprintf(stderr, "Aufruf: asteroid <IP-Adresse>\n");
      return 1;
   }

   try
   {
      Connection con(argc == 2 ? argv[1] : "127.0.0.1");

      Player player;

      Game game(con, player);
      game.Run();
   }
   catch (connection_error &ce)
   {
      OutputError(ce.what());
   }
   catch (...)
   {
      OutputError("Unerwarteter Fehler.");
   }

   return 0;
}
