// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import java.util.LinkedList;

/**
 *  Frame preparer which works against score overflow.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>
 */
public class ScoreFixer
        implements FramePreparer
{
  /** Number when the score wraps to 0. */
  private static final int GAME_SCORE_WRAP = 100000;

  /** Is the game starting (than score drop to 0 is allowed). */
  private boolean starting = false;
  /**
   * Prepare the frame(s).
   *
   * @param frameInfos the collected frame infos
   */
  public void prepareFrames(LinkedList<FrameInfo> frameInfos)
  {
    if (frameInfos.size() >= 2) {
      FrameInfo lastFrame = frameInfos.getLast();
      int lastScore = lastFrame.getScore();
      int prevScore = frameInfos.get(frameInfos.size() - 2).getScore();
      if (prevScore > lastScore) {
        // possibly score overflow
        if (!starting) {
          lastFrame.setScore(lastScore == -1  ?
                  prevScore :
                  lastScore +
                  prevScore % GAME_SCORE_WRAP +
                  GAME_SCORE_WRAP);
        }
        starting = lastFrame.isGameRunning();
      }
      else if (!lastFrame.isGameRunning()) {
        starting = true;
      }
    }
  }
}
