unit Tools;
interface
Uses U_Spiel,U_Asteroid_Manager,U_Schuss_Manager,U_UfoSchuss_Manager,U_Schiff,U_Key,U_Mame,U_ki_Manager,U_Explosion_Manager,konstanten;

var Spiel:TSpiel;
    Asteroid:TAsteroid_Manager;
    Schuss:TSchuss_Manager;
    UfoSchuss:TUfoSchuss_Manager;
    Schiff:Tschiff;
    Explosion:TExplosion_Manager;
    Key:TKey;
    Mame:TMame;
    KI:TKi_Manager;

    MameCounter:integer;
    MameLatenz,MameLatenzFehler:integer;
    Latenz,altLatenz,LatenzFehler:integer;
    counter:integer;
    test1,test2:int64;

var schuss_tabelle:array[0..255,0..70]of TXY;
var winkel_Tabelle:array[0..255,0..2]of double;

const SR_Schritte=208;const SR_length=1400;
      max_Wait=9;
type TSR=record x,y:smallint;winkel,flug,wait,tmp:byte;end;
type TSRZeile=array [0..SR_length]of TSR;
var SRTabelle:array[0..255,0..SR_Schritte-1]of TSRzeile;
var FirstSchussTabelle:array[0..31] of array of Txy;



function berechne_schiff_richtung(const x,y:integer):byte;
function berechne_richtungsdifferenz(const r1,r2:integer):integer;
function berechne_abstand(const xa,ya,xe,ye:integer):double;inline;
function berechne_abstand2(const xa,ya,xe,ye:integer):integer;inline;
function berechne_richtung_winkel(const xa,ya,xe,ye:integer):integer;overload;

function OptimiereX(const x:integer):integer;inline;
function OptimiereY(const y:integer):integer;inline;
function OptimiereW(const WB:integer):integer;inline;
procedure CopyRam(const von,nach:pointer;const laenge:integer);

procedure log(Datei,text:string;Anzeigen:boolean=false);
function copyarray(const von:ArrayOfInteger):ArrayOfInteger;
procedure tool_init;


implementation
uses tlhelp32,Windows,SysUtils,Classes,forms,unit1,unit2, Messages,  Variants,  Graphics, Controls, StdCtrls, ExtCtrls;
var schiff_richtung_tabelle:array[0..63,0..1]of integer;


procedure CopyRam(const von,nach:pointer;const laenge:integer);
begin
    asm
    push edi
    push esi
    cld
    mov esi,von
    mov edi,nach
    mov ecx,laenge
    shr ecx,2
    REP MOVSD
    mov ecx,laenge
    and ecx,3
    REP MOVSB
    pop esi
    pop edi
  end;
end;

function copyarray(const von:ArrayOfInteger):ArrayOfInteger;
var i:integer;
begin
  setlength(result,length(von));
  for i:=0 to length(von)-1 do result[i]:=von[i];
end;

procedure log(Datei,text:string;Anzeigen:boolean=false);
var f:textfile;
begin
  if (wk)and(Datei='')and((spiel=nil)or(not spiel.ende)) then exit;
  if Datei<>'' then begin
     datei:='log\'+datei+'.log';
     if (text='clear')or(not fileexists(datei)) then begin assignfile(f,datei);rewrite(f);closefile(f);end;

     assignfile(f,datei);
     {$I-}
     append(f);
     if ioresult=0 then begin
        writeln(f,text);
        closefile(f);
     end;
     {$I+}
  end else anzeigen:=true;
  if spiel<>nil then text:=inttostr(spiel.spielzeit)+' / '+timetostr(spiel.spielzeit/60/24/3600)+'  '+text;
  if anzeigen then form1.memo1.lines.add(text);
end;


procedure split(var a:Tstrings;sub,s:string);
var p:integer;
begin
  a.Clear;
  if length(s)<1 then exit;
  p:=pos(sub,s);
  while p>0 do begin
    a.Add(copy(s,1,p-1));
    s:=copy(s,p+length(sub),length(s));
    p:=pos(sub,s);
  end;
  a.Add(s);
end;



procedure KillIt(dwProcID: DWORD);
var hProcess : Cardinal;
begin
  hProcess := OpenProcess(SYNCHRONIZE or PROCESS_TERMINATE, False, dwProcID);
  TerminateProcess(hProcess, 0);
end;

procedure schliesse_MAME;
var
  hProcSnap: THandle;
  pe32: TProcessEntry32;
begin
  try
    hProcSnap := CreateToolHelp32SnapShot(TH32CS_SNAPPROCESS, 0);
    if hProcSnap = INVALID_HANDLE_VALUE then exit;
    pe32.dwSize := SizeOf(ProcessEntry32);
    if Process32First(hProcSnap, pe32) then
      while Process32Next(hProcSnap, pe32) do begin
            if pos('mameaster.exe',pe32.szExeFile)>0 then begin KillIt(pe32.th32ProcessID);end;
      end;
    CloseHandle(hProcSnap);
  except end;
end;



function OptimiereX(const x:integer):integer;inline;
begin
  result:=x;
  while result<-512 do inc(result,1024);
  while result>=512 do dec(result,1024);
end;

function OptimiereY(const y:integer):integer;inline;
begin
  result:=y;
  while result<-384 do inc(result,768);
  while result>=384 do dec(result,768);
end;


function OptimiereW(const WB:integer):integer;inline;
begin
  result:=(WB+65536) and $ff;
end;



function berechne_richtung_winkel(const xa,ya,xe,ye:integer):integer;overload;
var xd,yd,d,min,xx,yy:double;
    w:integer;
begin
  xd:=OptimiereX(xe-xa);
  yd:=OptimiereY(Ye-Ya);
  d:=sqrt(sqr(xd)+sqr(yd));
  if d<1 then begin result:=0;exit;end;
  xd:=xd/d;
  yd:=yd/d;
  min:=99999999999;
  result:=0;
  for w:=0 to 255 do begin
      xx:=winkel_Tabelle[w,1];
      yy:=winkel_Tabelle[w,2];
      d:=abs(xx-xd)+abs(yy-yd);
      if d<min then begin min:=d;result:=w;end;
  end;
end;


function berechne_schiff_richtung(const x,y:integer):byte;
var w:integer;
begin
  for w:=0 to 63 do
      if (schiff_richtung_tabelle[w,0]=x)and(schiff_richtung_tabelle[w,1]=y) then begin result:=w shl 2;exit;end;
  form1.Memo1.Lines.Add('Fehler berechne_schiff_richtung');
  result:=0;
end;

function berechne_richtungsdifferenz(const r1,r2:integer):integer;
var d:integer;
begin
  d:=(r1-r2+65536)and $ff;
  result:=d div 3 - d mod 3 * 85;
  while result>127 do dec(result,256);
  while result<-128 do inc(result,256);


//  result:=r1-r2;
//  while result>127 do dec(result,256);
//  while result<-128 do inc(result,256);
end;

function berechne_abstand(const xa,ya,xe,ye:integer):double;inline;
begin
  result:=sqrt(sqr(OptimiereX(xe-xa))+sqr(OptimiereY(ye-ya)));
end;

function berechne_abstand2(const xa,ya,xe,ye:integer):integer;inline;
begin
  result:=sqr(OptimiereX(xe-xa))+sqr(OptimiereY(ye-ya));
end;



procedure WB_init;
var f:textfile;
    s:string;
    t:tstrings;
    tt,x,wb,anz:integer;
begin
  t:=tstringlist.Create;
  assignfile(f,'daten/schuss2.csv');
  reset(f);
  tt:=0;
  while not eof(f) do begin
        readln(f,s);
        split(t,';',s);
        if (t.Count>2)and(tt<256) then begin
           wb:=strtoint(t[0])and $ff;
           anz:=(t.Count-2)div 2;
           if anz>=71 then anz:=70;
           for x:=2 to anz do begin
               schuss_tabelle[wb,x].x:=optimiereX(strtoint(t[x*2]));
               schuss_tabelle[wb,x].y:=optimiereY(strtoint(t[x*2+1]));
           end;
           inc(tt);
        end;
  end;
  closefile(f);
  t.Free;
end;

procedure schiff_richtung_tabelle_init;
var f:textfile;
    s:string;
    t:tstrings;
    x,y,w:integer;
begin
  t:=tstringlist.Create;
  assignfile(f,'daten\schiff_richtung.csv');
  reset(f);
  while not eof(f) do begin
        readln(f,s);
        split(t,';',s);
        if (t.Count>2) then begin
           w:=strtoint(t[0])and $ff;
           x:=strtoint(t[1]);
           y:=strtoint(t[2]);
           schiff_richtung_tabelle[w,0]:=x;
           schiff_richtung_tabelle[w,1]:=y;
        end;
  end;
  closefile(f);
  t.Free;
end;

procedure init_SRTabelle_Zeile_quicksort(var sr:TSRZeile;a,e:integer);
var aa,ee:integer;
    m:integer;
    s:TSR;
begin
  if e<a then exit;
  aa:=a;ee:=e;
  m:=SR[(a+e) shr 1].x;
  repeat
    while SR[a].x<m do inc(a);
    while SR[e].x>m do dec(e);
    if a<=e then begin
       s:=SR[a];
       SR[a]:=SR[e];
       SR[e]:=s;
       inc(a);dec(e);
    end;
  until a>e;
  if e>aa then init_SRTabelle_Zeile_quicksort(SR,aa,e);
  if a<ee then init_SRTabelle_Zeile_quicksort(SR,a,ee);
end;



function init_SRTabelle_Zeile(var sr:TSRZeile;richtung,schritte:integer):integer;
var anz,ar,f,winkel,wait:integer;
begin
  anz:=0;
  for ar:=-128 to 127 do if abs(ar)<schritte then begin // AbschussRichtung
      winkel:=OptimiereW(richtung+ar*3);
      for f:=2 to schritte-abs(ar) do if f<=70 then begin // Flugdauer des schusses
          wait:=schritte-abs(ar)-f;
          if wait<=max_Wait then begin
             if anz<SR_length then begin
                SR[anz].x:=schuss_tabelle[winkel,f].x;
                SR[anz].y:=schuss_tabelle[winkel,f].y;
                SR[anz].winkel:=winkel;
                SR[anz].flug:=f;
                SR[anz].wait:=wait;
             end;
             inc(anz);
          end;

       end;
  end;
  result:=anz;
  if anz>=SR_length then anz:=SR_length;
  init_SRTabelle_Zeile_quicksort(SR,0,anz-1);
  SR[SR_length].x:=anz-1;
end;


procedure init_SRTabelle;
var r,s,anz,max:integer;
begin
  max:=0;
  log('SR','clear');
  for r:=0 to 255 do begin// Richtungen
      for s:=0 to SR_Schritte-1 do begin // Schritt-Vorhersagen
          anz:=init_SRTabelle_Zeile(SRTabelle[r,s],r,s);
          if anz>max then max:=anz;
          IF r=0 then log('SR',inttostr(s)+';'+inttostr(anz));
      end;
      form2.bar.StepBy(1);
  end;
  log('SR','Max:'+inttostr(max));
end;

procedure init_FirstSchussTabelle;
var level,i,p:integer;
    f:textfile;
    s:string;

begin
  {$I-}
  for level:=0 to 31 do begin
      setlength(FirstSchussTabelle[level],0);
      i:=0;
      assignfile(f,'daten\Level\neu_'+inttostr(level)+'.txt.log');
      reset(f);
      if ioresult=0 then begin
         while not eof(f) do begin
               readln(f,s);
               p:=pos(';',s);
               if p>0 then begin
                  setlength(FirstSchussTabelle[level],i+1);
                  FirstSchussTabelle[level,i].x:=strtoint(copy(s,1,p-1));
                  FirstSchussTabelle[level,i].y:=strtoint(copy(s,p+1,length(s)));
                  inc(i);
               end;
         end;
         closefile(f);
      end;
      form2.bar.StepBy(1);
  end;
  {$I+}
end;

procedure berechne_winkel_Tabelle;
var w:integer;
    ww:double;
begin
  for w:=0 to 255 do begin
      ww:=360/256*w;
      winkel_Tabelle[w,0]:=ww;
      winkel_Tabelle[w,1]:=cos(ww*pi/180);
      winkel_Tabelle[w,2]:=sin(ww*pi/180);
  end;
end;


procedure tool_init;
begin
  form2.bar.Max:=256+32+3;
  form2.Bar.Position:=0;

  berechne_winkel_Tabelle; form2.bar.StepBy(1);
  schiff_richtung_tabelle_init; form2.bar.StepBy(1);
  WB_init;form2.bar.StepBy(1);

  init_FirstSchussTabelle;
  init_SRTabelle;

  form2.Bar.Position:=form2.bar.Max;
end;


end.

