/*
 * Decompiled with CFR 0.152.
 */
package gui;

import helpers.CombatMessages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class CombatEventPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int EVENT_LOG_SIZE = 8;
    private ImageIcon[] combatEventImages = new ImageIcon[8];
    private String[] combatEventTexts = new String[8];
    int index = 0;
    private DefaultTableModel combatEventModel = new DefaultTableModel(){
        private static final long serialVersionUID = 1L;

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ImageIcon.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return null;
        }

        @Override
        public int getRowCount() {
            return 8;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            int indexResult = CombatEventPanel.this.index;
            int i = 0;
            while (i < rowIndex) {
                if (--indexResult < 0) {
                    indexResult = 7;
                }
                ++i;
            }
            switch (columnIndex) {
                case 0: {
                    return CombatEventPanel.this.combatEventImages[indexResult];
                }
                case 1: {
                    return CombatEventPanel.this.combatEventTexts[indexResult];
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }
    };
    private TableCellRenderer imageRenderer = new TableCellRenderer(){
        private JLabel imageRenderLabel = new JLabel();
        private JLabel textRenderLabel = new JLabel();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Image) {
                this.imageRenderLabel.setIcon((ImageIcon)value);
                return this.imageRenderLabel;
            }
            if (value instanceof String) {
                if (row == 0) {
                    this.textRenderLabel.setBackground(Color.BLUE);
                    this.textRenderLabel.setForeground(Color.YELLOW);
                } else {
                    this.textRenderLabel.setBackground(Color.WHITE);
                    this.textRenderLabel.setForeground(Color.BLACK);
                }
                this.textRenderLabel.setText(value.toString());
                this.textRenderLabel.setOpaque(true);
                this.textRenderLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
                return this.textRenderLabel;
            }
            return null;
        }
    };

    public CombatEventPanel() {
        this.setBorder(new TitledBorder(new EtchedBorder(), "Combat Events"));
        this.setLayout(new BorderLayout());
        this.createCombatEventList(this.combatEventModel);
    }

    public void resetCombatEventList() {
        int i = 0;
        while (i < 8) {
            this.combatEventImages[i] = null;
            this.combatEventTexts[i] = null;
            ++i;
        }
        this.index = 0;
    }

    public void updateCombatEventList(int time, int message) {
        ++this.index;
        if (this.index >= 8) {
            this.index = 0;
        }
        this.combatEventImages[this.index] = CombatMessages.IMAGES[message];
        this.combatEventTexts[this.index] = String.valueOf(Integer.toString(time)) + " : " + CombatMessages.MESSAGES[message];
        this.combatEventModel.fireTableDataChanged();
    }

    public JTable createCombatEventList(TableModel model) {
        JTable result = new JTable(model);
        result.setEnabled(false);
        result.setRowHeight(32);
        result.getColumnModel().getColumn(0).setMaxWidth(32);
        result.getColumnModel().getColumn(1).setMinWidth(250);
        result.setDefaultRenderer(Object.class, this.imageRenderer);
        result.setBorder(new EmptyBorder(5, 5, 5, 5));
        result.setAlignmentX(0.0f);
        this.add((Component)result, "Center");
        return result;
    }
}

