/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class StatisticsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel[] scoreLabels;
    private JLabel[] sectorLabels;
    private JLabel[] asteroidsLabels;
    private JLabel[] shotsLabels;
    private JLabel[] shipLossLabels;
    private JLabel[] jumpsLabels;
    private JLabel[] ufosLabels;
    private JLabel[] targetRateLabels;
    private JLabel[] shotRateLabels;
    private JLabel[] hitRateLabels;
    private JLabel[] activityRateLabels;

    public StatisticsPanel() {
        this.setBorder(new TitledBorder(new EtchedBorder(), "Statistics"));
        this.setLayout(new BoxLayout(this, 3));
        int lWidth = 120;
        int vWidth = 90;
        this.scoreLabels = this.createLabelPair("Score:", lWidth, "0", vWidth);
        this.sectorLabels = this.createLabelPair("Space Sector:", lWidth, "00", vWidth);
        this.asteroidsLabels = this.createLabelPair("Asteroids In View:", lWidth, "00", vWidth);
        this.add(Box.createRigidArea(new Dimension(0, 20)));
        this.shotsLabels = this.createLabelPair("Shots Fired:", lWidth, "0", vWidth);
        this.shipLossLabels = this.createLabelPair("Ships Lost:", lWidth, "00", vWidth);
        this.jumpsLabels = this.createLabelPair("Jumps Performed:", lWidth, "00", vWidth);
        this.ufosLabels = this.createLabelPair("Saucer Encounters:", lWidth, "00", vWidth);
        this.add(Box.createRigidArea(new Dimension(0, 20)));
        this.targetRateLabels = this.createLabelPair("Target Rate:", lWidth, "0.00 / second", vWidth);
        this.shotRateLabels = this.createLabelPair("Shooting Rate:", lWidth, "0.00 / second", vWidth);
        this.hitRateLabels = this.createLabelPair("Hit Rate:", lWidth, "00.00 %", vWidth);
        this.activityRateLabels = this.createLabelPair("Activity Rate:", lWidth, "00.00 %", vWidth);
    }

    public void updateStatus(int score, int sector, int asteroids) {
        String format = "%,d";
        this.scoreLabels[1].setText(String.format(format, score));
        format = "%02d";
        this.sectorLabels[1].setText(String.format(format, sector));
        format = "%02d";
        this.asteroidsLabels[1].setText(String.format(format, asteroids));
    }

    public void updateActions(int shotsFired, int shipsLost, int jumpsPerformed, int saucersEncountered) {
        String format = "%,d";
        this.shotsLabels[1].setText(String.format(format, shotsFired));
        format = "%02d";
        this.shipLossLabels[1].setText(String.format(format, shipsLost));
        format = "%02d";
        this.jumpsLabels[1].setText(String.format(format, jumpsPerformed));
        format = "%02d";
        this.ufosLabels[1].setText(String.format(format, saucersEncountered));
    }

    public void updateRatings(float targetRate, float shootingRate, float hitRate, float activityRate) {
        String format = "%.2f / second";
        this.targetRateLabels[1].setText(String.format(format, Float.valueOf(targetRate)));
        format = "%.2f / second";
        this.shotRateLabels[1].setText(String.format(format, Float.valueOf(shootingRate)));
        format = "%.2f %%";
        this.hitRateLabels[1].setText(String.format(format, Float.valueOf(hitRate)));
        format = "%.2f %%";
        this.activityRateLabels[1].setText(String.format(format, Float.valueOf(activityRate)));
    }

    public JTextArea createStaticticsArea() {
        JTextArea result = new JTextArea();
        result.setEditable(false);
        result.setBorder(new EmptyBorder(5, 5, 5, 5));
        result.setAlignmentX(0.0f);
        JScrollPane pane = new JScrollPane(result);
        pane.setPreferredSize(new Dimension(300, 256));
        this.add((Component)pane, "Center");
        return result;
    }

    public JLabel[] createLabelPair(String label, int lWidth, String value, int vWidth) {
        JPanel result = new JPanel();
        JLabel[] labels = new JLabel[2];
        labels[0] = new JLabel(label);
        Dimension prefSize = labels[0].getPreferredSize();
        labels[0].setPreferredSize(new Dimension(lWidth, prefSize.height));
        labels[0].setAlignmentX(0.0f);
        labels[1] = new JLabel(value);
        prefSize = labels[1].getPreferredSize();
        labels[1].setPreferredSize(new Dimension(vWidth, prefSize.height));
        result.setLayout(new FlowLayout(3, 5, 0));
        result.setAlignmentX(0.0f);
        result.add(labels[0]);
        result.add(labels[1]);
        this.add(result);
        return labels;
    }
}

