/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import helpers.CombatStatistics;
import io.CombatState;
import objects.Asteroid;
import objects.Saucer;
import objects.Ship;
import objects.Shootable;
import objects.TargetObject;
import structures.TargetConfiguration;
import structures.TargetInformation;
import utils.Tables;
import utils.Utils;

public class CombatHeuristics {
    public static double getSaucerPrioritization(CombatState state, TargetConfiguration config, Saucer saucer, int asteroidNum) {
        if (CombatHeuristics.isSaucerCampingReasonable(state, config)) {
            return 0.0;
        }
        double prio = CombatHeuristics.getCollidingPrioritization(config);
        prio = saucer.getScale() == 14 ? (asteroidNum > 3 ? (prio *= 0.25) : (prio *= 0.75)) : (asteroidNum > 3 ? (prio *= 0.75) : (prio *= 1.25));
        return prio;
    }

    public static double getCollidingPrioritization(TargetConfiguration config) {
        if (config.collisionTime > 4 && config.collisionTime < 60) {
            return 0.5 + (double)(config.collisionTime / 120);
        }
        return 1.0;
    }

    public static boolean isMaxShotCountReached(TargetObject object) {
        int shotsFired = object.getTargetedStatus();
        switch (object.getScale()) {
            case 0: {
                if (shotsFired <= 3) break;
                return true;
            }
            case 14: {
                if (shotsFired <= 0) break;
                return true;
            }
            case 15: {
                if (!(object instanceof Saucer ? shotsFired > 0 : shotsFired > 2)) break;
                return true;
            }
        }
        return false;
    }

    public static boolean isTargetSwitchReasonable(TargetObject oldTarget, TargetConfiguration newTarget) {
        if (newTarget.object != oldTarget) {
            if (newTarget.collisionTime < 60) {
                if (oldTarget.getTargetedStatus() == 0) {
                    return true;
                }
                Ship ship = newTarget.ship;
                Shootable fastestTorpedo = ship.getFastestTorpedo();
                if (ship.getAvailableTorpedos() == 1 && fastestTorpedo != null && fastestTorpedo.getTimeToDestination() > newTarget.collisionTime - 3) {
                    return true;
                }
            } else if (newTarget.object.getMovementPrecision() < 8) {
                return oldTarget.getTargetedStatus() == 0;
            }
        }
        return false;
    }

    public static boolean isSaucerCampingReasonable(CombatState state, TargetConfiguration config) {
        if (CombatStatistics.getSectorSaucerCount() > 0 && state.isLastTargetLeft()) {
            int timeToNextSaucer = Tables.SAUCER_SPAWN_DELAY[Math.min(19, CombatStatistics.getGlobalSaucerCount())];
            int timePassed = CombatStatistics.getPassedSaucerWaitTime();
            if (timeToNextSaucer - (timePassed += config.getFinalTimeTaken() + 37 - 2) > 0 && timeToNextSaucer - timePassed < 60) {
                return true;
            }
        }
        return false;
    }

    public static boolean isTargetDifficult(TargetConfiguration config) {
        if (config.object.isMovementPrecise()) {
            int minDist;
            switch (config.object.getScale()) {
                case 0: {
                    minDist = 560;
                    break;
                }
                case 15: {
                    minDist = 272;
                    break;
                }
                default: {
                    minDist = 200;
                }
            }
            if (config.preCalc.distance > (double)minDist) {
                double angleDif;
                double directionDif = Math.abs(config.object.getMovementAngle() - Utils.getCounterAngle(config.info.angle));
                while (directionDif > Math.PI) {
                    directionDif -= Math.PI;
                }
                if (directionDif > 1.5707963267948966) {
                    directionDif = Math.PI - directionDif;
                }
                if (directionDif < 0.03681553890925539 && (angleDif = Math.abs(Utils.getAngleDif(Utils.TABLES.getAngle(config.angleIndex), config.preCalc.angle))) < 0.7853981633974483) {
                    double hitZone = CombatHeuristics.getHitZone(config.object);
                    double deviation = Utils.TABLES.sin(angleDif) * config.preCalc.distance;
                    if (deviation >= hitZone) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isTargetHittable(TargetConfiguration config, TargetInformation info) {
        if (Math.abs(info.angleDif) < 0.7853981633974483) {
            double hitZone = CombatHeuristics.getHitZone(config.object);
            double deviation = Utils.TABLES.sin(Math.abs(info.angleDif)) * info.distance;
            return deviation < hitZone || config.object.getTargetedStatus() > 0;
        }
        return false;
    }

    public static double getHitZone(TargetObject object) {
        double hitZone = object.getRadius();
        hitZone = hitZone > 8.0 ? (hitZone *= 0.666) : (hitZone *= 1.0);
        return hitZone;
    }

    public static double getImprovedHitZone(TargetObject object) {
        double hitZone = object.getRadius();
        hitZone = hitZone > 8.0 ? (hitZone *= 0.333) : (hitZone -= 1.0);
        return hitZone;
    }

    public static int getPrecisionDelay(double distance, TargetObject target) {
        int precision = 0;
        if (target != null) {
            precision = target.getMovementPrecision();
        }
        if (distance < 80.0) {
            return 0;
        }
        if (distance < 160.0) {
            return Math.max(0, 2 - precision);
        }
        if (distance < 240.0) {
            return Math.max(0, 4 - precision);
        }
        return Math.max(0, 8 - precision);
    }

    public static boolean willLoseChildren(TargetObject object, int asteroidNumber) {
        if (asteroidNumber > 24) {
            switch (object.getScale()) {
                case 0: {
                    return true;
                }
                case 14: {
                    return false;
                }
                case 15: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean willSpawnChildren(TargetObject target, CombatState state) {
        if (target != null && target instanceof Asteroid) {
            int targetedStatus = target.getTargetedStatus();
            switch (target.getScale()) {
                case 0: {
                    return targetedStatus > 0 && state.getAsteroidNumber() < 5 && !state.areTargetsLeft();
                }
                case 15: {
                    return targetedStatus > 0 && state.getAsteroidNumber() < 5 && !state.areTargetsLeft();
                }
            }
            return targetedStatus > 0 && state.getAsteroidNumber() < 5 && !state.areTargetsLeft();
        }
        return false;
    }
}

