/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CombatStatistics {
    public static final String STATISTICS_FILE = "./log/stats.txt";
    public static int TIME = 1;
    public static int PACKET_LOSS = 0;
    public static int IDLE_TIME = 0;
    public static int SPACE_SECTOR = 0;
    public static int DEATHS = 0;
    public static int ESCAPES = 0;
    public static int SHOTS_FIRED = 0;
    public static int SHOTS_MISSED = 0;
    public static int TARGET_COUNT = 0;
    public static int SECTOR_START_TIME = 0;
    private static int SCORE_BASE = 0;
    private static int SCORE = 0;
    private static int LAST_SAUCER_SPAWN_TIME = 0;
    private static int SECTOR_SAUCER_COUNT = 0;
    private static int GLOBAL_SAUCER_COUNT = 0;
    private static int SAUCER_SPAWN_DELAY = 0;

    public static void reset() {
        TIME = 1;
        PACKET_LOSS = 0;
        IDLE_TIME = 0;
        SCORE = 0;
        SPACE_SECTOR = 0;
        SCORE_BASE = 0;
        DEATHS = 0;
        ESCAPES = 0;
        SHOTS_FIRED = 0;
        SHOTS_MISSED = 0;
        TARGET_COUNT = 0;
        SPACE_SECTOR = 0;
    }

    public static void setNewGameStarted() {
        SPACE_SECTOR = 1;
        SECTOR_SAUCER_COUNT = 0;
        GLOBAL_SAUCER_COUNT = 0;
        SECTOR_START_TIME = TIME;
        LAST_SAUCER_SPAWN_TIME = 0;
        SECTOR_SAUCER_COUNT = 0;
        GLOBAL_SAUCER_COUNT = 0;
        SAUCER_SPAWN_DELAY = 0;
    }

    public static void setSectorFinished() {
        SECTOR_SAUCER_COUNT = 0;
        ++SPACE_SECTOR;
    }

    public static void setSaucerDestroyed() {
        ++SECTOR_SAUCER_COUNT;
        ++GLOBAL_SAUCER_COUNT;
        LAST_SAUCER_SPAWN_TIME = TIME;
        SAUCER_SPAWN_DELAY = 0;
    }

    public static void setScore(int score) {
        if (score < SCORE) {
            ++SCORE_BASE;
        }
        SCORE = score;
    }

    public static void dumpToFile() {
        try {
            FileOutputStream fileOut = new FileOutputStream(STATISTICS_FILE, true);
            PrintWriter writer = new PrintWriter(fileOut);
            SimpleDateFormat timeFormat = new SimpleDateFormat("dd.MM|HH:mm");
            Date time = new Date();
            writer.print(String.valueOf(timeFormat.format(time)) + "\t");
            writer.print(String.valueOf(TIME) + "\t");
            writer.print(String.valueOf(PACKET_LOSS) + "\t");
            writer.print(String.valueOf(CombatStatistics.getScore()) + "\t");
            writer.print(String.valueOf(SPACE_SECTOR) + "\t");
            writer.print(String.valueOf(DEATHS) + "\t");
            writer.print(String.valueOf(ESCAPES) + "\t");
            writer.print(String.valueOf(SHOTS_FIRED) + "\t");
            writer.print(String.valueOf(GLOBAL_SAUCER_COUNT) + "\t");
            writer.print(String.valueOf(CombatStatistics.getTargetRate()) + "\t");
            writer.print(String.valueOf(CombatStatistics.getShootingRate()) + "\t");
            writer.print(String.valueOf(CombatStatistics.getHitRate()) + "\t");
            writer.println(CombatStatistics.getActivityRate());
            writer.flush();
            writer.close();
            fileOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String dumpToScreen() {
        StringBuffer result = new StringBuffer();
        result.append("\n\n\nCombat Statistics");
        result.append("\n==============");
        result.append("\nTime: ");
        result.append(TIME);
        result.append("\nPacket Loss: ");
        result.append(PACKET_LOSS);
        result.append("\nIdle Time: ");
        result.append(IDLE_TIME);
        result.append("\nScore: ");
        result.append(CombatStatistics.getScore());
        result.append("\nSector: ");
        result.append(SPACE_SECTOR);
        result.append("\nLosses: ");
        result.append(DEATHS);
        result.append("\nEscapes: ");
        result.append(ESCAPES);
        String str = String.format("\nShots Fired: %d (%d hit)", SHOTS_FIRED, SHOTS_FIRED - SHOTS_MISSED);
        result.append(str);
        str = String.format("\nShots Missed: %d (%.2f%%)", SHOTS_MISSED, (double)(100 * SHOTS_MISSED) / (double)SHOTS_FIRED);
        result.append(str);
        return result.toString();
    }

    public static int getSectorSaucerCount() {
        return SECTOR_SAUCER_COUNT;
    }

    public static int getGlobalSaucerCount() {
        return GLOBAL_SAUCER_COUNT;
    }

    public static int getScore() {
        return SCORE_BASE * 100000 + SCORE;
    }

    public static float getTargetRate() {
        return (float)(60 * TARGET_COUNT) / (float)TIME;
    }

    public static float getShootingRate() {
        return (float)(60 * SHOTS_FIRED) / (float)TIME;
    }

    public static float getHitRate() {
        if (SHOTS_FIRED == 0) {
            return 100.0f;
        }
        return 100.0f * (1.0f - (float)SHOTS_MISSED / (float)SHOTS_FIRED);
    }

    public static float getActivityRate() {
        return 100.0f * (1.0f - (float)IDLE_TIME / (float)TIME);
    }

    public static int getPassedSaucerWaitTime() {
        return TIME - LAST_SAUCER_SPAWN_TIME - SAUCER_SPAWN_DELAY;
    }

    public static void increaseSaucerDelay() {
        if (TIME > LAST_SAUCER_SPAWN_TIME + 37) {
            ++SAUCER_SPAWN_DELAY;
        }
    }

    public static void exaggerateSaucerDelay() {
        SAUCER_SPAWN_DELAY = 100000;
    }
}

