/*
 * Decompiled with CFR 0.152.
 */
package objects;

import helpers.CombatStatistics;
import java.util.LinkedList;
import objects.CombatObject;
import objects.Shot;

public abstract class TargetObject
extends CombatObject {
    protected int numTargeted = 0;
    protected int targetedTime = -1;
    protected LinkedList<Shot> shotsFiredUpon = new LinkedList();

    public TargetObject(int x, int y) {
        super(x, y);
    }

    public void onTargeted() {
        ++this.numTargeted;
        this.targetedTime = CombatStatistics.TIME;
    }

    public void onFiredUpon(Shot shot) {
        this.shotsFiredUpon.add(shot);
    }

    public void onMissed(Shot shot) {
        if (this.isAlive && !this.shotsFiredUpon.isEmpty()) {
            if (shot == null) {
                this.shotsFiredUpon.removeLast();
            } else {
                this.shotsFiredUpon.remove(shot);
            }
            --this.numTargeted;
            this.targetedTime = -1;
        }
    }

    public int getTimeToHit() {
        if (this.shotsFiredUpon.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        return this.shotsFiredUpon.getLast().getTimeToDestination();
    }

    public LinkedList<Shot> getShotsFiredUpon() {
        return this.shotsFiredUpon;
    }

    public int getTargetedStatus() {
        return this.numTargeted;
    }

    public int getFiredUponStatus() {
        return this.shotsFiredUpon.size();
    }

    @Override
    public void update(int newX, int newY, int frameDif) {
        super.update(newX, newY, frameDif);
        this.updateTargetedStatus();
    }

    protected void updateTargetedStatus() {
        int numFiredUpon = this.shotsFiredUpon.size();
        if (this.numTargeted != numFiredUpon) {
            if (CombatStatistics.TIME - this.targetedTime > 2) {
                this.numTargeted = numFiredUpon;
            }
        } else if (this.targetedTime > -1 && CombatStatistics.TIME - this.targetedTime > 70) {
            this.onMissed(null);
        }
    }
}

